/*
 * Decompiled with CFR 0.152.
 */
package mergedoc.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mergedoc.core.Comment;
import mergedoc.core.FastStringUtils;
import mergedoc.core.PatternCache;
import mergedoc.core.Signature;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class APIDocument {
    private static final Log log = LogFactory.getLog(APIDocument.class);
    private final Map<Signature, Comment> contextTable = new HashMap<Signature, Comment>();
    private static final Pattern linkClassPattern = PatternCache.getPattern("(?si)<A\\s+HREF=\"([^\"]+)\"[^>]*><CODE>(.+?)</CODE></A>");

    public APIDocument(File docDir, String className, String charsetName) throws IOException {
        StringBuilder path = new StringBuilder();
        path.append(docDir.getPath());
        path.append(File.separator);
        path.append(className.replace('.', File.separatorChar));
        path.append(".html");
        CachedFile docFile = new CachedFile(path.toString());
        this.load(docDir, docFile, charsetName);
        String prefix = FastStringUtils.replaceFirst(docFile.getName(), "\\.html$", "");
        Pattern innerClass = Pattern.compile(prefix + "\\..+\\.html$");
        for (File f : ((File)docFile).listFiles()) {
            if (!innerClass.matcher(f.getName()).matches()) continue;
            this.load(docDir, f, charsetName);
        }
    }

    private void load(File docDir, File docFile, String charsetName) throws IOException {
        if (!docFile.exists()) {
            return;
        }
        FileInputStream is = new FileInputStream(docFile);
        byte[] buf = new byte[((InputStream)is).available()];
        ((InputStream)is).read(buf);
        ((InputStream)is).close();
        String docHtml = new String(buf, charsetName);
        docHtml = FastStringUtils.optimizeLineSeparator(docHtml);
        docHtml = docHtml.replace('\t', ' ');
        char wavaDash = (char)Integer.decode("0x301c").intValue();
        docHtml = docHtml.replace(wavaDash, '\uff5e');
        String className = FastStringUtils.replaceFirst(docFile.getPath(), "\\.html$", "");
        className = className.replace(docDir.getPath() + File.separator, "");
        className = className.replace(File.separatorChar, '.');
        if (className.equals("java.lang.StringBuffer") || className.equals("java.lang.StringBuilder")) {
            docHtml = docHtml.replace("%20", "");
        }
        this.parseClassComment(className, docHtml);
        this.parseMethodComment(className, docHtml);
    }

    public boolean isEmpty() {
        return this.contextTable.isEmpty();
    }

    public Comment getComment(Signature signature) {
        Comment comment = this.contextTable.get(signature);
        return comment;
    }

    private void parseClassComment(String className, CharSequence docHtml) {
        String baseRegex = "(?si)<HR>\\s*(|<B>.+?<P>\\s*)<DL>\\s*<DT>\\s*<PRE>(.+?)</B>.*?(</DL>\\s*</PRE>\\s*<P>|</PRE>\\s*</DT>\\s*</DL>\\s*<P>)\\s*(.+?)\\s*<P>\\s*<!-- =";
        Pattern pattern = PatternCache.getPattern(baseRegex);
        Matcher matcher = pattern.matcher(docHtml);
        if (matcher.find()) {
            String sigStr = matcher.group(2);
            Signature sig = this.createSignature(className, sigStr);
            Comment comment = new Comment(sig);
            String depre = matcher.group(1);
            this.parseDeprecatedTag(className, depre, comment);
            String context = matcher.group(4);
            Pattern pat = PatternCache.getPattern("(?si)(.+?)\\s*(<P>(|</P>)\\s*){2}");
            Matcher mat = pat.matcher(context);
            if (mat.find()) {
                String body = mat.group(1);
                body = this.formatLinkTag(className, body);
                comment.setDocumentBody(body);
            }
            this.parseCommonTag(className, context, comment);
            this.contextTable.put(sig, comment);
        }
    }

    private void parseMethodComment(String className, CharSequence docHtml) {
        String baseRegex = "(?si)<A NAME=.+?<!-- --></A>.+?</H3>\n<PRE>\\s*(.*?)</PRE>\n(.+?)(<HR>|<!-- =)";
        Pattern pattern = PatternCache.getPattern(baseRegex);
        Matcher matcher = pattern.matcher(docHtml);
        while (matcher.find()) {
            String desc;
            String name;
            Matcher m;
            Pattern p;
            String items;
            String sigStr = matcher.group(1);
            Signature sig = this.createSignature(className, sigStr);
            Comment comment = new Comment(sig);
            String context = matcher.group(2);
            String bodyRegex = "(?si)<DL>\\s*<DD>(.*?)\\s*(|</DL>\\s*)<P>(|</P>)\\s*(</DL>\\s*|<DL>\\s*<DT>|<DL>\\s*</DL>|<DD>\\s*<DL>|</DD>\\s*</DL>|</DD>\\s*<DD>)";
            Pattern pat = PatternCache.getPattern(bodyRegex);
            Matcher mat = pat.matcher(context);
            if (mat.find()) {
                String body = mat.group(1);
                body = FastStringUtils.replaceFirst(body, "(?si)<B>\u63a8\u5968\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002.*?(<P>\\s*<DD>|$|</B>(\\s*|&nbsp;)<DD>)", "");
                body = this.formatLinkTag(className, body);
                comment.setDocumentBody(body);
            }
            if (context.contains("\u30d1\u30e9\u30e1\u30fc\u30bf:") && (mat = (pat = PatternCache.getPattern("(?si)<DT><B>\u30d1\u30e9\u30e1\u30fc\u30bf:</B>(.+?(</DL>|<DT>|$))")).matcher(context)).find()) {
                items = mat.group(1);
                p = PatternCache.getPattern("(?si)<CODE>(.+?)</CODE> - (.*?)(<DD>|</DD>|</DL>|<DT>|$)");
                m = p.matcher(items);
                while (m.find()) {
                    name = m.group(1);
                    desc = this.formatLinkTag(className, m.group(2));
                    String param = name + " " + desc;
                    comment.addParam(param);
                }
            }
            if (context.contains("\u623b\u308a\u5024:") && (mat = (pat = PatternCache.getPattern("(?si)<DT><B>\u623b\u308a\u5024:</B><DD>(.+?)(</DL>|<DT>)")).matcher(context)).find()) {
                String str = mat.group(1);
                str = this.formatLinkTag(className, str);
                comment.addReturn(str);
            }
            if (context.contains("\u4f8b\u5916:") && (mat = (pat = PatternCache.getPattern("(?si)<DT><B>\u4f8b\u5916:</B>\\s*(<DD>.+?(</DL>|<DT>|$))")).matcher(context)).find()) {
                items = mat.group(1);
                p = PatternCache.getPattern("(?si)<CODE>(.+?)</CODE>\\s*-\\s*(.*?)(<DD>|</DD>|</DL>|<DT>|$)");
                m = p.matcher(items);
                while (m.find()) {
                    name = FastStringUtils.replaceAll(m.group(1), "(?si)(<A\\s.+?>|</A>)", "");
                    desc = m.group(2);
                    desc = this.formatLinkTag(className, desc);
                    comment.addThrows(name + " " + desc);
                }
            }
            this.parseDeprecatedTag(className, context, comment);
            this.parseCommonTag(className, context, comment);
            this.contextTable.put(sig, comment);
        }
    }

    private Signature createSignature(String className, String sig) {
        sig = FastStringUtils.replaceAll(sig, "(?s)<.+?>", " ");
        sig = FastStringUtils.replaceAll(sig, "\\&nbsp;", " ");
        sig = FastStringUtils.replaceAll(sig, "\\&lt;", "<");
        sig = FastStringUtils.replaceAll(sig, "\\&gt;", ">");
        sig = FastStringUtils.replaceFirst(sig, "(?s)\\sthrows\\s.*", "");
        Signature signature = new Signature(className, sig);
        return signature;
    }

    private void parseCommonTag(String className, String context, Comment comment) {
        Pattern pat;
        Matcher mat;
        if (context.contains("\u95a2\u9023\u9805\u76ee:") && (mat = (pat = PatternCache.getPattern("(?si)<DT><B>\u95a2\u9023\u9805\u76ee:.+?<DD>(.+?)</DL>")).matcher(context)).find()) {
            String items = mat.group(1);
            Matcher linkMatcher = linkClassPattern.matcher(items);
            while (linkMatcher.find()) {
                String url = linkMatcher.group(1);
                String ref = this.formatClassName(className, url);
                ref = FastStringUtils.replace(ref, "%28", "(");
                ref = FastStringUtils.replace(ref, "%29", ")");
                comment.addSee(ref);
            }
        }
        if (context.contains("\u5c0e\u5165\u3055\u308c\u305f\u30d0\u30fc\u30b8\u30e7\u30f3:") && (mat = (pat = PatternCache.getPattern("(?si)<DT><B>\u5c0e\u5165\u3055\u308c\u305f\u30d0\u30fc\u30b8\u30e7\u30f3:.*?<DD>(.+?)\\s*(</DL>|</DD>)")).matcher(context)).find()) {
            comment.addSince(mat.group(1));
        }
    }

    private void parseDeprecatedTag(String className, String context, Comment comment) {
        Pattern pat;
        Matcher mat;
        if (context.contains("\u63a8\u5968\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002") && (mat = (pat = PatternCache.getPattern("(?si)<B>\u63a8\u5968\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002.+?<I>(.+?)</I>")).matcher(context)).find()) {
            String str = mat.group(1);
            str = this.formatLinkTag(className, str);
            comment.addDeprecated(str);
        }
    }

    private String formatLinkTag(String className, String html) {
        StringBuffer sb = new StringBuffer();
        Matcher linkMatcher = linkClassPattern.matcher(html);
        while (linkMatcher.find()) {
            String url = linkMatcher.group(1).trim();
            String label = linkMatcher.group(2).trim();
            String ref = this.formatClassName(className, url);
            StringBuilder link = new StringBuilder();
            link.append("{@link ");
            link.append(ref);
            if (label.length() > 0 && !(ref = ref.replace('#', '.')).endsWith(label)) {
                link.append(" ");
                link.append(label);
            }
            link.append("}");
            linkMatcher.appendReplacement(sb, link.toString());
        }
        linkMatcher.appendTail(sb);
        html = sb.toString();
        return html;
    }

    private String formatClassName(String className, String path) {
        String lastClassName = FastStringUtils.replaceFirst(className, ".+\\.", "");
        String packageName = className.replace("." + lastClassName, "");
        String lastClassPrefix = "\\.([A-Z])";
        path = FastStringUtils.replace(path, ".html", "");
        path = path.replace('/', '.');
        path = FastStringUtils.replaceFirst(path, "^\\.*", "");
        path = FastStringUtils.replaceAll(path, "java.lang" + lastClassPrefix, "$1");
        path = path.replaceAll(packageName + lastClassPrefix, "$1");
        path = path.replaceAll(lastClassName + "#", "#");
        return path;
    }

    private static class CachedFile
    extends File {
        private static File cachedDir;
        private static File[] cachedFiles;
        private static final File[] EMPTY_FILES;

        public CachedFile(String path) {
            super(path);
        }

        public File[] listFiles() {
            File dir = this.getParentFile();
            if (!dir.equals(cachedDir)) {
                cachedDir = dir;
                cachedFiles = dir.listFiles();
                if (cachedFiles == null) {
                    cachedFiles = EMPTY_FILES;
                }
            }
            return cachedFiles;
        }

        static {
            EMPTY_FILES = new File[0];
        }
    }
}

