/*
 * Decompiled with CFR 0.152.
 */
package mergedoc.ui;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.geom.Dimension2D;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class ComponentFactory {
    private static final Dimension maxDimension = new Dimension(3200, 2400){

        public void setSize(Dimension dimension) {
        }

        public void setSize(double d, double d2) {
        }

        public void setSize(int n, int n2) {
        }

        public void setSize(Dimension2D dimension2D) {
        }
    };

    private ComponentFactory() {
    }

    public static Dimension createMaxDimension() {
        return maxDimension;
    }

    public static JComponent createSpacer(int n, int n2) {
        JLabel jLabel = new JLabel();
        ComponentFactory.ensureSize(jLabel, n, n2);
        return jLabel;
    }

    public static void ensureSize(JComponent jComponent, int n, int n2) {
        Dimension dimension = new Dimension(n, n2);
        jComponent.setPreferredSize(dimension);
        jComponent.setMinimumSize(dimension);
        jComponent.setMaximumSize(dimension);
    }

    public static JScrollPane createScrollPane(JComponent jComponent) {
        JScrollPane jScrollPane = new JScrollPane(jComponent);
        ComponentFactory.setupVerticalScrollPane(jScrollPane);
        return jScrollPane;
    }

    public static void setupVerticalScrollPane(JScrollPane jScrollPane) {
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(20);
    }

    public static void ensureMaxFontWidth(JComponent[] jComponentArray) {
        JComponent jComponent;
        int n;
        int n2 = 0;
        for (n = 0; n < jComponentArray.length; ++n) {
            jComponent = jComponentArray[n];
            FontMetrics fontMetrics = jComponent.getFontMetrics(jComponent.getFont());
            int n3 = 0;
            if (jComponent instanceof JLabel) {
                n3 = fontMetrics.stringWidth(((JLabel)jComponent).getText());
            } else if (jComponent instanceof JComboBox) {
                ComboBoxModel comboBoxModel = ((JComboBox)jComponent).getModel();
                for (int i = 0; i < comboBoxModel.getSize(); ++i) {
                    n3 = fontMetrics.stringWidth(comboBoxModel.getElementAt(i).toString());
                    if ((n3 += 30) <= n2) continue;
                    n2 = n3;
                }
            } else {
                throw new IllegalArgumentException("\u5f15\u6570\u306f JLabel[] \u307e\u305f\u306f JComboBox[] \u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002");
            }
            if (n3 <= n2) continue;
            n2 = n3;
        }
        for (n = 0; n < jComponentArray.length; ++n) {
            jComponent = jComponentArray[n];
            ComponentFactory.ensureSize(jComponent, n2, 20);
        }
    }
}

