/*
 * Decompiled with CFR 0.152.
 */
package mergedoc.core;

import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mergedoc.core.APIDocument;
import mergedoc.core.Comment;
import mergedoc.core.JavaBuffer;
import mergedoc.core.Signature;
import mergedoc.core.StringUtils;

public class Merger {
    private String className;
    private File docDirectory;
    private String docEncoding = System.getProperty("file.encoding");

    public Merger(File file) {
        this.docDirectory = file;
    }

    public void setDocEncoding(String string) {
        this.docEncoding = string;
    }

    public String merge(String string) throws IOException {
        Object object;
        String string2 = StringUtils.optimizeLineSeparator(string);
        this.className = this.scanClassName(string2);
        if (this.className == null) {
            return string2;
        }
        APIDocument aPIDocument = new APIDocument(this.docDirectory, this.className, this.docEncoding);
        if (aPIDocument.isEmpty()) {
            return string2;
        }
        JavaBuffer javaBuffer = new JavaBuffer(this.className, string2);
        while (javaBuffer.nextComment()) {
            object = javaBuffer.getSignature();
            Comment comment = aPIDocument.getComment((Signature)object);
            javaBuffer.setLocalizedComment(comment);
        }
        object = javaBuffer.finishToString();
        return object;
    }

    private String scanClassName(String string) {
        Pattern pattern = Pattern.compile("(?m)^\\s*package\\s+([\\w\\.]+)");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1);
            String string3 = "(?m)^(|[\\w\\s]*?\\s+|.*?\\*/\\s+)(class|interface)\\s+(\\w+)";
            Pattern pattern2 = Pattern.compile(string3);
            Matcher matcher2 = pattern2.matcher(string);
            if (matcher2.find()) {
                String string4 = string2 + "." + matcher2.group(3);
                return string4;
            }
        }
        return null;
    }

    public String getMergedClassName() {
        return this.className;
    }
}

