/*
 * Decompiled with CFR 0.152.
 */
package mergedoc.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mergedoc.core.Comment;
import mergedoc.core.Signature;
import mergedoc.core.StringUtils;
import mergedoc.log.TraceLogger;

public class JavaBuffer {
    private final String className;
    private final String source;
    private List importPaths;
    private static final Pattern commentPattern = Pattern.compile("^[ \t]*?/\\*\\*.*?\\*/[ \t]*?\n", 40);
    private final Matcher commentMatcher;
    private final StringBuffer outputBuffer = new StringBuffer();
    private final Stack classStack = new Stack();
    private static final String DUMMY_COMMENT = " Empty comment. " + (class$mergedoc$core$JavaBuffer == null ? (class$mergedoc$core$JavaBuffer = JavaBuffer.class$("mergedoc.core.JavaBuffer")) : class$mergedoc$core$JavaBuffer).getName() + ". ";
    private static final Logger logger = TraceLogger.getLogger();
    static /* synthetic */ Class class$mergedoc$core$JavaBuffer;

    public JavaBuffer(String string, String string2) {
        this.className = string;
        this.source = this.setupDummyComment(string2);
        this.commentMatcher = commentPattern.matcher(this.source);
        ClassBlock classBlock = new ClassBlock(string, this.source.length());
        this.classStack.push(classBlock);
        Pattern pattern = Pattern.compile("(?m)^\\s?import\\s+([\\w\\.]*)");
        Matcher matcher = pattern.matcher(this.source);
        while (matcher.find()) {
            String string3 = matcher.group(1);
            if (this.importPaths == null) {
                this.importPaths = new ArrayList();
            }
            this.importPaths.add(string3);
        }
    }

    private String setupDummyComment(String string) {
        int n;
        int n2;
        char[] cArray = string.toCharArray();
        int n3 = cArray.length - 1;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 11; i <= n3; ++i) {
            if (cArray[i - 1] == '/' && cArray[i] == '*') {
                ++i;
                while (i <= n3 && (cArray[i - 1] != '*' || cArray[i] != '/')) {
                    ++i;
                }
            } else if (cArray[i - 1] == '/' && cArray[i] == '/') {
                ++i;
                while (i <= n3) {
                    if (cArray[i] == '\n') {
                        ++i;
                        break;
                    }
                    ++i;
                }
            } else if (cArray[i - 1] != '\\' && cArray[i - 1] != '\'' && cArray[i] == '\"') {
                ++i;
                while (i <= n3 && (cArray[i - 1] == '\\' || cArray[i - 1] == '\'' || cArray[i] != '\"')) {
                    ++i;
                }
            }
            if (i >= n3) break;
            n2 = -1;
            if (cArray[i] == ' ' || cArray[i] == '\n' || cArray[i] == '\t') {
                if (cArray[i - 5] == 'c' && cArray[i - 4] == 'l' && cArray[i - 3] == 'a' && cArray[i - 2] == 's' && cArray[i - 1] == 's') {
                    if (cArray[i - 6] == ' ' || cArray[i - 6] == '\n' || cArray[i - 6] == '\t') {
                        n2 = i - 7;
                    }
                } else if (cArray[i - 9] == 'i' && cArray[i - 8] == 'n' && cArray[i - 7] == 't' && cArray[i - 6] == 'e' && cArray[i - 5] == 'r' && cArray[i - 4] == 'f' && cArray[i - 3] == 'a' && cArray[i - 2] == 'c' && cArray[i - 1] == 'e' && (cArray[i - 10] == ' ' || cArray[i - 10] == '\n' || cArray[i - 10] == '\t')) {
                    n2 = i - 11;
                }
            }
            while (n2 > 0 && (cArray[n2 - 1] != '*' || cArray[n2] != '/')) {
                if (cArray[n2] == ';' || cArray[n2] == '}' || cArray[n2] == '{') {
                    block5: for (n = n2 - 1; n > 0 && (cArray[n - 1] != '/' || cArray[n] != '/'); --n) {
                        if (cArray[n] != '\n') continue;
                        for (int j = n2 + 1; j < i; ++j) {
                            if (cArray[j] != '\n') continue;
                            arrayList.add(new Integer(j + 1));
                            n = -1;
                            n2 = -1;
                            continue block5;
                        }
                    }
                }
                --n2;
            }
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        for (n2 = arrayList.size() - 1; n2 >= 0; --n2) {
            n = (Integer)arrayList.get(n2);
            stringBuffer.insert(n, "/**" + DUMMY_COMMENT + "*/\n");
        }
        return stringBuffer.toString();
    }

    public boolean nextComment() {
        while (this.commentMatcher.find()) {
            String string;
            int n;
            String string2 = this.getSourceComment();
            if (string2.matches("\\s*/\\*+/\\s*\n")) continue;
            if (string2.matches(".*?" + DUMMY_COMMENT + ".*\n")) {
                this.getSignature();
                this.commentMatcher.appendReplacement(this.outputBuffer, "");
                continue;
            }
            Matcher matcher = commentPattern.matcher(this.source);
            if (matcher.find(n = this.commentMatcher.end()) && (string = this.source.substring(n, matcher.start())).matches("\\s*")) continue;
            return true;
        }
        return false;
    }

    private String getSourceComment() {
        return this.commentMatcher.group().toString();
    }

    public Signature getSignature() {
        int n = this.commentMatcher.end();
        String string = this.source.substring(n, this.source.length());
        Pattern pattern = Pattern.compile("(?s)(.+?)(throws|\\{|\\=|;)");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            ClassBlock classBlock = (ClassBlock)this.classStack.peek();
            if (n > classBlock.end) {
                this.classStack.pop();
                classBlock = (ClassBlock)this.classStack.peek();
            }
            String string2 = matcher.group(1);
            Signature signature = new Signature(classBlock.name, string2 = string2.replaceFirst("(?s)/\\*[^\\*].*?\\*/\\s*", ""));
            if (signature.isDeclareInnerClass()) {
                String string3 = signature.getClassName();
                int n2 = this.searchEndOfInner(string, string3);
                classBlock = new ClassBlock(string3, n2);
                this.classStack.push(classBlock);
            }
            return signature;
        }
        return null;
    }

    private int searchEndOfInner(String string, String string2) {
        int n = 1;
        for (int i = string.indexOf(123) + 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '{') {
                ++n;
            }
            if (c == '}') {
                --n;
            }
            if (n != 0) continue;
            return this.commentMatcher.end() + i;
        }
        logger.warning("\u30a4\u30f3\u30ca\u30fc\u30af\u30e9\u30b9 " + this.className + "#" + string2 + " \u306e\u7d42\u4e86\u4f4d\u7f6e\u304c\u691c\u51fa\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
        return -1;
    }

    public void setLocalizedComment(Comment comment) {
        if (comment == null) {
            return;
        }
        comment.setImportPaths(this.importPaths);
        comment.mergeSourceComment(this.getSourceComment());
        String string = comment.toString();
        if (string == null || string.length() == 0) {
            return;
        }
        string = StringUtils.escapeMetaCharactor(string);
        this.commentMatcher.appendReplacement(this.outputBuffer, string);
    }

    public String finishToString() {
        this.commentMatcher.appendTail(this.outputBuffer);
        String string = this.outputBuffer.toString();
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ClassBlock {
        final String name;
        final int end;

        ClassBlock(String string, int n) {
            this.name = string;
            this.end = n;
        }
    }
}

