/*
 * Decompiled with CFR 0.152.
 */
package mergedoc.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import mergedoc.MergeDocException;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;

public abstract class ArchiveInputStream {
    private ArchiveInputStream() {
    }

    public static ArchiveInputStream create(File file) throws IOException, MergeDocException {
        String string = file.getName();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        if (string.endsWith(".zip") || string.endsWith(".jar")) {
            return new ZipStreamProxy(new ZipInputStream(bufferedInputStream));
        }
        if (string.endsWith(".tar.gz")) {
            try {
                return new TarStreamProxy(new TarInputStream((InputStream)new GZIPInputStream(bufferedInputStream)));
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                throw new MergeDocException("\u30d5\u30a1\u30a4\u30eb\u5f62\u5f0f .tar.gz \u3092\u4f7f\u7528\u3059\u308b\u5834\u5408\u306f ant.jar \u3092\nmergedoc.jar \u3068\u540c\u3058\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306b\u914d\u7f6e\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            }
        }
        throw new IllegalArgumentException("\u3053\u306e\u30d5\u30a1\u30a4\u30eb\u5f62\u5f0f\u306f\u30b5\u30dd\u30fc\u30c8\u3057\u307e\u305b\u3093\u3002\n" + string);
    }

    public abstract void close() throws IOException;

    public abstract Entry getNextEntry() throws IOException;

    public abstract int read(byte[] var1) throws IOException;

    private static class TarEntryProxy
    implements Entry {
        TarEntry entry;

        TarEntryProxy(TarEntry tarEntry) {
            this.entry = tarEntry;
        }

        public String getName() {
            return this.entry.getName();
        }
    }

    private static class TarStreamProxy
    extends ArchiveInputStream {
        TarInputStream is;

        TarStreamProxy(TarInputStream tarInputStream) {
            this.is = tarInputStream;
        }

        public void close() throws IOException {
            this.is.close();
        }

        public Entry getNextEntry() throws IOException {
            TarEntry tarEntry = this.is.getNextEntry();
            return tarEntry != null ? new TarEntryProxy(tarEntry) : null;
        }

        public int read(byte[] byArray) throws IOException {
            return this.is.read(byArray);
        }
    }

    private static class ZipEntryProxy
    implements Entry {
        ZipEntry entry;

        ZipEntryProxy(ZipEntry zipEntry) {
            this.entry = zipEntry;
        }

        public String getName() {
            return this.entry.getName();
        }
    }

    private static class ZipStreamProxy
    extends ArchiveInputStream {
        ZipInputStream is;

        ZipStreamProxy(ZipInputStream zipInputStream) {
            this.is = zipInputStream;
        }

        public void close() throws IOException {
            this.is.close();
        }

        public Entry getNextEntry() throws IOException {
            ZipEntry zipEntry = this.is.getNextEntry();
            return zipEntry != null ? new ZipEntryProxy(zipEntry) : null;
        }

        public int read(byte[] byArray) throws IOException {
            return this.is.read(byArray);
        }
    }

    public static interface Entry {
        public String getName();
    }
}

