/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.MethodRefParameter;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.internal.compiler.parser.AbstractCommentParser;
import org.eclipse.jdt.internal.compiler.parser.Scanner;

class DocCommentParser
extends AbstractCommentParser {
    private Javadoc docComment;
    private AST ast;

    DocCommentParser(AST ast, Scanner scanner, boolean check) {
        super(null);
        this.ast = ast;
        this.scanner = scanner;
        this.checkDocComment = check;
        this.kind = 2;
    }

    public Javadoc parse(int[] positions) {
        return this.parse(positions[0], positions[1] - positions[0]);
    }

    public Javadoc parse(int start, int length) {
        this.source = this.scanner.source;
        this.lineEnds = this.scanner.lineEnds;
        this.docComment = this.ast.newJavadoc();
        if (this.checkDocComment) {
            this.parseComment(start, start + length - 1);
        }
        this.docComment.setSourceRange(start, length);
        this.setComment(start, length);
        return this.docComment;
    }

    private void setComment(int start, int length) {
        this.docComment.setComment(new String(this.source, start, length));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("javadoc: ").append(this.docComment).append("\n");
        buffer.append(super.toString());
        return buffer.toString();
    }

    protected Object createArgumentReference(char[] name, int dim, Object typeRef, long[] dimPositions, long argNamePos) throws InvalidInputException {
        try {
            MethodRefParameter argument = this.ast.newMethodRefParameter();
            ASTNode node = (ASTNode)typeRef;
            int argStart = node.getStartPosition();
            int argEnd = node.getStartPosition() + node.getLength() - 1;
            if (dim > 0) {
                argEnd = (int)dimPositions[dim - 1];
            }
            if (argNamePos >= 0L) {
                argEnd = (int)argNamePos;
            }
            if (name.length != 0) {
                SimpleName argName = this.ast.newSimpleName(new String(name));
                argument.setName(argName);
                int argNameStart = (int)(argNamePos >>> 32);
                argName.setSourceRange(argNameStart, argEnd - argNameStart + 1);
            }
            Type argType = null;
            if (node.getNodeType() == 39) {
                argType = (PrimitiveType)node;
            } else {
                Name argTypeName = (Name)node;
                argType = this.ast.newSimpleType(argTypeName);
                argType.setSourceRange(argStart, node.getLength());
            }
            if (dim > 0) {
                int i = 0;
                while (i < dim) {
                    argType = this.ast.newArrayType(argType);
                    argType.setSourceRange(argStart, (int)dimPositions[i] - argStart + 1);
                    ++i;
                }
            }
            argument.setType(argType);
            argument.setSourceRange(argStart, argEnd - argStart + 1);
            return argument;
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException();
        }
    }

    protected Object createFieldReference(Object receiver) throws InvalidInputException {
        try {
            MemberRef fieldRef = this.ast.newMemberRef();
            SimpleName fieldName = this.ast.newSimpleName(new String(this.identifierStack[0]));
            fieldRef.setName(fieldName);
            int start = (int)(this.identifierPositionStack[0] >>> 32);
            int end = (int)this.identifierPositionStack[0];
            fieldName.setSourceRange(start, end - start + 1);
            if (receiver == null) {
                start = this.memberStart;
                fieldRef.setSourceRange(start, end - start + 1);
            } else {
                Name typeRef = (Name)receiver;
                fieldRef.setQualifier(typeRef);
                start = typeRef.getStartPosition();
                end = fieldName.getStartPosition() + fieldName.getLength() - 1;
                fieldRef.setSourceRange(start, end - start + 1);
            }
            return fieldRef;
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException();
        }
    }

    protected Object createMethodReference(Object receiver, List arguments) throws InvalidInputException {
        try {
            MethodRef methodRef = this.ast.newMethodRef();
            SimpleName methodName = this.ast.newSimpleName(new String(this.identifierStack[0]));
            methodRef.setName(methodName);
            int start = (int)(this.identifierPositionStack[0] >>> 32);
            int end = (int)this.identifierPositionStack[0];
            methodName.setSourceRange(start, end - start + 1);
            if (receiver == null) {
                start = this.memberStart;
                methodRef.setSourceRange(start, end - start + 1);
            } else {
                Name typeRef = (Name)receiver;
                methodRef.setQualifier(typeRef);
                start = typeRef.getStartPosition();
            }
            if (arguments != null) {
                ListIterator parameters = arguments.listIterator();
                while (parameters.hasNext()) {
                    MethodRefParameter param = (MethodRefParameter)parameters.next();
                    methodRef.parameters().add(param);
                }
            }
            methodRef.setSourceRange(start, this.scanner.getCurrentTokenEndPosition() - start + 1);
            return methodRef;
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException();
        }
    }

    protected Object createTypeReference(int primitiveToken) {
        int size = this.identifierLengthStack[this.identifierLengthPtr--];
        String[] identifiers = new String[size];
        int pos = this.identifierPtr - size + 1;
        int i = 0;
        while (i < size) {
            identifiers[i] = new String(this.identifierStack[pos + i]);
            ++i;
        }
        ASTNode typeRef = null;
        if (primitiveToken == -1) {
            typeRef = this.ast.newName(identifiers);
        } else {
            switch (primitiveToken) {
                case 39: {
                    typeRef = this.ast.newPrimitiveType(PrimitiveType.VOID);
                    break;
                }
                case 31: {
                    typeRef = this.ast.newPrimitiveType(PrimitiveType.BOOLEAN);
                    break;
                }
                case 32: {
                    typeRef = this.ast.newPrimitiveType(PrimitiveType.BYTE);
                    break;
                }
                case 33: {
                    typeRef = this.ast.newPrimitiveType(PrimitiveType.CHAR);
                    break;
                }
                case 34: {
                    typeRef = this.ast.newPrimitiveType(PrimitiveType.DOUBLE);
                    break;
                }
                case 35: {
                    typeRef = this.ast.newPrimitiveType(PrimitiveType.FLOAT);
                    break;
                }
                case 36: {
                    typeRef = this.ast.newPrimitiveType(PrimitiveType.INT);
                    break;
                }
                case 37: {
                    typeRef = this.ast.newPrimitiveType(PrimitiveType.LONG);
                    break;
                }
                case 38: {
                    typeRef = this.ast.newPrimitiveType(PrimitiveType.SHORT);
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        int start = (int)(this.identifierPositionStack[pos] >>> 32);
        if (size > 1) {
            ASTNode name = typeRef;
            int i2 = this.identifierPtr;
            while (i2 > pos) {
                int s = (int)(this.identifierPositionStack[i2] >>> 32);
                int e = (int)this.identifierPositionStack[i2];
                SimpleName simpleName = ((QualifiedName)name).getName();
                simpleName.setSourceRange(s, e - s + 1);
                name.setSourceRange(start, e - start + 1);
                name = ((QualifiedName)name).getQualifier();
                --i2;
            }
            int end = (int)this.identifierPositionStack[pos];
            name.setSourceRange(start, end - start + 1);
        } else {
            int end = (int)this.identifierPositionStack[pos];
            typeRef.setSourceRange(start, end - start + 1);
        }
        this.identifierPtr -= size;
        return typeRef;
    }

    protected boolean parseReturn() {
        return this.parseTag();
    }

    protected boolean parseTag() {
        TagElement tag = this.ast.newTagElement();
        int start = this.tagSourceStart;
        tag.setTagName(new String(this.source, start, this.tagSourceEnd - start + 1));
        if (this.inlineTagStarted) {
            start = this.inlineTagStart;
            TagElement previousTag = null;
            if (this.astPtr == -1) {
                previousTag = this.ast.newTagElement();
                previousTag.setSourceRange(start, this.tagSourceEnd - start + 1);
                this.pushOnAstStack(previousTag, true);
            } else {
                previousTag = (TagElement)this.astStack[this.astPtr];
            }
            int previousStart = previousTag.getStartPosition();
            previousTag.fragments().add(tag);
            previousTag.setSourceRange(previousStart, this.tagSourceEnd - previousStart + 1);
        } else {
            this.pushOnAstStack(tag, true);
        }
        tag.setSourceRange(start, this.tagSourceEnd - start + 1);
        return true;
    }

    protected boolean pushParamName() {
        SimpleName name = this.ast.newSimpleName(new String(this.scanner.getCurrentIdentifierSource()));
        name.setSourceRange(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition() - this.scanner.getCurrentTokenStartPosition() + 1);
        TagElement paramTag = this.ast.newTagElement();
        paramTag.setTagName("@param");
        paramTag.setSourceRange(this.tagSourceStart, this.scanner.getCurrentTokenEndPosition() - this.tagSourceStart + 1);
        paramTag.fragments().add(name);
        this.pushOnAstStack(paramTag, true);
        return true;
    }

    protected boolean pushSeeRef(Object statement, boolean plain) {
        TagElement seeTag = this.ast.newTagElement();
        ASTNode node = (ASTNode)statement;
        seeTag.fragments().add(node);
        int end = node.getStartPosition() + node.getLength() - 1;
        if (this.inlineTagStarted) {
            seeTag.setSourceRange(this.inlineTagStart, end - this.inlineTagStart + 1);
            if (plain) {
                seeTag.setTagName("@linkplain");
            } else {
                seeTag.setTagName("@link");
            }
            TagElement previousTag = null;
            int previousStart = this.inlineTagStart;
            if (this.astPtr == -1) {
                previousTag = this.ast.newTagElement();
                this.pushOnAstStack(previousTag, true);
            } else {
                previousTag = (TagElement)this.astStack[this.astPtr];
                previousStart = previousTag.getStartPosition();
            }
            previousTag.fragments().add(seeTag);
            previousTag.setSourceRange(previousStart, end - previousStart + 1);
        } else {
            seeTag.setTagName("@see");
            seeTag.setSourceRange(this.tagSourceStart, end - this.tagSourceStart + 1);
            this.pushOnAstStack(seeTag, true);
        }
        return true;
    }

    protected void pushText(int start, int end) {
        TextElement text = this.ast.newTextElement();
        text.setText(new String(this.source, start, end - start));
        text.setSourceRange(start, end - start);
        TagElement previousTag = null;
        int previousStart = start;
        if (this.astPtr == -1) {
            previousTag = this.ast.newTagElement();
            previousTag.setSourceRange(start, end - start);
            this.pushOnAstStack(previousTag, true);
        } else {
            previousTag = (TagElement)this.astStack[this.astPtr];
            previousStart = previousTag.getStartPosition();
        }
        if (this.inlineTagStarted) {
            if (previousTag.fragments().size() == 0) {
                TagElement inlineTag = this.ast.newTagElement();
                previousTag.fragments().add(inlineTag);
                previousTag = inlineTag;
            } else {
                ASTNode inlineTag = (ASTNode)previousTag.fragments().get(previousTag.fragments().size() - 1);
                if (inlineTag.getNodeType() == 65) {
                    previousTag = (TagElement)inlineTag;
                    previousStart = previousTag.getStartPosition();
                }
            }
        }
        previousTag.fragments().add(text);
        previousTag.setSourceRange(previousStart, end - previousStart);
        this.textStart = -1;
    }

    protected void refreshInlineTagPosition(int previousPosition) {
        if (this.astPtr != -1) {
            TagElement previousTag = (TagElement)this.astStack[this.astPtr];
            if (this.inlineTagStarted) {
                ASTNode inlineTag;
                int previousStart = previousTag.getStartPosition();
                previousTag.setSourceRange(previousStart, previousPosition - previousStart + 1);
                if (previousTag.fragments().size() > 0 && (inlineTag = (ASTNode)previousTag.fragments().get(previousTag.fragments().size() - 1)).getNodeType() == 65) {
                    int inlineStart = inlineTag.getStartPosition();
                    inlineTag.setSourceRange(inlineStart, previousPosition - inlineStart + 1);
                }
            }
        }
    }

    protected boolean pushThrowName(Object typeRef, boolean real) {
        TagElement throwsTag = this.ast.newTagElement();
        if (real) {
            throwsTag.setTagName("@throws");
        } else {
            throwsTag.setTagName("@exception");
        }
        throwsTag.setSourceRange(this.tagSourceStart, this.scanner.getCurrentTokenEndPosition() - this.tagSourceStart + 1);
        throwsTag.fragments().add(typeRef);
        this.pushOnAstStack(throwsTag, true);
        return true;
    }

    protected void updateDocComment() {
        int idx = 0;
        while (idx <= this.astPtr) {
            this.docComment.tags().add(this.astStack[idx]);
            ++idx;
        }
    }
}

