/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core.memory;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.internal.core.DebugCoreMessages;
import org.eclipse.debug.internal.core.memory.IDynamicRenderingFactory;
import org.eclipse.debug.internal.core.memory.IDynamicRenderingInfo;
import org.eclipse.debug.internal.core.memory.IMemoryBlockListener;
import org.eclipse.debug.internal.core.memory.IMemoryRendering;
import org.eclipse.debug.internal.core.memory.IMemoryRenderingFactory;
import org.eclipse.debug.internal.core.memory.IMemoryRenderingInfo;
import org.eclipse.debug.internal.core.memory.IMemoryRenderingListener;
import org.eclipse.debug.internal.core.memory.IMemoryRenderingManager;
import org.eclipse.debug.internal.core.memory.MemoryBlockManager;
import org.eclipse.debug.internal.core.memory.MemoryRendering;
import org.eclipse.debug.internal.core.memory.MemoryRenderingInfo;

public class MemoryRenderingManager
implements IMemoryRenderingManager,
IDebugEventSetListener,
IMemoryBlockListener {
    private ArrayList listeners = new ArrayList();
    private ArrayList fRenderings = new ArrayList();
    private Hashtable fMemoryRenderingInfo = new Hashtable();
    private ArrayList fRenderingInfoOrderList = new ArrayList();
    private Hashtable fDefaultRenderings = new Hashtable();
    private Hashtable fRenderingBinds = new Hashtable();
    private Hashtable fDynamicRenderingMap = new Hashtable();
    private Hashtable fDynamicRenderingFactory = new Hashtable();
    private static final int ADDED = 0;
    private static final int REMOVED = 1;
    private static final String RENDERING_EXT = "memoryRenderings";
    private static final String RENDERING_ELEMENT = "rendering";
    private static final String RENDERING_PROPERTY_ELEMENT = "rendering_property";
    private static final String RENDERING_ID = "renderingId";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String DEFAULT_RENDERING = "default_renderings";
    private static final String MEMORYBLOCKCLASS = "memoryBlockClass";
    private static final String RENDERINGS = "renderingIds";
    private static final String RENDERING_BIND = "rendering_binding";
    private static final String RENDERING_FACTORY = "renderingFactory";
    private static final String DYNAMIC_RENDERING_FACTORY = "dynamicRenderingFactory";
    private boolean fHandleAddEvent = true;

    public MemoryRenderingManager() {
        MemoryBlockManager.getMemoryBlockManager().addListener(this);
        this.buildMemoryRenderingInfo();
    }

    private void buildMemoryRenderingInfo() {
        this.getExtendedRendering();
    }

    private void getExtendedRendering() {
        IExtensionPoint rendering = Platform.getExtensionRegistry().getExtensionPoint(DebugPlugin.getUniqueIdentifier(), RENDERING_EXT);
        IExtension[] extensions = rendering.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                if (elements[j].getName().equals(RENDERING_ELEMENT)) {
                    this.addRendering(elements[j]);
                } else if (elements[j].getName().equals(RENDERING_PROPERTY_ELEMENT)) {
                    this.addRenderingProperty(elements[j]);
                } else if (elements[j].getName().equals(DEFAULT_RENDERING)) {
                    this.addDefaultRenderings(elements[j]);
                } else if (elements[j].getName().equals(RENDERING_BIND)) {
                    this.addRenderingBind(elements[j]);
                } else {
                    DebugPlugin.logMessage("Unknown element in rendering extenstion: " + elements[j].getName(), null);
                }
                ++j;
            }
            ++i;
        }
    }

    private void addRendering(IConfigurationElement element) {
        String renderingId = element.getAttribute(RENDERING_ID);
        String name = element.getAttribute(NAME);
        if (renderingId == null || name == null) {
            String extension = element.getDeclaringExtension().getUniqueIdentifier();
            DebugPlugin.logMessage("Rendering defined is malformed: " + extension, null);
        } else {
            MemoryRenderingInfo info = new MemoryRenderingInfo(renderingId, name, element);
            if (this.fMemoryRenderingInfo.containsKey(renderingId)) {
                Status status = new Status(2, DebugPlugin.getUniqueIdentifier(), 0, "Duplicated rendering definition: " + renderingId, null);
                DebugPlugin.log((IStatus)status);
            }
            this.fMemoryRenderingInfo.put(renderingId, info);
            this.fRenderingInfoOrderList.add(renderingId);
        }
        IConfigurationElement[] subElements = element.getChildren();
        int k = 0;
        while (k < subElements.length) {
            if (subElements[k].getName().equals(RENDERING_PROPERTY_ELEMENT)) {
                this.addRenderingProperty(subElements[k]);
            } else {
                DebugPlugin.logMessage("Unknown element in rendering extenstion: " + element.getName(), null);
            }
            ++k;
        }
    }

    private void addRenderingProperty(IConfigurationElement element) {
        String renderingId = element.getAttribute(RENDERING_ID);
        String propertyId = element.getAttribute(NAME);
        String propertyValue = element.getAttribute(VALUE);
        if (renderingId == null || propertyId == null || propertyValue == null) {
            String extension = element.getDeclaringExtension().getUniqueIdentifier();
            DebugPlugin.logMessage("Rendering property defined is malformed: " + extension, null);
        } else {
            MemoryRenderingInfo info = (MemoryRenderingInfo)this.fMemoryRenderingInfo.get(renderingId);
            if (info == null) {
                DebugPlugin.logMessage("Rendering info for this property is not found: " + propertyId, null);
            } else {
                info.addProperty(propertyId, element);
            }
        }
    }

    private void addDefaultRenderings(IConfigurationElement element) {
        ArrayList definedrenderings;
        String memoryBlockClass = element.getAttribute(MEMORYBLOCKCLASS);
        String renderings = element.getAttribute(RENDERINGS);
        if (memoryBlockClass == null || renderings == null) {
            String extension = element.getDeclaringExtension().getUniqueIdentifier();
            DebugPlugin.logMessage("Default rendering defined is malformed: " + extension, null);
            return;
        }
        ArrayList<String> renderingsArray = new ArrayList<String>();
        int idx = renderings.indexOf(",");
        if (idx == -1) {
            renderingsArray.add(renderings);
        } else {
            StringTokenizer tokenizer = new StringTokenizer(renderings, ",");
            while (tokenizer.hasMoreElements()) {
                String rendering = tokenizer.nextToken();
                rendering = rendering.trim();
                renderingsArray.add(rendering);
            }
        }
        if (this.fDefaultRenderings == null) {
            this.fDefaultRenderings = new Hashtable();
        }
        if ((definedrenderings = (ArrayList)this.fDefaultRenderings.get(memoryBlockClass)) == null) {
            this.fDefaultRenderings.put(memoryBlockClass, renderingsArray);
        } else {
            int i = 0;
            while (i < renderingsArray.size()) {
                if (!definedrenderings.contains(renderingsArray.get(i))) {
                    definedrenderings.add(renderingsArray.get(i));
                }
                ++i;
            }
        }
    }

    private void addRenderingBind(IConfigurationElement element) {
        ArrayList renderingIds;
        String memoryBlockClass = element.getAttribute(MEMORYBLOCKCLASS);
        String renderings = element.getAttribute(RENDERINGS);
        if (memoryBlockClass == null || renderings == null) {
            String extension = element.getDeclaringExtension().getUniqueIdentifier();
            DebugPlugin.logMessage("Rendering bind defined is malformed: " + extension, null);
            return;
        }
        ArrayList<String> renderingsArray = new ArrayList<String>();
        int idx = renderings.indexOf(",");
        if (idx == -1) {
            renderingsArray.add(renderings);
        } else {
            StringTokenizer tokenizer = new StringTokenizer(renderings, ",");
            while (tokenizer.hasMoreElements()) {
                String rendering = tokenizer.nextToken();
                rendering = rendering.trim();
                renderingsArray.add(rendering);
            }
        }
        if (this.fRenderingBinds == null) {
            this.fRenderingBinds = new Hashtable();
        }
        if ((renderingIds = (ArrayList)this.fRenderingBinds.get(memoryBlockClass)) == null) {
            this.fRenderingBinds.put(memoryBlockClass, renderingsArray);
        } else {
            int i = 0;
            while (i < renderingsArray.size()) {
                if (!renderingIds.contains(renderingsArray.get(i))) {
                    renderingIds.add(renderingsArray.get(i));
                }
                ++i;
            }
        }
    }

    private MemoryRenderingManagerNotifier getMemoryBlockNotifier() {
        return new MemoryRenderingManagerNotifier();
    }

    public IMemoryRendering addMemoryBlockRendering(IMemoryBlock mem, String renderingId) throws DebugException {
        if (this.fRenderings == null) {
            return null;
        }
        IMemoryRendering newRendering = this.createRendering(mem, renderingId);
        if (newRendering == null) {
            return newRendering;
        }
        if (this.fRenderings.contains(newRendering)) {
            return newRendering;
        }
        this.fRenderings.add(newRendering);
        if (this.fRenderings.size() == 1) {
            DebugPlugin.getDefault().addDebugEventListener(this);
        }
        this.notifyListeners(0, newRendering);
        return newRendering;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IMemoryRendering createRendering(IMemoryBlock mem, String renderingId) throws DebugException {
        IMemoryRenderingInfo info = this.getRenderingInfo(renderingId);
        if (info != null) {
            IConfigurationElement element = info.getConfigElement();
            if (element != null) {
                String factoryAtt = element.getAttribute(RENDERING_FACTORY);
                if (factoryAtt == null) return new MemoryRendering(mem, renderingId);
                Object obj = null;
                try {
                    obj = element.createExecutableExtension(RENDERING_FACTORY);
                }
                catch (CoreException e) {
                    IStatus stat = e.getStatus();
                    DebugException de = new DebugException(stat);
                    throw de;
                }
                if (obj == null) {
                    return new MemoryRendering(mem, renderingId);
                }
                if (!(obj instanceof IMemoryRenderingFactory)) return new MemoryRendering(mem, renderingId);
                IMemoryRenderingFactory factory = (IMemoryRenderingFactory)obj;
                IMemoryRendering rendering = null;
                return factory.createRendering(mem, renderingId);
            }
            String message = MessageFormat.format(DebugCoreMessages.getString("MemoryRenderingManager.ErrorMsg"), renderingId);
            Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 0, message, null);
            DebugException de = new DebugException((IStatus)status);
            throw de;
        }
        String message = MessageFormat.format(DebugCoreMessages.getString("MemoryRenderingManager.ErrorMsg"), renderingId);
        Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 0, message, null);
        DebugException de = new DebugException((IStatus)status);
        throw de;
    }

    public void removeMemoryBlockRendering(IMemoryBlock mem, String renderingId) {
        if (this.fRenderings == null) {
            return;
        }
        IMemoryRendering[] toRemove = this.getRenderings(mem, renderingId);
        int i = 0;
        while (i < toRemove.length) {
            this.fRenderings.remove(toRemove[i]);
            if (this.fRenderings.size() == 0) {
                DebugPlugin.getDefault().removeDebugEventListener(this);
            }
            this.notifyListeners(1, toRemove[i]);
            ++i;
        }
    }

    public void addMemoryBlockRendering(IMemoryRendering rendering) throws DebugException {
        if (this.fRenderings.contains(rendering)) {
            return;
        }
        this.fRenderings.add(rendering);
        if (this.fRenderings.size() == 1) {
            DebugPlugin.getDefault().addDebugEventListener(this);
        }
        this.notifyListeners(0, rendering);
    }

    public void removeMemoryBlockRendering(IMemoryRendering rendering) {
        if (rendering == null) {
            return;
        }
        if (!this.fRenderings.contains(rendering)) {
            return;
        }
        this.fRenderings.remove(rendering);
        if (this.fRenderings.size() == 0) {
            DebugPlugin.getDefault().removeDebugEventListener(this);
        }
        this.notifyListeners(1, rendering);
    }

    public IMemoryRendering[] getRenderings(IMemoryBlock mem, String renderingId) {
        if (renderingId == null) {
            return this.getRenderingsFromMemoryBlock(mem);
        }
        ArrayList<IMemoryRendering> ret = new ArrayList<IMemoryRendering>();
        int i = 0;
        while (i < this.fRenderings.size()) {
            IMemoryRendering rendering;
            if (this.fRenderings.get(i) instanceof IMemoryRendering && (rendering = (IMemoryRendering)this.fRenderings.get(i)).getBlock() == mem && renderingId.equals(rendering.getRenderingId())) {
                ret.add(rendering);
            }
            ++i;
        }
        return ret.toArray(new IMemoryRendering[ret.size()]);
    }

    public IMemoryRendering[] getRenderingsFromDebugTarget(IDebugTarget target) {
        ArrayList<IMemoryRendering> ret = new ArrayList<IMemoryRendering>();
        int i = 0;
        while (i < this.fRenderings.size()) {
            IMemoryRendering rendering;
            if (this.fRenderings.get(i) instanceof IMemoryRendering && (rendering = (IMemoryRendering)this.fRenderings.get(i)).getBlock().getDebugTarget() == target) {
                ret.add(rendering);
            }
            ++i;
        }
        return ret.toArray(new IMemoryRendering[ret.size()]);
    }

    public IMemoryRendering[] getRenderingsFromMemoryBlock(IMemoryBlock block) {
        ArrayList<IMemoryRendering> ret = new ArrayList<IMemoryRendering>();
        int i = 0;
        while (i < this.fRenderings.size()) {
            IMemoryRendering rendering;
            if (this.fRenderings.get(i) instanceof IMemoryRendering && (rendering = (IMemoryRendering)this.fRenderings.get(i)).getBlock() == block) {
                ret.add(rendering);
            }
            ++i;
        }
        return ret.toArray(new IMemoryRendering[ret.size()]);
    }

    public void addListener(IMemoryRenderingListener listener) {
        if (this.listeners == null) {
            return;
        }
        if (listener == null) {
            DebugPlugin.logMessage("Null argument passed into IMemoryRenderingManager.addListener", null);
            return;
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(IMemoryRenderingListener listener) {
        if (this.listeners == null) {
            return;
        }
        if (listener == null) {
            DebugPlugin.logMessage("Null argument passed into IMemoryRenderingManager.removeListener", null);
            return;
        }
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    private void notifyListeners(int update, IMemoryRendering rendering) {
        this.getMemoryBlockNotifier().notify(update, rendering);
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            this.handleDebugEvent(events[i]);
            ++i;
        }
    }

    public void handleDebugEvent(DebugEvent event) {
        Object obj = event.getSource();
        IDebugTarget dt = null;
        if (event.getKind() == 8) {
            if (obj instanceof IDebugTarget) {
                dt = (IDebugTarget)obj;
            }
            IMemoryRendering[] deletedrendering = this.getRenderingsFromDebugTarget(dt);
            int i = 0;
            while (i < deletedrendering.length) {
                this.removeMemoryBlockRendering(deletedrendering[i].getBlock(), deletedrendering[i].getRenderingId());
                ++i;
            }
        }
    }

    public void MemoryBlockAdded(IMemoryBlock memory) {
        if (this.fHandleAddEvent) {
            String[] renderingIds = this.getDefaultRenderings(memory);
            int i = 0;
            while (i < renderingIds.length) {
                try {
                    this.addMemoryBlockRendering(memory, renderingIds[i]);
                }
                catch (DebugException debugException) {
                    DebugPlugin.logMessage("Cannot create default rendering: " + renderingIds[i], null);
                }
                ++i;
            }
        }
    }

    public void MemoryBlockRemoved(IMemoryBlock memory) {
        IMemoryRendering[] renderings = this.getRenderingsFromMemoryBlock(memory);
        int i = 0;
        while (i < renderings.length) {
            this.removeMemoryBlockRendering(renderings[i].getBlock(), renderings[i].getRenderingId());
            ++i;
        }
    }

    public IMemoryRenderingInfo getRenderingInfo(String renderingId) {
        MemoryRenderingInfo info = (MemoryRenderingInfo)this.fMemoryRenderingInfo.get(renderingId);
        if (info != null) {
            return info;
        }
        return null;
    }

    public IMemoryRenderingInfo[] getAllRenderingInfo(Object obj) {
        String[] hierarchy = this.getHierarchy(obj);
        ArrayList renderingIds = new ArrayList();
        ArrayList<IMemoryRenderingInfo> renderingInfos = new ArrayList<IMemoryRenderingInfo>();
        int i = 0;
        while (i < hierarchy.length) {
            ArrayList ids = (ArrayList)this.fRenderingBinds.get(hierarchy[i]);
            if (ids != null) {
                int j = 0;
                while (j < ids.size()) {
                    if (!renderingIds.contains(ids.get(j))) {
                        renderingIds.add(ids.get(j));
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < renderingIds.size()) {
            IMemoryRenderingInfo info = (IMemoryRenderingInfo)this.fMemoryRenderingInfo.get(renderingIds.get(i));
            IDynamicRenderingInfo[] dynamic = null;
            if (info != null) {
                dynamic = this.getDynamicRenderingInfo(info);
            }
            if (dynamic != null) {
                int j = 0;
                while (j < dynamic.length) {
                    IMemoryRenderingInfo dynamicInfo = (IMemoryRenderingInfo)this.fMemoryRenderingInfo.get(dynamic[j].getRenderingId());
                    renderingInfos.add(dynamicInfo);
                    ++j;
                }
            } else if (info != null) {
                renderingInfos.add(info);
            }
            ++i;
        }
        return renderingInfos.toArray(new IMemoryRenderingInfo[renderingInfos.size()]);
    }

    private IDynamicRenderingInfo[] getDynamicRenderingInfo(IMemoryRenderingInfo rendering) {
        IConfigurationElement element = rendering.getPropertyConfigElement(DYNAMIC_RENDERING_FACTORY);
        try {
            if (element != null) {
                Object obj = this.fDynamicRenderingFactory.get(rendering.getRenderingId());
                if (obj == null) {
                    obj = element.createExecutableExtension(VALUE);
                }
                if (obj != null && obj instanceof IDynamicRenderingFactory) {
                    this.fDynamicRenderingFactory.put(rendering.getRenderingId(), obj);
                    IDynamicRenderingInfo[] dynamicRenderingTypes = ((IDynamicRenderingFactory)obj).getRenderingInfos();
                    if (dynamicRenderingTypes != null) {
                        this.addRenderingInfo(dynamicRenderingTypes);
                        Enumeration enumeration = this.fDynamicRenderingMap.keys();
                        while (enumeration.hasMoreElements()) {
                            String dynamicRenderingId = (String)enumeration.nextElement();
                            String staticRenderingId = (String)this.fDynamicRenderingMap.get(dynamicRenderingId);
                            if (!staticRenderingId.equals(rendering.getRenderingId())) continue;
                            boolean found = false;
                            int i = 0;
                            while (i < dynamicRenderingTypes.length) {
                                if (dynamicRenderingTypes[i].getRenderingId().equals(dynamicRenderingId)) {
                                    found = true;
                                    break;
                                }
                                ++i;
                            }
                            if (found) continue;
                            this.fMemoryRenderingInfo.remove(dynamicRenderingId);
                            this.fDynamicRenderingMap.remove(dynamicRenderingId);
                        }
                        String staticRenderingId = rendering.getRenderingId();
                        int i = 0;
                        while (i < dynamicRenderingTypes.length) {
                            this.fDynamicRenderingMap.put(dynamicRenderingTypes[i].getRenderingId(), staticRenderingId);
                            ++i;
                        }
                        return dynamicRenderingTypes;
                    }
                    return null;
                }
            }
        }
        catch (CoreException coreException) {
            DebugPlugin.logMessage("Cannot create the dynamic rendering factory for " + element.getDeclaringExtension().getUniqueIdentifier(), null);
            return null;
        }
        return null;
    }

    private IMemoryRenderingInfo createRenderingInfo(IDynamicRenderingInfo info) {
        if (info == null) {
            return null;
        }
        if (info.getParentRenderingInfo() == null) {
            DebugPlugin.logMessage("Dynamic rendering info does not have a parent " + info.getRenderingId(), null);
            return null;
        }
        IMemoryRenderingInfo parent = info.getParentRenderingInfo();
        MemoryRenderingInfo dynamicInfo = new MemoryRenderingInfo(info.getRenderingId(), info.getName(), info.getParentRenderingInfo().getConfigElement());
        IConfigurationElement[] properties = parent.getAllProperties();
        int i = 0;
        while (i < properties.length) {
            String name = properties[i].getAttribute(NAME);
            if (name != null && !name.equals(DYNAMIC_RENDERING_FACTORY)) {
                dynamicInfo.addProperty(name, properties[i]);
            }
            ++i;
        }
        return dynamicInfo;
    }

    public String[] getDefaultRenderings(Object obj) {
        if (this.fDefaultRenderings == null) {
            return new String[0];
        }
        if (obj == null) {
            return new String[0];
        }
        IMemoryRenderingInfo[] supported = this.getAllRenderingInfo(obj);
        ArrayList<String> results = new ArrayList<String>();
        String[] hierarchy = this.getHierarchy(obj);
        int i = 0;
        while (i < hierarchy.length) {
            ArrayList defaults = (ArrayList)this.fDefaultRenderings.get(hierarchy[i]);
            if (defaults != null) {
                int j = 0;
                while (j < defaults.size()) {
                    int k = 0;
                    while (k < supported.length) {
                        if (supported[k].getRenderingId().equals(defaults.get(j))) {
                            results.add(supported[k].getRenderingId());
                        }
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return results.toArray(new String[results.size()]);
    }

    protected void addRenderingInfo(IDynamicRenderingInfo[] dynamicRenderingTypes) {
        if (dynamicRenderingTypes != null) {
            int i = 0;
            while (i < dynamicRenderingTypes.length) {
                IMemoryRenderingInfo dynamicInfo;
                if (this.fMemoryRenderingInfo.get(dynamicRenderingTypes[i].getRenderingId()) == null && (dynamicInfo = this.createRenderingInfo(dynamicRenderingTypes[i])) != null) {
                    this.fMemoryRenderingInfo.put(dynamicRenderingTypes[i].getRenderingId(), dynamicInfo);
                }
                ++i;
            }
        }
    }

    private String[] getHierarchy(Object obj) {
        ArrayList<String> hierarchy = new ArrayList<String>();
        hierarchy.add(obj.getClass().getName());
        Class<?> superClass = obj.getClass().getSuperclass();
        while (superClass != null) {
            hierarchy.add(superClass.getName());
            superClass = superClass.getSuperclass();
        }
        ArrayList<Class> interfaces = new ArrayList<Class>();
        Class[] baseInterfaces = obj.getClass().getInterfaces();
        int i = 0;
        while (i < baseInterfaces.length) {
            interfaces.add(baseInterfaces[i]);
            ++i;
        }
        this.getInterfaces(interfaces, baseInterfaces);
        i = 0;
        while (i < interfaces.size()) {
            hierarchy.add(((Class)interfaces.get(i)).getName());
            ++i;
        }
        return hierarchy.toArray(new String[hierarchy.size()]);
    }

    private void getInterfaces(ArrayList list, Class[] interfaces) {
        Class[] superInterfaces = new Class[]{};
        int i = 0;
        while (i < interfaces.length) {
            superInterfaces = interfaces[i].getInterfaces();
            int j = 0;
            while (j < superInterfaces.length) {
                list.add(superInterfaces[j]);
                ++j;
            }
            this.getInterfaces(list, superInterfaces);
            ++i;
        }
    }

    public void shutdown() {
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
        }
        if (this.fRenderings != null) {
            this.fRenderings.clear();
            this.fRenderings = null;
        }
        if (this.fMemoryRenderingInfo != null) {
            this.fMemoryRenderingInfo.clear();
            this.fMemoryRenderingInfo = null;
        }
        if (this.fRenderingInfoOrderList != null) {
            this.fRenderingInfoOrderList.clear();
            this.fRenderingInfoOrderList = null;
        }
        if (this.fDynamicRenderingMap != null) {
            this.fDynamicRenderingMap.clear();
            this.fDynamicRenderingMap = null;
        }
        if (this.fDynamicRenderingFactory != null) {
            this.fDynamicRenderingFactory.clear();
            this.fDynamicRenderingFactory = null;
        }
        MemoryBlockManager.getMemoryBlockManager().removeListener(this);
    }

    public void setHandleMemoryBlockAddedEvent(boolean handleEvt) {
        this.fHandleAddEvent = handleEvt;
    }

    class MemoryRenderingManagerNotifier
    implements ISafeRunnable {
        private IMemoryRenderingListener fListener;
        private int fType;
        private IMemoryRendering fRendering;

        MemoryRenderingManagerNotifier() {
        }

        public void handleException(Throwable exception) {
            DebugPlugin.log(exception);
        }

        public void run() throws Exception {
            switch (this.fType) {
                case 0: {
                    this.fListener.MemoryBlockRenderingAdded(this.fRendering);
                    break;
                }
                case 1: {
                    this.fListener.MemoryBlockRenderingRemoved(this.fRendering);
                }
            }
        }

        public void notify(int update, IMemoryRendering rendering) {
            if (MemoryRenderingManager.this.listeners != null) {
                this.fType = update;
                this.fRendering = rendering;
                IMemoryRenderingListener[] copiedListeners = MemoryRenderingManager.this.listeners.toArray(new IMemoryRenderingListener[MemoryRenderingManager.this.listeners.size()]);
                int i = 0;
                while (i < copiedListeners.length) {
                    this.fListener = copiedListeners[i];
                    Platform.run((ISafeRunnable)this);
                    ++i;
                }
            }
            this.fListener = null;
        }
    }
}

