/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.IExpressionListener;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.IExpressionsListener;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.core.model.IWatchExpressionDelegate;
import org.eclipse.debug.internal.core.DebugCoreMessages;
import org.eclipse.debug.internal.core.LaunchManager;
import org.eclipse.debug.internal.core.ListenerList;
import org.eclipse.debug.internal.core.WatchExpression;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExpressionManager
implements IExpressionManager,
IDebugEventSetListener {
    private Vector fExpressions = null;
    private ListenerList fListeners = null;
    private ListenerList fExpressionsListeners = null;
    private Map fWatchExpressionDelegates = new HashMap();
    private static final int ADDED = 1;
    private static final int CHANGED = 2;
    private static final int REMOVED = 3;
    private static final String PREF_WATCH_EXPRESSIONS = "prefWatchExpressions";
    private static final String WATCH_EXPRESSIONS_TAG = "watchExpressions";
    private static final String EXPRESSION_TAG = "expression";
    private static final String TEXT_TAG = "text";
    private static final String ENABLED_TAG = "enabled";
    private static final String TRUE_VALUE = "true";
    private static final String FALSE_VALUE = "false";

    public ExpressionManager() {
        this.loadPersistedExpressions();
        this.loadWatchExpressionDelegates();
    }

    private void loadWatchExpressionDelegates() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DebugPlugin.getUniqueIdentifier(), "watchExpressionDelegates");
        IConfigurationElement[] configurationElements = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < configurationElements.length) {
            String debugModel;
            IConfigurationElement element = configurationElements[i];
            if (element.getName().equals("watchExpressionDelegate") && (debugModel = element.getAttribute("debugModel")) != null && debugModel.length() != 0) {
                this.fWatchExpressionDelegates.put(debugModel, element);
            }
            ++i;
        }
    }

    public IWatchExpressionDelegate newWatchExpressionDelegate(String debugModel) {
        try {
            IConfigurationElement element = (IConfigurationElement)this.fWatchExpressionDelegates.get(debugModel);
            if (element != null) {
                return (IWatchExpressionDelegate)element.createExecutableExtension("delegateClass");
            }
            return null;
        }
        catch (CoreException e) {
            DebugPlugin.log(e);
            return null;
        }
    }

    private void loadPersistedExpressions() {
        Element root;
        String expressionsString = DebugPlugin.getDefault().getPluginPreferences().getString(PREF_WATCH_EXPRESSIONS);
        if (expressionsString.length() == 0) {
            return;
        }
        try {
            root = DebugPlugin.parseDocument(expressionsString);
        }
        catch (CoreException e) {
            DebugPlugin.logMessage("An exception occurred while loading watch expressions.", e);
            return;
        }
        if (!root.getNodeName().equals(WATCH_EXPRESSIONS_TAG)) {
            DebugPlugin.logMessage("Invalid format encountered while loading watch expressions.", null);
            return;
        }
        NodeList list = root.getChildNodes();
        boolean expressionsAdded = false;
        int i = 0;
        int numItems = list.getLength();
        while (i < numItems) {
            Node node = list.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                if (!element.getNodeName().equals(EXPRESSION_TAG)) {
                    DebugPlugin.logMessage(MessageFormat.format("Invalid XML element encountered while loading watch expressions: {0}", node.getNodeName()), null);
                } else {
                    String expressionText = element.getAttribute(TEXT_TAG);
                    if (expressionText.length() > 0) {
                        boolean enabled = TRUE_VALUE.equals(element.getAttribute(ENABLED_TAG));
                        IWatchExpression expression = this.newWatchExpression(expressionText, enabled);
                        if (this.fExpressions == null) {
                            this.fExpressions = new Vector(list.getLength());
                        }
                        this.fExpressions.add(expression);
                        expressionsAdded = true;
                    } else {
                        DebugPlugin.logMessage("Invalid expression entry encountered while loading watch expressions. Expression text is empty.", null);
                    }
                }
            }
            ++i;
        }
        if (expressionsAdded) {
            DebugPlugin.getDefault().addDebugEventListener(this);
        }
    }

    private IWatchExpression newWatchExpression(String expressionText, boolean enabled) {
        return new WatchExpression(expressionText, enabled);
    }

    public IWatchExpression newWatchExpression(String expressionText) {
        return new WatchExpression(expressionText);
    }

    public void storeWatchExpressions() {
        Preferences prefs = DebugPlugin.getDefault().getPluginPreferences();
        String expressionString = "";
        try {
            expressionString = this.getWatchExpressionsAsXML();
        }
        catch (IOException e) {
            DebugPlugin.log(e);
        }
        catch (ParserConfigurationException e) {
            DebugPlugin.log(e);
        }
        catch (TransformerException e) {
            DebugPlugin.log(e);
        }
        prefs.setValue(PREF_WATCH_EXPRESSIONS, expressionString);
        DebugPlugin.getDefault().savePluginPreferences();
    }

    private String getWatchExpressionsAsXML() throws IOException, ParserConfigurationException, TransformerException {
        IExpression[] expressions = this.getExpressions();
        Document document = LaunchManager.getDocument();
        Element rootElement = document.createElement(WATCH_EXPRESSIONS_TAG);
        document.appendChild(rootElement);
        int i = 0;
        while (i < expressions.length) {
            IExpression expression = expressions[i];
            if (expression instanceof IWatchExpression) {
                Element element = document.createElement(EXPRESSION_TAG);
                element.setAttribute(TEXT_TAG, expression.getExpressionText());
                element.setAttribute(ENABLED_TAG, ((IWatchExpression)expression).isEnabled() ? TRUE_VALUE : FALSE_VALUE);
                rootElement.appendChild(element);
            }
            ++i;
        }
        return LaunchManager.serializeDocument(document);
    }

    public void addExpression(IExpression expression) {
        this.addExpressions(new IExpression[]{expression});
    }

    public void addExpressions(IExpression[] expressions) {
        if (this.fExpressions == null) {
            this.fExpressions = new Vector(expressions.length);
        }
        boolean addedWatchExpression = false;
        boolean wasEmpty = this.fExpressions.isEmpty();
        ArrayList<IExpression> added = new ArrayList<IExpression>(expressions.length);
        int i = 0;
        while (i < expressions.length) {
            IExpression expression = expressions[i];
            if (this.fExpressions.indexOf(expression) == -1) {
                added.add(expression);
                this.fExpressions.add(expression);
                if (expression instanceof IWatchExpression) {
                    addedWatchExpression = true;
                }
            }
            ++i;
        }
        if (wasEmpty) {
            DebugPlugin.getDefault().addDebugEventListener(this);
        }
        if (!added.isEmpty()) {
            this.fireUpdate(added.toArray(new IExpression[added.size()]), 1);
        }
        if (addedWatchExpression) {
            this.storeWatchExpressions();
        }
    }

    public IExpression[] getExpressions() {
        if (this.fExpressions == null) {
            return new IExpression[0];
        }
        Object[] temp = new IExpression[this.fExpressions.size()];
        this.fExpressions.copyInto(temp);
        return temp;
    }

    public IExpression[] getExpressions(String modelIdentifier) {
        if (this.fExpressions == null) {
            return new IExpression[0];
        }
        ArrayList<IExpression> temp = new ArrayList<IExpression>(this.fExpressions.size());
        Iterator iter = this.fExpressions.iterator();
        while (iter.hasNext()) {
            IExpression expression = (IExpression)iter.next();
            String id = expression.getModelIdentifier();
            if (id == null || !id.equals(modelIdentifier)) continue;
            temp.add(expression);
        }
        return temp.toArray(new IExpression[temp.size()]);
    }

    public void removeExpression(IExpression expression) {
        this.removeExpressions(new IExpression[]{expression});
    }

    public void removeExpressions(IExpression[] expressions) {
        if (this.fExpressions == null) {
            return;
        }
        ArrayList<IExpression> removed = new ArrayList<IExpression>(expressions.length);
        int i = 0;
        while (i < expressions.length) {
            IExpression expression = expressions[i];
            if (this.fExpressions.remove(expression)) {
                removed.add(expression);
                expression.dispose();
            }
            ++i;
        }
        if (this.fExpressions.isEmpty()) {
            DebugPlugin.getDefault().removeDebugEventListener(this);
        }
        if (!removed.isEmpty()) {
            this.fireUpdate(removed.toArray(new IExpression[removed.size()]), 3);
            this.storeWatchExpressions();
        }
    }

    public void addExpressionListener(IExpressionListener listener) {
        if (this.fListeners == null) {
            this.fListeners = new ListenerList(2);
        }
        this.fListeners.add(listener);
    }

    public void removeExpressionListener(IExpressionListener listener) {
        if (this.fListeners == null) {
            return;
        }
        this.fListeners.remove(listener);
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            ArrayList<Object> changed = null;
            DebugEvent event = events[i];
            if (event.getSource() instanceof IExpression) {
                switch (event.getKind()) {
                    case 16: {
                        if (changed == null) {
                            changed = new ArrayList<Object>(1);
                        }
                        changed.add(event.getSource());
                        break;
                    }
                }
            }
            if (changed != null) {
                IExpression[] array = changed.toArray(new IExpression[changed.size()]);
                this.fireUpdate(array, 2);
            }
            ++i;
        }
    }

    protected void watchExpressionChanged(IWatchExpression expression) {
        if (this.fExpressions != null && this.fExpressions.contains(expression)) {
            this.storeWatchExpressions();
        }
    }

    private void fireUpdate(IExpression[] expressions, int update) {
        this.getExpressionNotifier().notify(expressions, update);
        this.getExpressionsNotifier().notify(expressions, update);
    }

    public boolean hasExpressions() {
        return this.fExpressions != null;
    }

    public void addExpressionListener(IExpressionsListener listener) {
        if (this.fExpressionsListeners == null) {
            this.fExpressionsListeners = new ListenerList(2);
        }
        this.fExpressionsListeners.add(listener);
    }

    public void removeExpressionListener(IExpressionsListener listener) {
        if (this.fExpressionsListeners == null) {
            return;
        }
        this.fExpressionsListeners.remove(listener);
    }

    private ExpressionNotifier getExpressionNotifier() {
        return new ExpressionNotifier();
    }

    private ExpressionsNotifier getExpressionsNotifier() {
        return new ExpressionsNotifier();
    }

    class ExpressionNotifier
    implements ISafeRunnable {
        private IExpressionListener fListener;
        private int fType;
        private IExpression fExpression;

        ExpressionNotifier() {
        }

        public void handleException(Throwable exception) {
            Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 120, DebugCoreMessages.getString("ExpressionManager.An_exception_occurred_during_expression_change_notification._1"), exception);
            DebugPlugin.log((IStatus)status);
        }

        public void run() throws Exception {
            switch (this.fType) {
                case 1: {
                    this.fListener.expressionAdded(this.fExpression);
                    break;
                }
                case 3: {
                    this.fListener.expressionRemoved(this.fExpression);
                    break;
                }
                case 2: {
                    this.fListener.expressionChanged(this.fExpression);
                }
            }
        }

        public void notify(IExpression[] expressions, int update) {
            if (ExpressionManager.this.fListeners != null) {
                this.fType = update;
                Object[] copiedListeners = ExpressionManager.this.fListeners.getListeners();
                int i = 0;
                while (i < copiedListeners.length) {
                    this.fListener = (IExpressionListener)copiedListeners[i];
                    int j = 0;
                    while (j < expressions.length) {
                        this.fExpression = expressions[j];
                        Platform.run((ISafeRunnable)this);
                        ++j;
                    }
                    ++i;
                }
            }
            this.fListener = null;
            this.fExpression = null;
        }
    }

    class ExpressionsNotifier
    implements ISafeRunnable {
        private IExpressionsListener fListener;
        private int fType;
        private IExpression[] fNotifierExpressions;

        ExpressionsNotifier() {
        }

        public void handleException(Throwable exception) {
            Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 120, DebugCoreMessages.getString("ExpressionManager.An_exception_occurred_during_expression_change_notification._1"), exception);
            DebugPlugin.log((IStatus)status);
        }

        public void run() throws Exception {
            switch (this.fType) {
                case 1: {
                    this.fListener.expressionsAdded(this.fNotifierExpressions);
                    break;
                }
                case 3: {
                    this.fListener.expressionsRemoved(this.fNotifierExpressions);
                    break;
                }
                case 2: {
                    this.fListener.expressionsChanged(this.fNotifierExpressions);
                }
            }
        }

        public void notify(IExpression[] expressions, int update) {
            if (ExpressionManager.this.fExpressionsListeners != null) {
                this.fNotifierExpressions = expressions;
                this.fType = update;
                Object[] copiedListeners = ExpressionManager.this.fExpressionsListeners.getListeners();
                int i = 0;
                while (i < copiedListeners.length) {
                    this.fListener = (IExpressionsListener)copiedListeners[i];
                    Platform.run((ISafeRunnable)this);
                    ++i;
                }
            }
            this.fNotifierExpressions = null;
            this.fListener = null;
        }
    }
}

