/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.model;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIArrayEntryVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIArrayValue;
import org.eclipse.jdt.internal.debug.core.model.JDIClassObjectValue;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugElement;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugModelMessages;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIFieldVariable;
import org.eclipse.jdt.internal.debug.core.model.JDINullValue;
import org.eclipse.jdt.internal.debug.core.model.JDIObjectValue;
import org.eclipse.jdt.internal.debug.core.model.JDIPrimitiveValue;
import org.eclipse.jdt.internal.debug.core.model.JDIType;

public class JDIValue
extends JDIDebugElement
implements IValue,
IJavaValue {
    private Value fValue;
    private List fVariables;
    private boolean fAllocated = true;
    static /* synthetic */ Class class$0;

    public JDIValue(JDIDebugTarget target, Value value) {
        super(target);
        this.fValue = value;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.debug.core.IJavaValue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public static JDIValue createValue(JDIDebugTarget target, Value value) {
        if (value == null) {
            return new JDINullValue(target);
        }
        if (value instanceof ArrayReference) {
            return new JDIArrayValue(target, (ArrayReference)value);
        }
        if (value instanceof ClassObjectReference) {
            return new JDIClassObjectValue(target, (ClassObjectReference)value);
        }
        if (value instanceof ObjectReference) {
            return new JDIObjectValue(target, (ObjectReference)value);
        }
        if (value instanceof PrimitiveValue) {
            return new JDIPrimitiveValue(target, value);
        }
        return new JDIValue(target, value);
    }

    public String getValueString() throws DebugException {
        if (!this.isAllocated()) {
            return JDIDebugModelMessages.getString("JDIValue.deallocated");
        }
        if (this.fValue == null) {
            return JDIDebugModelMessages.getString("JDIValue.null_4");
        }
        if (this.fValue instanceof StringReference) {
            try {
                return ((StringReference)this.fValue).value();
            }
            catch (RuntimeException e) {
                this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIValue.exception_retrieving_value"), e.toString()), e);
                return null;
            }
        }
        if (this.fValue instanceof ObjectReference) {
            StringBuffer name = new StringBuffer();
            if (this.fValue instanceof ClassObjectReference) {
                name.append('(');
                name.append(((ClassObjectReference)this.fValue).reflectedType());
                name.append(')');
            }
            name.append(" (");
            name.append(JDIDebugModelMessages.getString("JDIValue.id_8"));
            name.append('=');
            try {
                name.append(((ObjectReference)this.fValue).uniqueID());
            }
            catch (RuntimeException e) {
                this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIValue.exception_retrieving_unique_id"), e.toString()), e);
                return null;
            }
            name.append(')');
            return name.toString();
        }
        return String.valueOf(this.fValue);
    }

    public String getReferenceTypeName() throws DebugException {
        try {
            if (this.fValue == null) {
                return JDIDebugModelMessages.getString("JDIValue.null_4");
            }
            return this.getUnderlyingType().name();
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIValue.exception_retrieving_reference_type_name"), e.toString()), e);
            return null;
        }
    }

    public int hashCode() {
        if (this.fValue == null) {
            return this.getClass().hashCode();
        }
        return this.fValue.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof JDIValue) {
            Value other = ((JDIValue)o).getUnderlyingValue();
            if (this.fValue == null) {
                return false;
            }
            if (other == null) {
                return false;
            }
            return this.fValue.equals(other);
        }
        return false;
    }

    public IVariable[] getVariables() throws DebugException {
        List list = this.getVariablesList();
        return list.toArray(new IVariable[list.size()]);
    }

    protected List getVariablesList() throws DebugException {
        if (!this.isAllocated()) {
            return Collections.EMPTY_LIST;
        }
        if (this.fVariables != null) {
            return this.fVariables;
        }
        if (this.fValue instanceof ObjectReference) {
            ObjectReference object = (ObjectReference)this.fValue;
            this.fVariables = new ArrayList();
            if (this.isArray()) {
                int length = this.getArrayLength();
                ArrayList<JDIArrayEntryVariable> list = new ArrayList<JDIArrayEntryVariable>(length);
                int i = 0;
                while (i < length) {
                    list.add(new JDIArrayEntryVariable(this.getJavaDebugTarget(), this.getArrayReference(), i));
                    ++i;
                }
                this.fVariables = list;
            } else {
                List<Field> fields = null;
                try {
                    ReferenceType refType = object.referenceType();
                    fields = refType.allFields();
                }
                catch (RuntimeException e) {
                    this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIValue.exception_retrieving_fields"), e.toString()), e);
                    return null;
                }
                Iterator<Field> list = fields.iterator();
                while (list.hasNext()) {
                    Field field = list.next();
                    this.fVariables.add(new JDIFieldVariable((JDIDebugTarget)this.getDebugTarget(), field, object));
                }
                Collections.sort(this.fVariables, new Comparator(){

                    public int compare(Object a, Object b) {
                        return JDIValue.this.sortChildren(a, b);
                    }
                });
            }
            return this.fVariables;
        }
        return Collections.EMPTY_LIST;
    }

    protected int sortChildren(Object a, Object b) {
        IJavaVariable v1 = (IJavaVariable)a;
        IJavaVariable v2 = (IJavaVariable)b;
        try {
            boolean v1isStatic = v1.isStatic();
            boolean v2isStatic = v2.isStatic();
            if (v1isStatic && !v2isStatic) {
                return -1;
            }
            if (!v1isStatic && v2isStatic) {
                return 1;
            }
            return v1.getName().compareToIgnoreCase(v2.getName());
        }
        catch (DebugException de) {
            this.logError((Exception)((Object)de));
            return -1;
        }
    }

    protected boolean isArray() {
        return this.fValue instanceof ArrayReference;
    }

    protected ArrayReference getArrayReference() {
        if (this.isArray()) {
            return (ArrayReference)this.fValue;
        }
        return null;
    }

    public boolean isAllocated() throws DebugException {
        if (this.fAllocated) {
            if (this.fValue instanceof ObjectReference) {
                try {
                    this.fAllocated = !((ObjectReference)this.fValue).isCollected();
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    this.fAllocated = false;
                }
                catch (RuntimeException e) {
                    this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIValue.exception_is_collected"), e.toString()), e);
                }
            } else {
                JDIDebugTarget dt = (JDIDebugTarget)this.getDebugTarget();
                this.fAllocated = dt.isAvailable();
            }
        }
        return this.fAllocated;
    }

    public String getSignature() throws DebugException {
        try {
            if (this.fValue != null) {
                return this.fValue.type().signature();
            }
            return null;
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIValue.exception_retrieving_type_signature"), e.toString()), e);
            return null;
        }
    }

    public int getArrayLength() throws DebugException {
        if (this.isArray()) {
            try {
                return this.getArrayReference().length();
            }
            catch (RuntimeException e) {
                this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIValue.exception_retrieving_length_of_array"), e.toString()), e);
            }
        }
        return -1;
    }

    protected Value getUnderlyingValue() {
        return this.fValue;
    }

    public IJavaType getJavaType() throws DebugException {
        return JDIType.createType((JDIDebugTarget)this.getDebugTarget(), this.getUnderlyingType());
    }

    protected Type getUnderlyingType() throws DebugException {
        try {
            return this.getUnderlyingValue().type();
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIValue.exception_retrieving_type"), e.toString()), e);
            return null;
        }
    }

    public String toString() {
        return this.getUnderlyingValue().toString();
    }

    public boolean hasVariables() throws DebugException {
        return this.getVariablesList().size() > 0;
    }
}

