/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdi.internal;

import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.StringReference;
import java.io.DataInputStream;
import java.io.IOException;
import org.eclipse.jdi.internal.JDIMessages;
import org.eclipse.jdi.internal.MirrorImpl;
import org.eclipse.jdi.internal.ObjectReferenceImpl;
import org.eclipse.jdi.internal.VirtualMachineImpl;
import org.eclipse.jdi.internal.jdwp.JdwpReplyPacket;
import org.eclipse.jdi.internal.jdwp.JdwpStringID;

public class StringReferenceImpl
extends ObjectReferenceImpl
implements StringReference {
    public static final byte tag = 115;

    public StringReferenceImpl(VirtualMachineImpl vmImpl, JdwpStringID stringID) {
        super("StringReference", vmImpl, stringID);
    }

    public byte getTag() {
        return 115;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String value() {
        String string;
        this.initJdwpRequest();
        try {
            try {
                String result;
                JdwpReplyPacket replyPacket = this.requestVM(2561, this);
                this.defaultReplyErrorHandler(replyPacket.errorCode());
                DataInputStream replyData = replyPacket.dataInStream();
                string = result = this.readString("value", replyData);
                Object var4_7 = null;
            }
            catch (IOException e) {
                this.defaultIOExceptionHandler(e);
                String string2 = null;
                Object var4_8 = null;
                this.handledJdwpRequest();
                return string2;
            }
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            this.handledJdwpRequest();
            throw throwable;
        }
        this.handledJdwpRequest();
        return string;
    }

    public static StringReferenceImpl read(MirrorImpl target, DataInputStream in) throws IOException {
        VirtualMachineImpl vmImpl = target.virtualMachineImpl();
        JdwpStringID ID = new JdwpStringID(vmImpl);
        ID.read(in);
        if (target.fVerboseWriter != null) {
            target.fVerboseWriter.println("stringReference", ID.value());
        }
        if (ID.isNull()) {
            return null;
        }
        StringReferenceImpl mirror = new StringReferenceImpl(vmImpl, ID);
        return mirror;
    }

    public String toString() {
        try {
            return "\"" + this.value() + "\"";
        }
        catch (ObjectCollectedException objectCollectedException) {
            return String.valueOf(JDIMessages.getString("StringReferenceImpl.(Garbage_Collected)_StringReference__3")) + this.idString();
        }
        catch (Exception exception) {
            return this.fDescription;
        }
    }
}

