/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.WizardCheckboxTablePart;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.pde.internal.ui.wizards.imports.BaseImportWizardSecondPage;
import org.eclipse.pde.internal.ui.wizards.imports.PluginImportWizardFirstPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.help.WorkbenchHelp;

public class PluginImportWizardExpressPage
extends BaseImportWizardSecondPage {
    private TablePart tablePart;
    private IStructuredSelection initialSelection;
    private Label counterLabel;

    public PluginImportWizardExpressPage(String pageName, PluginImportWizardFirstPage page, IStructuredSelection selection) {
        super(pageName, page);
        this.initialSelection = selection;
        this.setTitle(PDEPlugin.getResourceString("ImportWizard.expressPage.title"));
        this.setMessage(PDEPlugin.getResourceString("ImportWizard.expressPage.desc"));
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 20;
        layout.verticalSpacing = 10;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        this.createTablePart(container);
        this.createImportPart(container);
        Composite options = this.createComputationsOption(container);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        options.setLayoutData((Object)gd);
        this.addFragmentsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginImportWizardExpressPage.this.pageChanged();
            }
        });
        this.initialize();
        this.setControl((Control)container);
        WorkbenchHelp.setHelp((Control)container, (String)"org.eclipse.pde.doc.user.plugin_import_express_page");
        Dialog.applyDialogFont((Control)container);
    }

    private Composite createTablePart(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        this.tablePart = new TablePart(PDEPlugin.getResourceString("ImportWizard.expressPage.nonBinary"), new String[]{PDEPlugin.getResourceString("WizardCheckboxTablePart.selectAll"), PDEPlugin.getResourceString("WizardCheckboxTablePart.deselectAll")});
        this.tablePart.createControl(container);
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        gd.widthHint = 225;
        this.tablePart.getControl().setLayoutData((Object)gd);
        CheckboxTableViewer viewer = this.tablePart.getTableViewer();
        viewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        viewer.setContentProvider((IContentProvider)new PluginContentProvider());
        viewer.setSorter(ListUtil.PLUGIN_SORTER);
        viewer.setInput((Object)PDEPlugin.getWorkspace().getRoot());
        return container;
    }

    private void createImportPart(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(1808));
        this.createImportList(container);
        this.counterLabel = new Label(container, 0);
        this.counterLabel.setLayoutData((Object)new GridData(768));
    }

    private void initialize() {
        Object[] items = this.initialSelection.toArray();
        ArrayList<IPluginModelBase> list = new ArrayList<IPluginModelBase>();
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        int i = 0;
        while (i < items.length) {
            IPluginModelBase model;
            IProject project;
            Object item = items[i];
            if (item instanceof IJavaProject) {
                item = ((IJavaProject)item).getProject();
            }
            if (item instanceof IProject && (project = (IProject)item).isOpen() && WorkspaceModelManager.isPluginProject((IProject)project) && !WorkspaceModelManager.isBinaryPluginProject((IProject)project) && (model = manager.findModel(project)) != null) {
                list.add(model);
            }
            ++i;
        }
        this.tablePart.setSelection(list.toArray());
    }

    private void computeModelsToImport() {
        this.importListViewer.getTable().removeAll();
        ArrayList result = new ArrayList();
        Object[] wModels = this.tablePart.getSelection();
        int i = 0;
        while (i < wModels.length) {
            IPluginModelBase model = (IPluginModelBase)wModels[i];
            this.addDependencies(model, result, this.addFragmentsButton.getSelection());
            this.addExtraPrerequisites(model, result);
            ++i;
        }
        if (wModels.length > 0) {
            this.removeSharedModels(result);
        }
        this.importListViewer.add(result.toArray());
    }

    private void removeSharedModels(ArrayList result) {
        IPluginModelBase[] smodels = result.toArray(new IPluginModelBase[result.size()]);
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        int i = 0;
        while (i < smodels.length) {
            IProject project;
            IResource resource;
            String id = smodels[i].getPluginBase().getId();
            IPluginModelBase model = manager.findModel(id);
            if (model != null && (resource = model.getUnderlyingResource()) != null && !WorkspaceModelManager.isUnsharedPluginProject((IProject)(project = resource.getProject()))) {
                result.remove(smodels[i]);
            }
            ++i;
        }
    }

    private void addExtraPrerequisites(IPluginModelBase model, ArrayList result) {
        try {
            IFile buildFile;
            IBuildModel buildModel = model.getBuildModel();
            if (buildModel == null && (buildFile = model.getUnderlyingResource().getProject().getFile("build.properties")).exists()) {
                buildModel = new WorkspaceBuildModel(buildFile);
                buildModel.load();
            }
            if (buildModel == null) {
                return;
            }
            IBuildEntry entry = buildModel.getBuild().getEntry("jars.extra.classpath");
            if (entry == null) {
                return;
            }
            String[] tokens = entry.getTokens();
            int i = 0;
            while (i < tokens.length) {
                Path path = new Path(tokens[i]);
                if (path.segmentCount() >= 2 && path.segment(0).equals("..")) {
                    int j = 0;
                    while (j < this.models.length) {
                        if (this.models[j].getPluginBase().getId().equals(path.segment(1)) && !result.contains(this.models[j])) {
                            result.add(this.models[j]);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
    }

    protected void refreshPage() {
        this.pageChanged();
    }

    protected void pageChanged() {
        this.computeModelsToImport();
        this.updateCount();
        this.setPageComplete(this.importListViewer.getTable().getItemCount() > 0);
    }

    private void updateCount() {
        this.counterLabel.setText(PDEPlugin.getFormattedMessage("ImportWizard.expressPage.total", new Integer(this.importListViewer.getTable().getItemCount()).toString()));
        this.counterLabel.getParent().layout();
    }

    class PluginContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        PluginContentProvider() {
        }

        public Object[] getElements(Object parent) {
            IProject[] projects = PDEPlugin.getWorkspace().getRoot().getProjects();
            ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>();
            PluginModelManager manager = PDECore.getDefault().getModelManager();
            int i = 0;
            while (i < projects.length) {
                IPluginModelBase model;
                if (projects[i].isOpen() && WorkspaceModelManager.isPluginProject((IProject)projects[i]) && !WorkspaceModelManager.isBinaryPluginProject((IProject)projects[i]) && (model = manager.findModel(projects[i])) != null) {
                    result.add(model);
                }
                ++i;
            }
            return result.toArray();
        }
    }

    class TablePart
    extends WizardCheckboxTablePart {
        public TablePart(String mainLabel, String[] buttonLabels) {
            super(mainLabel, buttonLabels);
            this.setSelectAllIndex(0);
            this.setDeselectAllIndex(1);
        }

        public void updateCounter(int count) {
            super.updateCounter(count);
        }

        public void buttonSelected(Button button, int index) {
            if (index == 0 || index == 1) {
                super.buttonSelected(button, index);
            }
        }

        protected StructuredViewer createStructuredViewer(Composite parent, int style, FormToolkit toolkit) {
            StructuredViewer viewer = super.createStructuredViewer(parent, style, toolkit);
            return viewer;
        }

        protected void elementChecked(Object element, boolean checked) {
            super.elementChecked(element, checked);
            PluginImportWizardExpressPage.this.pageChanged();
        }

        protected void handleSelectAll(boolean select) {
            super.handleSelectAll(select);
            PluginImportWizardExpressPage.this.pageChanged();
        }
    }
}

