/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.extension;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.wizards.extension.BaseExtensionPointMainPage;
import org.eclipse.swt.widgets.Composite;

public class NewSchemaFileMainPage
extends BaseExtensionPointMainPage {
    public static final String KEY_TITLE = "NewSchemaFileWizard.title";
    public static final String KEY_DESC = "NewSchemaFileWizard.desc";
    private IPluginExtensionPoint point;
    private IContainer container;
    private boolean isPluginIdFinal;

    public NewSchemaFileMainPage(IContainer container) {
        this(container, null, false);
    }

    public NewSchemaFileMainPage(IContainer container, IPluginExtensionPoint point, boolean isPluginIdFinal) {
        super(container);
        this.setTitle(PDEPlugin.getResourceString(KEY_TITLE));
        this.setDescription(PDEPlugin.getResourceString(KEY_DESC));
        this.point = point;
        this.container = container;
        this.isPluginIdFinal = isPluginIdFinal;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.initializeValues();
        this.pluginIdText.setEnabled(!this.isPluginIdFinal);
        this.pluginBrowseButton.setEnabled(!this.isPluginIdFinal);
        this.setMessage(null);
    }

    public boolean finish() {
        IRunnableWithProgress operation = this.getOperation();
        try {
            this.getContainer().run(false, true, operation);
            if (this.point != null) {
                this.point.setId(this.idText.getText());
                this.point.setName(this.nameText.getText());
                this.point.setSchema(this.schemaText.getText());
            }
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (CoreException coreException) {
            return false;
        }
        return true;
    }

    protected boolean isPluginIdNeeded() {
        return true;
    }

    protected boolean isPluginIdFinal() {
        return this.isPluginIdFinal;
    }

    protected boolean isSharedSchemaSwitchNeeded() {
        return true;
    }

    public void initializeValues() {
        if (this.container != null) {
            this.pluginIdText.setText(this.container.getProject().getName());
            if (!this.isPluginIdFinal()) {
                this.schemaLocationText.setText(String.valueOf(this.container.getProject().getName()) + "/" + this.container.getProjectRelativePath().toString());
            }
        }
        if (this.point == null) {
            return;
        }
        if (this.idText != null && this.point.getId() != null) {
            this.idText.setText(this.point.getId());
        }
        if (this.nameText != null && this.point.getName() != null) {
            this.nameText.setText(this.point.getName());
        }
        if (this.schemaText != null && this.point.getSchema() != null) {
            this.schemaText.setText(this.point.getSchema());
        }
    }
}

