/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.extension;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.wizards.NewWizard;
import org.eclipse.pde.internal.ui.wizards.WizardCollectionElement;
import org.eclipse.pde.internal.ui.wizards.WizardElement;
import org.eclipse.pde.internal.ui.wizards.extension.NewExtensionRegistryReader;
import org.eclipse.pde.internal.ui.wizards.extension.PointSelectionPage;

public class NewExtensionWizard
extends NewWizard {
    public static final String PLUGIN_POINT = "newExtension";
    public static final String STATUS_MESSAGE = "NewExtensionWizard.statusMessage";
    private static final String KEY_WTITLE = "NewExtensionWizard.wtitle";
    private PointSelectionPage pointPage;
    private IPluginModelBase model;
    private IProject project;
    private ManifestEditor editor;
    private WizardCollectionElement wizardCollection;

    public NewExtensionWizard(IProject project, IPluginModelBase model, ManifestEditor editor) {
        this.setDialogSettings(PDEPlugin.getDefault().getDialogSettings());
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_NEWEX_WIZ);
        this.model = model;
        this.project = project;
        this.editor = editor;
        this.setForcePreviousAndNextButtons(true);
        this.setWindowTitle(PDEPlugin.getResourceString(KEY_WTITLE));
        PDEPlugin.getDefault().getLabelProvider().connect(this);
        this.loadWizardCollection();
    }

    public void addPages() {
        this.pointPage = new PointSelectionPage(this.project, this.model.getPluginBase(), this.wizardCollection, this.getTemplates(), this);
        this.addPage((IWizardPage)this.pointPage);
    }

    private void loadWizardCollection() {
        NewExtensionRegistryReader reader = new NewExtensionRegistryReader();
        this.wizardCollection = (WizardCollectionElement)reader.readRegistry(PDEPlugin.getPluginId(), PLUGIN_POINT, false);
    }

    public WizardCollectionElement getTemplates() {
        WizardCollectionElement templateCollection = new WizardCollectionElement("", "", null);
        this.collectTemplates(this.wizardCollection.getChildren(), templateCollection);
        return templateCollection;
    }

    private void collectTemplates(Object[] children, WizardCollectionElement list) {
        int i = 0;
        while (i < children.length) {
            WizardElement wizard;
            if (children[i] instanceof WizardCollectionElement) {
                WizardCollectionElement element = (WizardCollectionElement)children[i];
                this.collectTemplates(element.getChildren(), list);
                this.collectTemplates(element.getWizards().getChildren(), list);
            } else if (children[i] instanceof WizardElement && (wizard = (WizardElement)children[i]).isTemplate()) {
                list.getWizards().add(wizard);
            }
            ++i;
        }
    }

    public boolean performFinish() {
        if (this.pointPage.canFinish()) {
            return this.pointPage.finish();
        }
        return true;
    }

    public ManifestEditor getEditor() {
        return this.editor;
    }

    public void dispose() {
        super.dispose();
        PDEPlugin.getDefault().getLabelProvider().disconnect(this);
    }
}

