/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.wizards.BaseWizardSelectionPage;
import org.eclipse.pde.internal.ui.wizards.WizardElement;
import org.eclipse.pde.ui.IBasePluginWizard;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

public abstract class WizardNode
implements IWizardNode {
    private IWizard wizard;
    private BaseWizardSelectionPage parentWizardPage;
    public static final String KEY_CREATION_ERROR_TEXT = "Errors.CreationError.NoWizard";
    public static final String KEY_CREATION_ERROR = "Errors.CreationError";
    protected WizardElement wizardElement;

    public WizardNode(BaseWizardSelectionPage parentPage, WizardElement element) {
        this.parentWizardPage = parentPage;
        this.wizardElement = element;
    }

    protected abstract IBasePluginWizard createWizard() throws CoreException;

    public void dispose() {
        if (this.wizard != null) {
            this.wizard.dispose();
            this.wizard = null;
        }
    }

    public WizardElement getElement() {
        return this.wizardElement;
    }

    public Point getExtent() {
        return new Point(-1, -1);
    }

    public IWizard getWizard() {
        IBasePluginWizard pluginWizard;
        if (this.wizard != null) {
            return this.wizard;
        }
        try {
            pluginWizard = this.createWizard();
        }
        catch (CoreException coreException) {
            this.parentWizardPage.setDescriptionText("");
            this.parentWizardPage.setErrorMessage(PDEPlugin.getResourceString(KEY_CREATION_ERROR_TEXT));
            MessageDialog.openError((Shell)this.parentWizardPage.getWizard().getContainer().getShell(), (String)PDEPlugin.getResourceString(KEY_CREATION_ERROR), (String)PDEPlugin.getResourceString(KEY_CREATION_ERROR_TEXT));
            return null;
        }
        this.wizard = pluginWizard;
        return this.wizard;
    }

    public boolean isContentCreated() {
        return this.wizard != null;
    }
}

