/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.model.bundle;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.ui.model.IDocumentKey;
import org.eclipse.pde.internal.ui.model.bundle.BundleModel;
import org.eclipse.pde.internal.ui.model.bundle.ManifestHeader;

public class Bundle
implements IBundle {
    private BundleModel fModel;
    private Hashtable fDocumentHeaders = new Hashtable();

    public Bundle(BundleModel model) {
        this.fModel = model;
    }

    public void clearHeaders() {
        this.fDocumentHeaders.clear();
    }

    public void load(Manifest manifest) {
        Attributes attributes = manifest.getMainAttributes();
        Iterator iter = attributes.keySet().iterator();
        while (iter.hasNext()) {
            Attributes.Name key = (Attributes.Name)iter.next();
            ManifestHeader header = new ManifestHeader();
            header.setName(key.toString());
            header.setValue((String)attributes.get(key));
            this.fDocumentHeaders.put(key.toString(), header);
        }
        this.adjustOffsets(this.fModel.getDocument());
    }

    public void clearOffsets() {
        Iterator iter = this.fDocumentHeaders.values().iterator();
        while (iter.hasNext()) {
            ManifestHeader header = (ManifestHeader)iter.next();
            header.setOffset(-1);
            header.setLength(-1);
        }
    }

    public void trim() {
        Iterator iter = this.fDocumentHeaders.keySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next().toString();
            ManifestHeader header = (ManifestHeader)this.fDocumentHeaders.get(key);
            if (header.getOffset() != -1) continue;
            this.fDocumentHeaders.remove(key);
        }
    }

    protected void adjustOffsets(IDocument document) {
        int lines = document.getNumberOfLines();
        try {
            IDocumentKey currentKey = null;
            int i = 0;
            while (i < lines) {
                int index;
                String name;
                int offset = document.getLineOffset(i);
                int length = document.getLineLength(i);
                String line = document.get(offset, length);
                if (currentKey != null) {
                    int lineNumber = line.startsWith(" ") ? i : i - 1;
                    IRegion region = document.getLineInformation(lineNumber);
                    String delimiter = document.getLineDelimiter(lineNumber);
                    int keyLength = region.getOffset() + region.getLength() - currentKey.getOffset();
                    currentKey.setLength(delimiter != null ? keyLength + delimiter.length() : keyLength);
                    if (!line.startsWith(" ")) {
                        currentKey = null;
                    }
                }
                if (currentKey == null && (currentKey = (IDocumentKey)this.fDocumentHeaders.get(name = (index = line.indexOf(58)) != -1 ? line.substring(0, index) : line)) != null) {
                    IRegion region = document.getLineInformation(i);
                    currentKey.setOffset(region.getOffset());
                    String delimiter = document.getLineDelimiter(i);
                    currentKey.setLength(delimiter != null ? region.getLength() + delimiter.length() : region.getLength());
                }
                ++i;
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    public void setHeader(String key, String value) {
        ManifestHeader header = (ManifestHeader)this.fDocumentHeaders.get(key);
        if (header == null) {
            header = new ManifestHeader();
        }
        header.setName(key);
        header.setValue(value);
        this.fDocumentHeaders.put(key, header);
        this.fModel.fireModelObjectChanged(header, key, null, value);
    }

    public String getHeader(String key) {
        ManifestHeader header = (ManifestHeader)this.fDocumentHeaders.get(key);
        return header != null ? header.getValue() : null;
    }

    public Dictionary getHeaders() {
        return this.fDocumentHeaders;
    }
}

