/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.text;

import java.util.ArrayList;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.pde.internal.ui.editor.text.IReconcilingParticipant;

public class ReconcilingStrategy
implements IReconcilingStrategy {
    private IDocument fDocument;
    private ArrayList fParticipants = new ArrayList();

    public void setDocument(IDocument document) {
        this.fDocument = document;
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        if (this.fDocument == null) {
            return;
        }
        this.notifyParticipants();
    }

    public void reconcile(IRegion partition) {
        if (this.fDocument == null) {
            return;
        }
        this.notifyParticipants();
    }

    private synchronized void notifyParticipants() {
        int i = 0;
        while (i < this.fParticipants.size()) {
            ((IReconcilingParticipant)this.fParticipants.get(i)).reconciled(this.fDocument);
            ++i;
        }
    }

    public void addParticipant(IReconcilingParticipant participant) {
        this.fParticipants.add(participant);
    }

    public void removeParticipant(IReconcilingParticipant participant) {
        this.fParticipants.remove(participant);
    }
}

