/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.isite.ISite;
import org.eclipse.pde.internal.core.isite.ISiteBuildFeature;
import org.eclipse.pde.internal.core.isite.ISiteCategory;
import org.eclipse.pde.internal.core.isite.ISiteCategoryDefinition;
import org.eclipse.pde.internal.core.isite.ISiteFeature;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.ModelDataTransfer;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TreeSection;
import org.eclipse.pde.internal.ui.editor.site.FeaturePropertiesDialog;
import org.eclipse.pde.internal.ui.editor.site.FeatureSection;
import org.eclipse.pde.internal.ui.editor.site.NewCategoryDefinitionDialog;
import org.eclipse.pde.internal.ui.editor.site.SiteFeatureAdapter;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.TreePart;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class CategorySection
extends TreeSection {
    private ISiteModel fModel;
    private TreePart fCategoryTreePart;
    private TreeViewer fCategoryViewer;

    public CategorySection(PDEFormPage formPage, Composite parent) {
        super(formPage, parent, 128, new String[]{PDEPlugin.getResourceString("CategorySection.new")});
        this.getSection().setText(PDEPlugin.getResourceString("CategorySection.title"));
        this.getSection().setDescription(PDEPlugin.getResourceString("CategorySection.desc"));
    }

    public void createClient(Section section, FormToolkit toolkit) {
        this.fModel = (ISiteModel)this.getPage().getModel();
        this.fModel.addModelChangedListener((IModelChangedListener)this);
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createViewerPartControl(container, 4, 2, toolkit);
        this.fCategoryTreePart = this.getTreePart();
        this.fCategoryViewer = this.fCategoryTreePart.getTreeViewer();
        this.fCategoryViewer.setContentProvider((IContentProvider)new CategoryContentProvider());
        this.fCategoryViewer.setLabelProvider((IBaseLabelProvider)new CategoryLabelProvider());
        this.fCategoryViewer.setInput((Object)this.fModel.getSite());
        int ops = 23;
        Transfer[] transfers = new Transfer[]{ModelDataTransfer.getInstance()};
        this.fCategoryViewer.addDropSupport(ops, transfers, (DropTargetListener)new ViewerDropAdapter((Viewer)this.fCategoryViewer){

            public void dragEnter(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 4) != 0 ? 4 : 2;
                }
            }

            public void dragOperationChanged(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 4) != 0 ? 4 : 2;
                }
            }

            public boolean performDrop(Object data) {
                if (!(data instanceof Object[])) {
                    return false;
                }
                Object target = this.getCurrentTarget();
                int op = this.getCurrentOperation();
                Object[] objects = (Object[])data;
                if (op == 4) {
                    int i = 0;
                    while (i < objects.length) {
                        if (objects[i] instanceof ISiteBuildFeature) {
                            CategorySection.this.linkFeature((ISiteBuildFeature)objects[i], target);
                        }
                        ++i;
                    }
                    return true;
                }
                if (objects.length > 0 && objects[0] instanceof SiteFeatureAdapter) {
                    if (op == 1) {
                        CategorySection.this.copyFeature((SiteFeatureAdapter)objects[0], target);
                    } else {
                        CategorySection.this.moveFeature((SiteFeatureAdapter)objects[0], target);
                    }
                    return true;
                }
                return false;
            }

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                if (target == null && operation == 1) {
                    return false;
                }
                return target instanceof ISiteCategoryDefinition || target == null;
            }
        });
        this.fCategoryViewer.addDragSupport(3, transfers, new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                IStructuredSelection ssel = (IStructuredSelection)CategorySection.this.fCategoryViewer.getSelection();
                if (ssel == null || ssel.isEmpty() || ssel.getFirstElement() instanceof ISiteCategoryDefinition) {
                    event.doit = false;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                IStructuredSelection ssel = (IStructuredSelection)CategorySection.this.fCategoryViewer.getSelection();
                event.data = ssel.toArray();
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        this.initialize();
    }

    private void linkFeature(ISiteBuildFeature sbFeature, Object target) {
        try {
            ISiteFeature feature = FeatureSection.findMatchingSiteFeature(this.fModel, sbFeature);
            if (feature == null) {
                feature = FeatureSection.createSiteFeature(this.fModel, sbFeature);
                this.fModel.getSite().addFeatures(new ISiteFeature[]{feature});
            }
            if (target != null && target instanceof ISiteCategoryDefinition) {
                this.addCategory(feature, false, (ISiteCategoryDefinition)target);
            }
        }
        catch (CoreException coreException) {}
    }

    private void copyFeature(SiteFeatureAdapter adapter, Object target) {
        if (adapter.category == null) {
            this.moveFeature(adapter, target);
        } else if (target instanceof ISiteCategoryDefinition) {
            if (this.findRealFeature(adapter.feature) != null) {
                this.addCategory(adapter.feature, true, (ISiteCategoryDefinition)target);
            }
            this.linkFeature(this.findBuildFeature(adapter.feature), (ISiteCategoryDefinition)target);
        } else if (target == null) {
            this.linkFeature(this.findBuildFeature(adapter.feature), null);
        }
    }

    private ISiteBuildFeature findBuildFeature(ISiteFeature feature) {
        if (feature == null) {
            return null;
        }
        ISiteBuildFeature[] buildFeatures = this.fModel.getBuildModel().getSiteBuild().getFeatures();
        int i = 0;
        while (i < buildFeatures.length) {
            if (buildFeatures[i].getTargetURL().equals(feature.getURL())) {
                return buildFeatures[i];
            }
            ++i;
        }
        return null;
    }

    private void addCategory(ISiteFeature aFeature, boolean isCopy, ISiteCategoryDefinition target) {
        try {
            ISiteFeature feature;
            ISiteFeature iSiteFeature = feature = isCopy ? this.findRealFeature(aFeature) : aFeature;
            if (feature == null) {
                return;
            }
            ISiteCategoryDefinition catDef = target;
            ISiteCategory[] cats = feature.getCategories();
            int j = 0;
            while (j < cats.length) {
                if (cats[j].getName().equals(catDef.getName())) break;
                ++j;
            }
            if (j == cats.length) {
                ISiteCategory cat = this.fModel.getFactory().createCategory(feature);
                cat.setName(catDef.getName());
                feature.addCategories(new ISiteCategory[]{cat});
            }
        }
        catch (CoreException coreException) {}
    }

    private void moveFeature(SiteFeatureAdapter adapter, Object target) {
        if (adapter.category != null) {
            this.removeCategory(adapter.feature, true, adapter.category);
        }
        if (target instanceof ISiteCategoryDefinition) {
            this.addCategory(adapter.feature, true, (ISiteCategoryDefinition)target);
        } else if (target == null) {
            this.linkFeature(this.findBuildFeature(adapter.feature), null);
        }
    }

    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleAddCategoryDefinition();
            }
        }
    }

    protected void handleDoubleClick(IStructuredSelection ssel) {
        Object selected = ssel.getFirstElement();
        if (selected instanceof ISiteCategoryDefinition) {
            this.handleEditCategoryDefinition();
        } else if (selected instanceof SiteFeatureAdapter) {
            this.handleEditFeatureProperties((SiteFeatureAdapter)selected);
        }
    }

    private void handleEditFeatureProperties(SiteFeatureAdapter adapter) {
        final ISiteFeature feature = adapter.feature;
        BusyIndicator.showWhile((Display)this.fCategoryViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                FeaturePropertiesDialog dialog = new FeaturePropertiesDialog(CategorySection.this.fCategoryViewer.getControl().getShell(), CategorySection.this.fModel, feature);
                dialog.create();
                dialog.open();
            }
        });
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
    }

    private void handleEditCategoryDefinition() {
        IStructuredSelection ssel = (IStructuredSelection)this.fCategoryViewer.getSelection();
        if (ssel != null && ssel.size() == 1) {
            this.showCategoryDialog((ISiteCategoryDefinition)ssel.getFirstElement());
        }
    }

    private void handleAddCategoryDefinition() {
        this.showCategoryDialog(null);
    }

    private boolean handleRemove() {
        IStructuredSelection ssel = (IStructuredSelection)this.fCategoryViewer.getSelection();
        Object object = ssel.getFirstElement();
        if (object == null) {
            return true;
        }
        if (object instanceof ISiteCategoryDefinition) {
            return this.handleRemoveCategoryDefinition((ISiteCategoryDefinition)object);
        }
        return this.handleRemoveSiteFeatureAdapter((SiteFeatureAdapter)object);
    }

    private boolean handleRemoveCategoryDefinition(ISiteCategoryDefinition catDef) {
        try {
            Object[] children = ((CategoryContentProvider)this.fCategoryViewer.getContentProvider()).getChildren(catDef);
            int i = 0;
            while (i < children.length) {
                SiteFeatureAdapter adapter = (SiteFeatureAdapter)children[i];
                ISiteCategory[] cats = adapter.feature.getCategories();
                int j = 0;
                while (j < cats.length) {
                    if (adapter.category.equals(cats[j].getName())) {
                        adapter.feature.removeCategories(new ISiteCategory[]{cats[j]});
                    }
                    ++j;
                }
                if (adapter.feature.getCategories().length == 0) {
                    this.fModel.getSite().removeFeatures(new ISiteFeature[]{adapter.feature});
                }
                ++i;
            }
            this.fModel.getSite().removeCategoryDefinitions(new ISiteCategoryDefinition[]{catDef});
            return true;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private boolean handleRemoveSiteFeatureAdapter(SiteFeatureAdapter adapter) {
        try {
            ISiteFeature feature = adapter.feature;
            if (adapter.category == null) {
                this.fModel.getSite().removeFeatures(new ISiteFeature[]{feature});
            } else {
                this.removeCategory(feature, false, adapter.category);
                if (feature.getCategories().length == 0) {
                    this.fModel.getSite().removeFeatures(new ISiteFeature[]{feature});
                }
            }
            return true;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private void removeCategory(ISiteFeature aFeature, boolean isCopy, String catName) {
        try {
            ISiteFeature feature;
            ISiteFeature iSiteFeature = feature = isCopy ? this.findRealFeature(aFeature) : aFeature;
            if (feature == null) {
                return;
            }
            ISiteCategory[] cats = feature.getCategories();
            int i = 0;
            while (i < cats.length) {
                if (catName.equals(cats[i].getName())) {
                    feature.removeCategories(new ISiteCategory[]{cats[i]});
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
    }

    private ISiteFeature findRealFeature(ISiteFeature aCopy) {
        ISiteFeature[] features = this.fModel.getSite().getFeatures();
        int i = 0;
        while (i < features.length) {
            if (features[i].getURL().equals(aCopy.getURL())) {
                return features[i];
            }
            ++i;
        }
        return null;
    }

    private void showCategoryDialog(final ISiteCategoryDefinition def) {
        BusyIndicator.showWhile((Display)this.fCategoryViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                NewCategoryDefinitionDialog dialog = new NewCategoryDefinitionDialog(CategorySection.this.fCategoryViewer.getControl().getShell(), CategorySection.this.fModel, def);
                dialog.create();
                dialog.open();
            }
        });
    }

    public void dispose() {
        super.dispose();
        this.fModel.removeModelChangedListener((IModelChangedListener)this);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)new Action(PDEPlugin.getResourceString("SiteEditor.remove")){

            public void run() {
                CategorySection.this.doGlobalAction(ActionFactory.DELETE.getId());
            }
        });
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new Action(PDEPlugin.getResourceString("SiteEditor.properties")){

            public void run() {
                CategorySection.this.handleDoubleClick((IStructuredSelection)CategorySection.this.fCategoryViewer.getSelection());
            }
        });
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleRemove();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        return actionId.equals(ActionFactory.DELETE.getId()) ? this.handleRemove() : false;
    }

    public void refresh() {
        this.fCategoryViewer.refresh();
        super.refresh();
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.markStale();
            return;
        }
        this.refresh();
    }

    public void initialize() {
        this.refresh();
    }

    protected void doPaste(Object target, Object[] objects) {
        try {
            int i = 0;
            while (i < objects.length) {
                if (objects[i] instanceof ISiteBuildFeature) {
                    this.linkFeature((ISiteBuildFeature)objects[i], target);
                } else if (objects[i] instanceof SiteFeatureAdapter) {
                    this.copyFeature((SiteFeatureAdapter)objects[i], target);
                } else if (objects[i] instanceof ISiteCategoryDefinition) {
                    this.fModel.getSite().addCategoryDefinitions(new ISiteCategoryDefinition[]{(ISiteCategoryDefinition)objects[i]});
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
    }

    protected boolean canPaste(Object target, Object[] objects) {
        if (target == null || target instanceof ISiteCategoryDefinition) {
            int i = 0;
            while (i < objects.length) {
                if (objects[i] instanceof ISiteBuildFeature || objects[i] instanceof SiteFeatureAdapter) {
                    return true;
                }
                if (objects[i] instanceof ISiteCategoryDefinition) {
                    String name = ((ISiteCategoryDefinition)objects[i]).getName();
                    ISiteCategoryDefinition[] defs = this.fModel.getSite().getCategoryDefinitions();
                    int j = 0;
                    while (j < defs.length) {
                        ISiteCategoryDefinition def = defs[j];
                        String dname = def.getName();
                        if (dname != null && dname.equals(name)) {
                            return false;
                        }
                        ++j;
                    }
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    class CategoryContentProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        CategoryContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ISite model = (ISite)inputElement;
            ArrayList<Object> result = new ArrayList<Object>();
            ISiteCategoryDefinition[] catDefs = model.getCategoryDefinitions();
            int i = 0;
            while (i < catDefs.length) {
                result.add(catDefs[i]);
                ++i;
            }
            ISiteFeature[] features = model.getFeatures();
            int i2 = 0;
            while (i2 < features.length) {
                if (features[i2].getCategories().length == 0) {
                    result.add(new SiteFeatureAdapter(null, features[i2]));
                }
                ++i2;
            }
            return result.toArray();
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof ISiteCategoryDefinition) {
                ISiteCategoryDefinition catDef = (ISiteCategoryDefinition)parent;
                ISiteFeature[] features = CategorySection.this.fModel.getSite().getFeatures();
                HashSet<SiteFeatureAdapter> result = new HashSet<SiteFeatureAdapter>();
                int i = 0;
                while (i < features.length) {
                    ISiteCategory[] cats = features[i].getCategories();
                    int j = 0;
                    while (j < cats.length) {
                        if (cats[j].getDefinition() != null && cats[j].getDefinition().equals(catDef)) {
                            result.add(new SiteFeatureAdapter(cats[j].getName(), features[i]));
                        }
                        ++j;
                    }
                    ++i;
                }
                return result.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof ISiteCategoryDefinition) {
                ISiteCategoryDefinition catDef = (ISiteCategoryDefinition)element;
                ISiteFeature[] features = CategorySection.this.fModel.getSite().getFeatures();
                int i = 0;
                while (i < features.length) {
                    ISiteCategory[] cats = features[i].getCategories();
                    int j = 0;
                    while (j < cats.length) {
                        if (cats[j].getDefinition() != null && cats[j].getDefinition().equals(catDef)) {
                            return true;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            return false;
        }
    }

    class CategoryLabelProvider
    extends LabelProvider {
        private Image siteFeatureImage = PDEPluginImages.DESC_FEATURE_OBJ.createImage();
        private Image catDefImage = PDEPluginImages.DESC_CATEGORY_OBJ.createImage();

        public Image getImage(Object element) {
            if (element instanceof ISiteCategoryDefinition) {
                return this.catDefImage;
            }
            if (element instanceof SiteFeatureAdapter) {
                return this.siteFeatureImage;
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof ISiteCategoryDefinition) {
                return ((ISiteCategoryDefinition)element).getName();
            }
            if (element instanceof SiteFeatureAdapter) {
                ISiteFeature feature = ((SiteFeatureAdapter)element).feature;
                if (feature.getId() != null && feature.getVersion() != null) {
                    return String.valueOf(feature.getId()) + " (" + feature.getVersion() + ")";
                }
                return feature.getURL();
            }
            return super.getText(element);
        }

        public void dispose() {
            super.dispose();
            this.catDefImage.dispose();
            this.siteFeatureImage.dispose();
        }
    }
}

