/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModelChangeProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.context.IInputContextListener;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.pde.internal.ui.editor.plugin.JavaAttributeValue;
import org.eclipse.pde.internal.ui.editor.plugin.JavaAttributeWizard;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.parts.ComboPart;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.PluginSelectionDialog;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.ide.IDE;

public class GeneralInfoSection
extends PDESection
implements IInputContextListener {
    public static final String KEY_MATCH = "ManifestEditor.PluginSpecSection.versionMatch";
    public static final String KEY_MATCH_PERFECT = "ManifestEditor.MatchSection.perfect";
    public static final String KEY_MATCH_EQUIVALENT = "ManifestEditor.MatchSection.equivalent";
    public static final String KEY_MATCH_COMPATIBLE = "ManifestEditor.MatchSection.compatible";
    public static final String KEY_MATCH_GREATER = "ManifestEditor.MatchSection.greater";
    private FormEntry fIdEntry;
    private FormEntry fVersionEntry;
    private FormEntry fNameEntry;
    private FormEntry fProviderEntry;
    private FormEntry fClassEntry;
    private Text fPluginIdText;
    private FormEntry fPluginVersionEntry;
    private Label fMatchLabel;
    private ComboPart fMatchCombo;

    public GeneralInfoSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128);
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        section.setText(PDEPlugin.getResourceString("ManifestEditor.PluginSpecSection.title"));
        TableWrapData td = new TableWrapData(128, 16);
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        if (this.isFragment()) {
            section.setDescription(PDEPlugin.getResourceString("ManifestEditor.PluginSpecSection.fdesc"));
        } else {
            section.setDescription(PDEPlugin.getResourceString("ManifestEditor.PluginSpecSection.desc"));
        }
        Composite client = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.marginWidth = toolkit.getBorderStyle() != 0 ? 0 : 2;
        layout.numColumns = this.isFragment() ? 2 : 3;
        client.setLayout((Layout)layout);
        section.setClient((Control)client);
        IActionBars actionBars = this.getPage().getPDEEditor().getEditorSite().getActionBars();
        this.createIDEntry(client, toolkit, actionBars);
        this.createVersionEntry(client, toolkit, actionBars);
        this.createNameEntry(client, toolkit, actionBars);
        this.createProviderEntry(client, toolkit, actionBars);
        if (this.isFragment()) {
            this.createPluginIDEntry(client, toolkit, actionBars);
            this.createPluginVersionEntry(client, toolkit, actionBars);
            this.createMatchCombo(client, toolkit, actionBars);
            if (this.isBundleMode()) {
                this.fMatchLabel.setVisible(false);
                this.fMatchCombo.getControl().setVisible(false);
            }
        } else {
            this.createClassEntry(client, toolkit, actionBars);
        }
        toolkit.paintBordersFor(client);
        IBaseModel model = this.getPage().getModel();
        if (model instanceof IModelChangeProvider) {
            ((IModelChangeProvider)model).addModelChangedListener((IModelChangedListener)this);
        }
        InputContextManager manager = this.getPage().getPDEEditor().getContextManager();
        manager.addInputContextListener(this);
    }

    public String getContextId() {
        if (this.getPluginBase() instanceof IBundlePluginBase) {
            return "bundle-context";
        }
        return "plugin-context";
    }

    private IPluginBase getPluginBase() {
        IBaseModel model = this.getPage().getPDEEditor().getAggregateModel();
        return ((IPluginModelBase)model).getPluginBase();
    }

    private void createIDEntry(Composite client, FormToolkit toolkit, IActionBars actionBars) {
        this.fIdEntry = new FormEntry(client, toolkit, PDEPlugin.getResourceString("GeneralInfoSection.id"), null, false);
        this.fIdEntry.setFormEntryListener(new FormEntryAdapter(this, actionBars){

            public void textValueChanged(FormEntry entry) {
                try {
                    GeneralInfoSection.this.getPluginBase().setId(entry.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        });
        this.fIdEntry.setEditable(this.isEditable());
    }

    private void createVersionEntry(Composite client, FormToolkit toolkit, IActionBars actionBars) {
        this.fVersionEntry = new FormEntry(client, toolkit, PDEPlugin.getResourceString("GeneralInfoSection.version"), null, false);
        this.fVersionEntry.setFormEntryListener(new FormEntryAdapter(this, actionBars){

            public void textValueChanged(FormEntry entry) {
                try {
                    GeneralInfoSection.this.getPluginBase().setVersion(entry.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        });
        this.fVersionEntry.setEditable(this.isEditable());
    }

    private void createNameEntry(Composite client, FormToolkit toolkit, IActionBars actionBars) {
        this.fNameEntry = new FormEntry(client, toolkit, PDEPlugin.getResourceString("GeneralInfoSection.name"), null, false);
        this.fNameEntry.setFormEntryListener(new FormEntryAdapter(this, actionBars){

            public void textValueChanged(FormEntry entry) {
                try {
                    GeneralInfoSection.this.getPluginBase().setName(entry.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        });
        this.fNameEntry.setEditable(this.isEditable());
    }

    private void createProviderEntry(Composite client, FormToolkit toolkit, IActionBars actionBars) {
        this.fProviderEntry = new FormEntry(client, toolkit, PDEPlugin.getResourceString("GeneralInfoSection.provider"), null, false);
        this.fProviderEntry.setFormEntryListener(new FormEntryAdapter(this, actionBars){

            public void textValueChanged(FormEntry entry) {
                try {
                    GeneralInfoSection.this.getPluginBase().setProviderName(entry.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        });
        this.fProviderEntry.setEditable(this.isEditable());
    }

    private void createClassEntry(Composite client, FormToolkit toolkit, IActionBars actionBars) {
        boolean editable = this.getPage().getModel().isEditable();
        this.fClassEntry = new FormEntry(client, toolkit, PDEPlugin.getResourceString("GeneralInfoSection.class"), PDEPlugin.getResourceString("GeneralInfoSection.browse"), editable);
        this.fClassEntry.setFormEntryListener(new FormEntryAdapter(this, actionBars){

            public void textValueChanged(FormEntry entry) {
                try {
                    ((IPlugin)GeneralInfoSection.this.getPluginBase()).setClassName(entry.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }

            public void linkActivated(HyperlinkEvent e) {
                String value = GeneralInfoSection.this.fClassEntry.getValue();
                if ((value = GeneralInfoSection.this.trimNonAlphaChars(value)).length() > 0 && GeneralInfoSection.this.doesClassExist(value)) {
                    GeneralInfoSection.this.doOpenClass();
                } else {
                    JavaAttributeValue javaAttVal = GeneralInfoSection.this.createJavaAttributeValue();
                    JavaAttributeWizard wizard = new JavaAttributeWizard(javaAttVal);
                    WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
                    dialog.create();
                    SWTUtil.setDialogSize((Dialog)dialog, 400, 500);
                    int result = dialog.open();
                    if (result == 0) {
                        String newValue = wizard.getClassNameWithArgs();
                        GeneralInfoSection.this.fClassEntry.setValue(newValue);
                    }
                }
            }

            public void browseButtonSelected(FormEntry entry) {
                GeneralInfoSection.this.doOpenSelectionDialog();
            }
        });
        this.fClassEntry.setEditable(this.isEditable());
    }

    private String trimNonAlphaChars(String value) {
        value = value.trim();
        while (value.length() > 0 && !Character.isLetter(value.charAt(0))) {
            value = value.substring(1, value.length());
        }
        int loc = value.indexOf(":");
        if (loc != -1 && loc > 0) {
            value = value.substring(0, loc);
        } else if (loc == 0) {
            value = "";
        }
        return value;
    }

    private boolean doesClassExist(String className) {
        IProject project = this.getPage().getPDEEditor().getCommonProject();
        String path = String.valueOf(className.replace('.', '/')) + ".java";
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IJavaElement result = javaProject.findElement((IPath)new Path(path));
                return result != null;
            }
            IResource resource = project.findMember((IPath)new Path(path));
            return resource != null;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private JavaAttributeValue createJavaAttributeValue() {
        IProject project = this.getPage().getPDEEditor().getCommonProject();
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        String value = this.fClassEntry.getValue();
        return new JavaAttributeValue(project, model, null, value);
    }

    private void createPluginIDEntry(Composite parent, FormToolkit toolkit, IActionBars actionBars) {
        Hyperlink link = toolkit.createHyperlink(parent, PDEPlugin.getResourceString("GeneralInfoSection.pluginId"), 0);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ManifestEditor.openPluginEditor(GeneralInfoSection.this.fPluginIdText.getText());
            }
        });
        Composite client = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = false;
        layout.numColumns = 2;
        client.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        client.setLayoutData((Object)gd);
        this.fPluginIdText = toolkit.createText(client, "", 4);
        gd = new GridData(768);
        gd.widthHint = 20;
        this.fPluginIdText.setLayoutData((Object)gd);
        this.fPluginIdText.setEditable(this.isEditable());
        this.fPluginIdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    if (!((IFragment)GeneralInfoSection.this.getPluginBase()).getPluginId().equals(GeneralInfoSection.this.fPluginIdText.getText())) {
                        ((IFragment)GeneralInfoSection.this.getPluginBase()).setPluginId(GeneralInfoSection.this.fPluginIdText.getText());
                    }
                }
                catch (CoreException e1) {
                    PDEPlugin.logException(e1);
                }
            }
        });
        Button button = toolkit.createButton(client, PDEPlugin.getResourceString("GeneralInfoSection.browse"), 8);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginSelectionDialog dialog = new PluginSelectionDialog(GeneralInfoSection.this.getSection().getShell(), false, false);
                dialog.create();
                if (dialog.open() == 0) {
                    try {
                        IPluginModel model = (IPluginModel)dialog.getFirstResult();
                        IPlugin plugin = model.getPlugin();
                        GeneralInfoSection.this.fPluginIdText.setText(plugin.getId());
                        ((IFragment)GeneralInfoSection.this.getPluginBase()).setPluginId(plugin.getId());
                        GeneralInfoSection.this.fPluginVersionEntry.setValue(plugin.getVersion(), true);
                        ((IFragment)GeneralInfoSection.this.getPluginBase()).setPluginVersion(plugin.getVersion());
                    }
                    catch (CoreException e1) {
                        PDEPlugin.logException(e1);
                    }
                }
            }
        });
        button.setEnabled(this.isEditable());
    }

    private void createPluginVersionEntry(Composite client, FormToolkit toolkit, IActionBars actionBars) {
        this.fPluginVersionEntry = new FormEntry(client, toolkit, PDEPlugin.getResourceString("GeneralInfoSection.pluginVersion"), null, false);
        this.fPluginVersionEntry.setFormEntryListener(new FormEntryAdapter(this, actionBars){

            public void textValueChanged(FormEntry entry) {
                try {
                    ((IFragment)GeneralInfoSection.this.getPluginBase()).setPluginVersion(entry.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        });
        this.fPluginVersionEntry.setEditable(this.isEditable());
    }

    private void createMatchCombo(Composite client, FormToolkit toolkit, IActionBars actionBars) {
        this.fMatchLabel = toolkit.createLabel(client, PDEPlugin.getResourceString(KEY_MATCH));
        this.fMatchLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.fMatchCombo = new ComboPart();
        this.fMatchCombo.createControl(client, toolkit, 8);
        GridData gd = new GridData(256);
        gd.widthHint = 20;
        gd.grabExcessHorizontalSpace = true;
        this.fMatchCombo.getControl().setLayoutData((Object)gd);
        String[] items = new String[]{"", PDEPlugin.getResourceString(KEY_MATCH_EQUIVALENT), PDEPlugin.getResourceString(KEY_MATCH_COMPATIBLE), PDEPlugin.getResourceString(KEY_MATCH_PERFECT), PDEPlugin.getResourceString(KEY_MATCH_GREATER)};
        this.fMatchCombo.setItems(items);
        this.fMatchCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int match = GeneralInfoSection.this.fMatchCombo.getSelectionIndex();
                try {
                    ((IFragment)GeneralInfoSection.this.getPluginBase()).setRule(match);
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        });
        this.fMatchCombo.getControl().setEnabled(this.isEditable());
    }

    public void commit(boolean onSave) {
        this.fIdEntry.commit();
        this.fNameEntry.commit();
        this.fProviderEntry.commit();
        if (this.isFragment()) {
            this.fPluginVersionEntry.commit();
        } else {
            this.fClassEntry.commit();
        }
        super.commit(onSave);
    }

    public void modelChanged(IModelChangedEvent e) {
        String property;
        Object obj;
        if (e.getChangeType() == 99) {
            this.markStale();
            return;
        }
        this.refresh();
        if (e.getChangeType() == 3 && (obj = e.getChangedObjects()[0]) instanceof IPluginBase && (property = e.getChangedProperty()) != null && property.equals(this.getPage().getPDEEditor().getTitleProperty())) {
            this.getPage().getPDEEditor().updateTitle();
        }
    }

    public void refresh() {
        IPluginModelBase model = (IPluginModelBase)this.getPage().getPDEEditor().getContextManager().getAggregateModel();
        IPluginBase pluginBase = model.getPluginBase();
        this.fIdEntry.setValue(pluginBase.getId(), true);
        this.fNameEntry.setValue(pluginBase.getName(), true);
        this.fVersionEntry.setValue(pluginBase.getVersion(), true);
        this.fProviderEntry.setValue(pluginBase.getProviderName(), true);
        if (this.isFragment()) {
            IFragment fragment = (IFragment)pluginBase;
            this.fPluginIdText.setText(fragment.getPluginId());
            this.fPluginVersionEntry.setValue(fragment.getPluginVersion(), true);
            if (!this.isBundleMode()) {
                this.fMatchCombo.select(fragment.getRule());
            }
        } else {
            IPlugin plugin = (IPlugin)pluginBase;
            this.fClassEntry.setValue(plugin.getClassName(), true);
        }
        this.getPage().getPDEEditor().updateTitle();
        super.refresh();
    }

    public void cancelEdit() {
        this.fIdEntry.cancelEdit();
        this.fNameEntry.cancelEdit();
        this.fVersionEntry.cancelEdit();
        this.fProviderEntry.cancelEdit();
        if (this.isFragment()) {
            this.fPluginVersionEntry.cancelEdit();
        } else {
            this.fClassEntry.cancelEdit();
        }
        super.cancelEdit();
    }

    public void dispose() {
        InputContextManager manager;
        IBaseModel model = this.getPage().getModel();
        if (model instanceof IModelChangeProvider) {
            ((IModelChangeProvider)model).removeModelChangedListener((IModelChangedListener)this);
        }
        if ((manager = this.getPage().getPDEEditor().getContextManager()) != null) {
            manager.removeInputContextListener(this);
        }
        super.dispose();
    }

    private void doOpenClass() {
        String name = this.fClassEntry.getText().getText();
        name = this.trimNonAlphaChars(name);
        IProject project = this.getPage().getPDEEditor().getCommonProject();
        String path = String.valueOf(name.replace('.', '/')) + ".java";
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IJavaElement result = javaProject.findElement((IPath)new Path(path));
                JavaUI.openInEditor((IJavaElement)result);
            } else {
                IResource resource = project.findMember((IPath)new Path(path));
                if (resource != null && resource instanceof IFile) {
                    IWorkbenchPage page = PDEPlugin.getActivePage();
                    IDE.openEditor((IWorkbenchPage)page, (IFile)((IFile)resource), (boolean)true);
                }
            }
        }
        catch (PartInitException e) {
            PDEPlugin.logException(e);
        }
        catch (JavaModelException javaModelException) {
            Display.getCurrent().beep();
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void doOpenSelectionDialog() {
        try {
            IProject project;
            Shell shell = PDEPlugin.getActiveWorkbenchShell();
            IResource resource = this.getPluginBase().getModel().getUnderlyingResource();
            IProject iProject = project = resource == null ? null : resource.getProject();
            if (project != null) {
                SelectionDialog dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)this.getSearchScope(project), (int)2, (boolean)false, (String)"*");
                dialog.setTitle(PDEPlugin.getResourceString("GeneralInfoSection.selectionTitle"));
                if (dialog.open() == 0) {
                    IType type = (IType)dialog.getResult()[0];
                    this.fClassEntry.setValue(type.getFullyQualifiedName());
                }
            }
        }
        catch (CoreException coreException) {}
    }

    private IJavaSearchScope getSearchScope(IProject project) {
        IJavaProject jProject = JavaCore.create((IProject)project);
        return SearchEngine.createJavaSearchScope((IJavaElement[])this.getDirectRoots(jProject));
    }

    private IPackageFragmentRoot[] getDirectRoots(IJavaProject project) {
        ArrayList<IPackageFragmentRoot> result = new ArrayList<IPackageFragmentRoot>();
        try {
            IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                if (roots[i].getKind() == 1 || roots[i].isArchive() && !roots[i].isExternal()) {
                    result.add(roots[i]);
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return result.toArray(new IPackageFragmentRoot[result.size()]);
    }

    private boolean isFragment() {
        IPluginModelBase model = (IPluginModelBase)this.getPage().getPDEEditor().getContextManager().getAggregateModel();
        return model.isFragmentModel();
    }

    public void contextAdded(InputContext context) {
        if (context.getId().equals("bundle-context")) {
            this.bundleModeChanged((IBundleModel)context.getModel(), true);
        }
    }

    public void contextRemoved(InputContext context) {
        if (context.getId().equals("bundle-context")) {
            this.bundleModeChanged((IBundleModel)context.getModel(), false);
        }
    }

    private void bundleModeChanged(IBundleModel model, boolean added) {
        if (this.fMatchCombo != null) {
            this.fMatchLabel.setVisible(!added);
            this.fMatchCombo.getControl().setVisible(!added);
        }
    }

    private boolean isBundleMode() {
        InputContextManager icm = this.getPage().getPDEEditor().getContextManager();
        return icm.findContext("bundle-context") != null;
    }

    public void monitoredFileAdded(IFile monitoredFile) {
    }

    public boolean monitoredFileRemoved(IFile monitoredFile) {
        return false;
    }

    public boolean canPaste(Clipboard clipboard) {
        Display d = this.getSection().getDisplay();
        Control c = d.getFocusControl();
        return c instanceof Text;
    }
}

