/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.feature.FeaturePlugin;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.feature.ReferenceWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.WorkbenchHelp;

public class NewFeaturePluginWizardPage
extends ReferenceWizardPage {
    public static final String KEY_TITLE = "FeatureEditor.PluginSection.new.title";
    public static final String KEY_DESC = "FeatureEditor.PluginSection.new.desc";
    public static final String KEY_ADDING = "FeatureEditor.PluginSection.new.adding";
    public static final String KEY_UPDATING = "FeatureEditor.PluginSection.new.updating";

    public NewFeaturePluginWizardPage(IFeatureModel model) {
        super(model, false);
        this.setTitle(PDEPlugin.getResourceString(KEY_TITLE));
        this.setDescription(PDEPlugin.getResourceString(KEY_DESC));
    }

    protected boolean isOnTheList(IPluginModelBase candidate) {
        IPluginBase plugin = candidate.getPluginBase();
        IFeaturePlugin[] fplugins = this.model.getFeature().getPlugins();
        int i = 0;
        while (i < fplugins.length) {
            IFeaturePlugin fplugin = fplugins[i];
            if (fplugin.getId().equals(plugin.getId())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void doAdd(Object[] candidates, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(PDEPlugin.getResourceString(KEY_ADDING), candidates.length + 1);
        IFeature feature = this.model.getFeature();
        IFeaturePlugin[] added = new IFeaturePlugin[candidates.length];
        int i = 0;
        while (i < candidates.length) {
            IPluginModelBase candidate = (IPluginModelBase)candidates[i];
            monitor.subTask(candidate.getPluginBase().getTranslatedName());
            FeaturePlugin fplugin = (FeaturePlugin)this.model.getFactory().createPlugin();
            fplugin.loadFrom(candidate.getPluginBase());
            added[i] = fplugin;
            monitor.worked(1);
            ++i;
        }
        monitor.subTask("");
        monitor.setTaskName(PDEPlugin.getResourceString(KEY_UPDATING));
        feature.addPlugins(added);
        monitor.worked(1);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.pde.doc.user.feature_add_packaged_wizard");
    }
}

