/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.editors.text.TextEditorActionContributor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.texteditor.IUpdate;

public class PDEFormEditorContributor
extends MultiPageEditorActionBarContributor {
    public static final String ACTIONS_SAVE = "EditorActions.save";
    public static final String ACTIONS_CUT = "EditorActions.cut";
    public static final String ACTIONS_COPY = "EditorActions.copy";
    public static final String ACTIONS_PASTE = "EditorActions.paste";
    public static final String ACTIONS_REVERT = "EditorActions.revert";
    private SubActionBars sourceActionBars;
    private PDEFormEditor editor;
    private IFormPage page;
    private SaveAction saveAction;
    private RevertAction revertAction;
    private ClipboardAction cutAction;
    private ClipboardAction copyAction;
    private ClipboardAction pasteAction;
    private Hashtable globalActions = new Hashtable();
    private TextEditorActionContributor sourceContributor = new TextEditorActionContributor();

    public PDEFormEditorContributor(String menuName) {
        this.makeActions();
    }

    public IEditorActionBarContributor getSourceContributor() {
        return this.sourceContributor;
    }

    private void addGlobalAction(String id) {
        GlobalAction action = new GlobalAction(id);
        this.addGlobalAction(id, action);
    }

    private void addGlobalAction(String id, Action action) {
        this.globalActions.put(id, action);
    }

    public void addClipboardActions(IMenuManager mng) {
        mng.add((IAction)this.cutAction);
        mng.add((IAction)this.copyAction);
        mng.add((IAction)this.pasteAction);
        mng.add((IContributionItem)new Separator());
        mng.add((IAction)this.revertAction);
    }

    public void contextMenuAboutToShow(IMenuManager mng) {
        this.contextMenuAboutToShow(mng, true);
    }

    public void contextMenuAboutToShow(IMenuManager mng, boolean addClipboard) {
        if (this.editor != null) {
            this.updateSelectableActions(this.editor.getSelection());
        }
        if (addClipboard) {
            this.addClipboardActions(mng);
        }
        mng.add((IAction)this.saveAction);
    }

    public void contributeToMenu(IMenuManager mm) {
    }

    public void contributeToStatusLine(IStatusLineManager slm) {
    }

    public void contributeToToolBar(IToolBarManager tbm) {
    }

    public void contributeToCoolBar(ICoolBarManager cbm) {
    }

    public void dispose() {
        this.sourceContributor.dispose();
        this.sourceActionBars.dispose();
        super.dispose();
    }

    public void init(IActionBars bars) {
        super.init(bars);
        this.sourceActionBars = new SubActionBars(bars);
        this.sourceContributor.init((IActionBars)this.sourceActionBars);
    }

    public PDEFormEditor getEditor() {
        return this.editor;
    }

    public IAction getGlobalAction(String id) {
        return (IAction)this.globalActions.get(id);
    }

    public IAction getSaveAction() {
        return this.saveAction;
    }

    public IAction getRevertAction() {
        return this.revertAction;
    }

    public IStatusLineManager getStatusLineManager() {
        return this.getActionBars().getStatusLineManager();
    }

    protected void makeActions() {
        this.cutAction = new CutAction();
        this.copyAction = new CopyAction();
        this.pasteAction = new PasteAction();
        this.addGlobalAction(ActionFactory.CUT.getId(), this.cutAction);
        this.addGlobalAction(ActionFactory.COPY.getId(), this.copyAction);
        this.addGlobalAction(ActionFactory.PASTE.getId(), this.pasteAction);
        this.addGlobalAction(ActionFactory.DELETE.getId());
        this.addGlobalAction(ActionFactory.UNDO.getId());
        this.addGlobalAction(ActionFactory.REDO.getId());
        this.addGlobalAction(ActionFactory.SELECT_ALL.getId());
        this.addGlobalAction(ActionFactory.FIND.getId());
        this.addGlobalAction(IDEActionFactory.BOOKMARK.getId());
        this.saveAction = new SaveAction();
        this.saveAction.setText(PDEPlugin.getResourceString(ACTIONS_SAVE));
        this.revertAction = new RevertAction();
        this.revertAction.setText(PDEPlugin.getResourceString(ACTIONS_REVERT));
    }

    public void setActiveEditor(IEditorPart targetEditor) {
        if (targetEditor instanceof PDESourcePage) {
            PDESourcePage page = (PDESourcePage)targetEditor;
            PDEPlugin.getActivePage().activate((IWorkbenchPart)page.getEditor());
            return;
        }
        if (!(targetEditor instanceof PDEFormEditor)) {
            return;
        }
        this.editor = (PDEFormEditor)targetEditor;
        this.editor.updateUndo(this.getGlobalAction(ActionFactory.UNDO.getId()), this.getGlobalAction(ActionFactory.REDO.getId()));
        IEditorPart page = this.editor.getActiveEditor();
        this.setActivePage(page);
        this.updateSelectableActions(this.editor.getSelection());
    }

    public void setActivePage(IEditorPart newEditor) {
        IFormPage newPage;
        if (this.editor == null) {
            return;
        }
        IFormPage oldPage = this.page;
        this.page = newPage = this.editor.getActivePageInstance();
        if (newPage == null) {
            return;
        }
        this.updateActions();
        if (oldPage != null && !oldPage.isEditor() && !newPage.isEditor()) {
            this.getActionBars().updateActionBars();
            return;
        }
        PDESourcePage sourcePage = null;
        if (newPage instanceof PDESourcePage) {
            sourcePage = (PDESourcePage)newPage;
        }
        if (sourcePage != null && ((Object)((Object)sourcePage)).equals(oldPage)) {
            return;
        }
        this.sourceContributor.setActiveEditor((IEditorPart)sourcePage);
        this.setSourceActionBarsActive(sourcePage != null);
    }

    private void setSourceActionBarsActive(boolean active) {
        IActionBars rootBars = this.getActionBars();
        rootBars.clearGlobalActionHandlers();
        rootBars.updateActionBars();
        if (active) {
            this.sourceActionBars.activate();
            Map handlers = this.sourceActionBars.getGlobalActionHandlers();
            if (handlers != null) {
                Set keys = handlers.keySet();
                Iterator iter = keys.iterator();
                while (iter.hasNext()) {
                    String id = (String)iter.next();
                    rootBars.setGlobalActionHandler(id, (IAction)handlers.get(id));
                }
            }
        } else {
            this.sourceActionBars.deactivate();
            this.registerGlobalActionHandlers();
        }
        rootBars.updateActionBars();
    }

    private void registerGlobalActionHandlers() {
        this.registerGlobalAction(ActionFactory.DELETE.getId());
        this.registerGlobalAction(ActionFactory.UNDO.getId());
        this.registerGlobalAction(ActionFactory.REDO.getId());
        this.registerGlobalAction(ActionFactory.CUT.getId());
        this.registerGlobalAction(ActionFactory.COPY.getId());
        this.registerGlobalAction(ActionFactory.PASTE.getId());
        this.registerGlobalAction(ActionFactory.SELECT_ALL.getId());
        this.registerGlobalAction(ActionFactory.FIND.getId());
        this.getActionBars().setGlobalActionHandler(ActionFactory.REVERT.getId(), (IAction)this.revertAction);
    }

    private void registerGlobalAction(String id) {
        IAction action = this.getGlobalAction(id);
        this.getActionBars().setGlobalActionHandler(id, action);
    }

    public void updateActions() {
        this.saveAction.update();
        this.revertAction.update();
    }

    public void updateSelectableActions(ISelection selection) {
        if (this.editor != null) {
            this.cutAction.selectionChanged(selection);
            this.copyAction.selectionChanged(selection);
            this.pasteAction.selectionChanged(selection);
        }
    }

    class GlobalAction
    extends Action
    implements IUpdate {
        private String id;

        public GlobalAction(String id) {
            this.id = id;
        }

        public void run() {
            PDEFormEditorContributor.this.editor.performGlobalAction(this.id);
            PDEFormEditorContributor.this.updateSelectableActions(PDEFormEditorContributor.this.editor.getSelection());
        }

        public void update() {
            PDEFormEditorContributor.this.getActionBars().updateActionBars();
        }
    }

    class ClipboardAction
    extends GlobalAction {
        public ClipboardAction(String id) {
            super(id);
            this.setEnabled(false);
        }

        public void selectionChanged(ISelection selection) {
        }

        public boolean isEditable() {
            if (PDEFormEditorContributor.this.editor == null) {
                return false;
            }
            IBaseModel model = PDEFormEditorContributor.this.editor.getAggregateModel();
            if (model instanceof IEditable) {
                return ((IEditable)model).isEditable();
            }
            return false;
        }
    }

    class CutAction
    extends ClipboardAction {
        public CutAction() {
            super(ActionFactory.CUT.getId());
            this.setText(PDEPlugin.getResourceString(PDEFormEditorContributor.ACTIONS_CUT));
        }

        public void selectionChanged(ISelection selection) {
            this.setEnabled(this.isEditable() && PDEFormEditorContributor.this.editor.canCopy(selection));
        }
    }

    class CopyAction
    extends ClipboardAction {
        public CopyAction() {
            super(ActionFactory.COPY.getId());
            this.setText(PDEPlugin.getResourceString(PDEFormEditorContributor.ACTIONS_COPY));
        }

        public void selectionChanged(ISelection selection) {
            this.setEnabled(PDEFormEditorContributor.this.editor.canCopy(selection));
        }
    }

    class PasteAction
    extends ClipboardAction {
        public PasteAction() {
            super(ActionFactory.PASTE.getId());
            this.setText(PDEPlugin.getResourceString(PDEFormEditorContributor.ACTIONS_PASTE));
        }

        public void selectionChanged(ISelection selection) {
            this.setEnabled(this.isEditable() && PDEFormEditorContributor.this.editor.canPasteFromClipboard());
        }
    }

    class SaveAction
    extends Action
    implements IUpdate {
        public void run() {
            if (PDEFormEditorContributor.this.editor != null) {
                PDEPlugin.getActivePage().saveEditor((IEditorPart)PDEFormEditorContributor.this.editor, false);
            }
        }

        public void update() {
            if (PDEFormEditorContributor.this.editor != null) {
                this.setEnabled(PDEFormEditorContributor.this.editor.isDirty());
            } else {
                this.setEnabled(false);
            }
        }
    }

    class RevertAction
    extends Action
    implements IUpdate {
        public void run() {
            if (PDEFormEditorContributor.this.editor != null) {
                PDEFormEditorContributor.this.editor.doRevert();
            }
        }

        public void update() {
            if (PDEFormEditorContributor.this.editor != null) {
                this.setEnabled(PDEFormEditorContributor.this.editor.isDirty());
            } else {
                this.setEnabled(false);
            }
        }
    }
}

