/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.variables;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILogicalStructureType;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.views.variables.SelectLogicalStructureAction;
import org.eclipse.debug.internal.ui.views.variables.VariablesView;
import org.eclipse.debug.internal.ui.views.variables.VariablesViewMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.help.WorkbenchHelp;

public class AvailableLogicalStructuresAction
extends Action
implements IMenuCreator {
    private VariablesView fView;
    private Menu fMenu;
    private IValue fValue;
    private ILogicalStructureType[] fTypes;

    public AvailableLogicalStructuresAction(VariablesView view) {
        this.setView(view);
        this.setToolTipText(VariablesViewMessages.getString("AvailableLogicalStructuresAction.0"));
        this.setText(VariablesViewMessages.getString("AvailableLogicalStructuresAction.1"));
        WorkbenchHelp.setHelp((IAction)this, (String)IDebugHelpContextIds.VARIABLES_SELECT_LOGICAL_STRUCTURE);
        this.setEnabled(false);
        this.setMenuCreator(this);
        this.init();
    }

    public void run() {
    }

    protected VariablesView getView() {
        return this.fView;
    }

    protected void setView(VariablesView view) {
        this.fView = view;
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fView = null;
        this.fValue = null;
        this.fTypes = null;
    }

    public Menu getMenu(Control parent) {
        return null;
    }

    protected void addActionToMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    public Menu getMenu(Menu parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        ILogicalStructureType[] types = this.getTypes();
        boolean exist = false;
        SelectLogicalStructureAction firstAction = null;
        String firstKey = null;
        IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
        if (types != null && types.length > 0) {
            int i = 0;
            while (i < types.length) {
                SelectLogicalStructureAction action = new SelectLogicalStructureAction(this.getView(), types, i);
                StringBuffer label = new StringBuffer();
                if (i < 9) {
                    label.append('&');
                    label.append(i + 1);
                    label.append(' ');
                }
                label.append(action.getText());
                action.setText(label.toString());
                String key = "VAR_LS_" + types[i].getId();
                if (i == 0) {
                    firstAction = action;
                    firstKey = key;
                }
                int value = store.getInt(key);
                exist = exist || value != 0;
                action.setChecked(value == 1);
                this.addActionToMenu(this.fMenu, action);
                ++i;
            }
        }
        if (!exist && firstAction != null) {
            firstAction.setChecked(true);
            store.setValue(firstKey, 1);
        }
        return this.fMenu;
    }

    public void init() {
        IStructuredSelection selection;
        ISelection s;
        this.setValue(null);
        this.setTypes(null);
        if (this.getView().isShowLogicalStructure() && (s = this.getView().getVariablesViewer().getSelection()) instanceof IStructuredSelection && (selection = (IStructuredSelection)s).size() == 1) {
            ILogicalStructureType[] types;
            Object obj = selection.getFirstElement();
            IValue value = null;
            if (obj instanceof IVariable) {
                IVariable var = (IVariable)obj;
                try {
                    value = var.getValue();
                }
                catch (DebugException debugException) {}
            } else if (obj instanceof IExpression) {
                IExpression expression = (IExpression)obj;
                value = expression.getValue();
            }
            if (value != null && (types = DebugPlugin.getLogicalStructureTypes((IValue)value)).length > 0) {
                this.setTypes(types);
                this.setValue(value);
                this.setEnabled(true);
                return;
            }
        }
        this.setEnabled(false);
    }

    protected ILogicalStructureType[] getTypes() {
        return this.fTypes;
    }

    private void setTypes(ILogicalStructureType[] types) {
        this.fTypes = types;
    }

    protected IValue getValue() {
        return this.fValue;
    }

    private void setValue(IValue value) {
        this.fValue = value;
    }
}

