/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.math.BigInteger;
import org.eclipse.debug.internal.core.memory.MemoryByte;
import org.eclipse.debug.internal.ui.views.memory.AbstractMemoryRenderer;
import org.eclipse.debug.internal.ui.views.memory.IFixedLengthOutputRenderer;

public class HexRenderer
extends AbstractMemoryRenderer
implements IFixedLengthOutputRenderer {
    public String getString(String dataType, BigInteger address, MemoryByte[] data, String paddedStr) {
        StringBuffer strBuffer = new StringBuffer();
        int i = 0;
        while (i < data.length) {
            if ((data[i].flags & 2) != 0) {
                strBuffer.append(new String(HexRenderer.convertByteToCharArray(data[i].value)));
            } else {
                strBuffer.append(paddedStr);
            }
            ++i;
        }
        return strBuffer.toString().toUpperCase();
    }

    public byte[] getBytes(String dataType, BigInteger address, MemoryByte[] currentValues, String data) {
        byte[] bytes = this.convertHexStringToByteArray(data);
        return bytes;
    }

    public int getNumCharPerByte() {
        return 2;
    }

    public static String convertByteArrayToHexString(byte[] byteArray) {
        StringBuffer strBuffer = new StringBuffer();
        int i = 0;
        while (i < byteArray.length) {
            char[] charArray = HexRenderer.convertByteToCharArray(byteArray[i]);
            strBuffer.append(charArray);
            ++i;
        }
        return strBuffer.toString();
    }

    private static char[] convertByteToCharArray(byte aByte) {
        char[] charArray = new char[2];
        int val = aByte;
        if (val < 0) {
            val += 256;
        }
        charArray[0] = Character.forDigit(val / 16, 16);
        charArray[1] = Character.forDigit(val % 16, 16);
        return charArray;
    }

    public byte[] convertHexStringToByteArray(String str) throws NumberFormatException {
        if (str.length() < this.getNumCharPerByte()) {
            return null;
        }
        byte[] bytes = new byte[str.length() / this.getNumCharPerByte()];
        int i = 0;
        while (i < bytes.length) {
            String oneByte = str.substring(i * 2, i * 2 + 2);
            Integer number = Integer.valueOf(oneByte, 16);
            if (number.compareTo(Integer.valueOf(Byte.toString((byte)127))) > 0) {
                int temp = number;
                String tempStr = Integer.toString(temp -= 256);
                Byte myByte = Byte.valueOf(tempStr);
                bytes[i] = myByte;
            } else {
                Byte myByte = Byte.valueOf(oneByte, 16);
                bytes[i] = myByte;
            }
            ++i;
        }
        return bytes;
    }
}

