/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;

public class DefaultColumnSizeDialog
extends Dialog {
    private static final String PREFIX = "DefaultColumnSizeDialog.";
    private static final String DEFAULT_COLUMN_SIZE = "DefaultColumnSizeDialog.DefaultColumnSize";
    private static final String COLUMN_SIZE = "DefaultColumnSizeDialog.ColumnSize";
    IPreferenceStore fPrefStore;
    Combo fColumnSize;
    private int[] fColumnSizes = new int[]{1, 2, 4, 8, 16};

    protected DefaultColumnSizeDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fPrefStore = DebugUIPlugin.getDefault().getPreferenceStore();
    }

    protected Control createDialogArea(Composite parent) {
        WorkbenchHelp.setHelp((Control)parent, (String)(String.valueOf(IDebugUIConstants.PLUGIN_ID) + ".DefaultColumnSizeDialog_context"));
        this.getShell().setText(DebugUIMessages.getString(DEFAULT_COLUMN_SIZE));
        Composite content = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        content.setLayout((Layout)layout);
        Label textLabel = new Label(content, 0);
        textLabel.setText(DebugUIMessages.getString(COLUMN_SIZE));
        GridData textLayout = new GridData();
        textLabel.setLayoutData((Object)textLayout);
        this.fColumnSize = new Combo(content, 2056);
        GridData columnLayout = new GridData();
        this.fColumnSize.setLayoutData((Object)columnLayout);
        int i = 0;
        while (i < this.fColumnSizes.length) {
            this.fColumnSize.add(String.valueOf(this.fColumnSizes[i]));
            ++i;
        }
        int colSize = this.fPrefStore.getInt("org.eclipse.debug.ui.memory.columnSize");
        int idx = 0;
        int i2 = 0;
        while (i2 < this.fColumnSizes.length) {
            if (this.fColumnSizes[i2] == colSize) {
                idx = i2;
                break;
            }
            ++i2;
        }
        this.fColumnSize.select(idx);
        return content;
    }

    protected void okPressed() {
        int idx = this.fColumnSize.getSelectionIndex();
        int colSize = this.fColumnSizes[idx];
        this.fPrefStore.setValue("org.eclipse.debug.ui.memory.columnSize", colSize);
        super.okPressed();
    }
}

