/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.internal.junit.util.CheckedTableSelectionDialog;
import org.eclipse.jdt.internal.junit.util.ExceptionHandler;
import org.eclipse.jdt.internal.junit.util.JUnitStatus;
import org.eclipse.jdt.internal.junit.util.JUnitStubUtility;
import org.eclipse.jdt.internal.junit.util.Resources;
import org.eclipse.jdt.internal.junit.wizards.NewTestSuiteCreationWizardPage;
import org.eclipse.jdt.internal.junit.wizards.WizardMessages;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class UpdateTestSuite
implements IObjectActionDelegate {
    private Shell fShell;
    private IPackageFragment fPack;
    private ICompilationUnit fTestSuite;
    private IMethod fSuiteMethod;
    private static boolean fEmptySelectionAllowed = false;
    private Object[] fSelectedTestCases;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        block10: {
            JavaElementLabelProvider lprovider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
            NewTestSuiteCreationWizardPage.ClassesInSuitContentProvider cprovider = new NewTestSuiteCreationWizardPage.ClassesInSuitContentProvider();
            IType testSuiteType = this.fTestSuite.findPrimaryType();
            this.fSuiteMethod = testSuiteType.getMethod("suite", new String[0]);
            if (this.fSuiteMethod.exists()) {
                try {
                    ISourceRange range = this.fSuiteMethod.getSourceRange();
                    IBuffer buf = this.fTestSuite.getBuffer();
                    String originalContent = buf.getText(range.getOffset(), range.getLength());
                    buf.close();
                    int start = originalContent.indexOf("//$JUnit-BEGIN$");
                    if (start > -1) {
                        if (originalContent.indexOf("//$JUnit-END$", start) > -1) {
                            CheckedTableSelectionDialog dialog = new CheckedTableSelectionDialog(this.fShell, (ILabelProvider)lprovider, cprovider);
                            dialog.setValidator(new UpdateAllTestsValidator());
                            dialog.setTitle(WizardMessages.getString("UpdateAllTests.title"));
                            dialog.setMessage(WizardMessages.getString("UpdateAllTests.message"));
                            dialog.setInitialSelections(cprovider.getElements(this.fPack));
                            dialog.setSize(60, 25);
                            dialog.setInput(this.fPack);
                            if (dialog.open() == 0) {
                                this.fSelectedTestCases = dialog.getResult();
                                try {
                                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile(this.getRunnable());
                                }
                                catch (Exception e) {
                                    JUnitPlugin.log(e);
                                }
                            }
                        } else {
                            this.cannotUpdateSuiteError();
                        }
                        break block10;
                    }
                    this.cannotUpdateSuiteError();
                }
                catch (JavaModelException e) {
                    JUnitPlugin.log(e);
                }
            } else {
                this.noSuiteError();
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object testSuiteObj;
        this.fShell = JUnitPlugin.getActiveWorkbenchShell();
        if (selection instanceof IStructuredSelection && (testSuiteObj = ((IStructuredSelection)selection).getFirstElement()) != null && testSuiteObj instanceof ICompilationUnit) {
            this.fTestSuite = (ICompilationUnit)testSuiteObj;
            IJavaElement packIJE = this.fTestSuite.getParent();
            if (packIJE instanceof IPackageFragment) {
                this.fPack = (IPackageFragment)packIJE;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateTestCasesInSuite(IProgressMonitor monitor) {
        block8: {
            block7: {
                try {
                    try {
                        int end;
                        monitor.beginTask(WizardMessages.getString("UpdateAllTests.beginTask"), 5);
                        if (!UpdateTestSuite.checkValidateEditStatus(this.fTestSuite, this.fShell)) {
                            Object var9_2 = null;
                            break block7;
                        }
                        ISourceRange range = this.fSuiteMethod.getSourceRange();
                        IBuffer buf = this.fTestSuite.getBuffer();
                        String originalContent = buf.getText(range.getOffset(), range.getLength());
                        StringBuffer source = new StringBuffer(originalContent);
                        int start = source.toString().indexOf("//$JUnit-BEGIN$");
                        if (start > -1 && (end = source.toString().indexOf("//$JUnit-END$", start)) > -1) {
                            monitor.worked(1);
                            source.replace(start, end += "//$JUnit-END$".length(), NewTestSuiteCreationWizardPage.getUpdatableString(this.fSelectedTestCases));
                            buf.replace(range.getOffset(), range.getLength(), source.toString());
                            monitor.worked(1);
                            this.fTestSuite.reconcile();
                            originalContent = buf.getText(0, buf.getLength());
                            monitor.worked(1);
                            String formattedContent = JUnitStubUtility.codeFormat(originalContent, 0, JUnitStubUtility.getLineDelimiterUsed((IJavaElement)this.fTestSuite));
                            buf.replace(0, buf.getLength(), formattedContent);
                            monitor.worked(1);
                            this.fTestSuite.save((IProgressMonitor)new SubProgressMonitor(monitor, 1), true);
                        }
                        break block8;
                    }
                    catch (JavaModelException e) {
                        ExceptionHandler.handle((CoreException)((Object)e), this.fShell, WizardMessages.getString("UpdateTestSuite.update"), WizardMessages.getString("UpdateTestSuite.error"));
                    }
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var9_3 = null;
                    monitor.done();
                    throw throwable;
                }
            }
            monitor.done();
            return;
        }
        Object var9_4 = null;
        monitor.done();
    }

    static boolean checkValidateEditStatus(ICompilationUnit testSuiteCu, Shell shell) {
        IStatus status = UpdateTestSuite.validateModifiesFiles(UpdateTestSuite.getTestSuiteFile(testSuiteCu));
        if (status.isOK()) {
            return true;
        }
        ErrorDialog.openError((Shell)shell, (String)WizardMessages.getString("UpdateTestSuite.update"), (String)WizardMessages.getString("UpdateTestSuite.could_not_update"), (IStatus)status);
        return false;
    }

    private static IFile getTestSuiteFile(ICompilationUnit testSuiteCu) {
        if (testSuiteCu.isWorkingCopy()) {
            return (IFile)testSuiteCu.getOriginalElement().getResource();
        }
        return (IFile)testSuiteCu.getResource();
    }

    private static IStatus validateModifiesFiles(IFile fileToModify) {
        IFile[] filesToModify = new IFile[]{fileToModify};
        IStatus status = Resources.checkInSync((IResource[])filesToModify);
        if (!status.isOK()) {
            return status;
        }
        status = Resources.makeCommittable((IResource[])filesToModify, null);
        if (!status.isOK()) {
            return status;
        }
        return new JUnitStatus();
    }

    public IRunnableWithProgress getRunnable() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                UpdateTestSuite.this.updateTestCasesInSuite(monitor);
            }
        };
    }

    private void cannotUpdateSuiteError() {
        MessageDialog.openError((Shell)this.fShell, (String)WizardMessages.getString("UpdateAllTests.cannotUpdate.errorDialog.title"), (String)WizardMessages.getFormattedString("UpdateAllTests.cannotUpdate.errorDialog.message", new String[]{"//$JUnit-BEGIN$", "//$JUnit-END$"}));
    }

    private void noSuiteError() {
        MessageDialog.openError((Shell)this.fShell, (String)WizardMessages.getString("UpdateAllTests.cannotFind.errorDialog.title"), (String)WizardMessages.getString("UpdateAllTests.cannotFind.errorDialog.message"));
    }

    private class UpdateAllTestsValidator
    implements ISelectionStatusValidator {
        UpdateAllTestsValidator() {
        }

        public IStatus validate(Object[] selection) {
            int count = 0;
            int i = 0;
            while (i < selection.length) {
                if (selection[i] instanceof IType) {
                    ++count;
                }
                ++i;
            }
            if (count == 0 && !fEmptySelectionAllowed) {
                return new JUnitStatus(4, "");
            }
            IStatus recursiveInclusionStatus = this.checkRecursiveSuiteInclusion(selection);
            if (recursiveInclusionStatus != null && !recursiveInclusionStatus.isOK()) {
                return recursiveInclusionStatus;
            }
            String message = count == 1 ? WizardMessages.getFormattedString("UpdateAllTests.selected_methods.label_one", new Integer(count)) : WizardMessages.getFormattedString("UpdateAllTests.selected_methods.label_many", new Integer(count));
            return new JUnitStatus(1, message);
        }

        private IStatus checkRecursiveSuiteInclusion(Object[] selection) {
            IType suiteClass = UpdateTestSuite.this.fSuiteMethod.getDeclaringType();
            int i = 0;
            while (i < selection.length) {
                if (selection[i] instanceof IType && ((IType)selection[i]).equals(suiteClass)) {
                    return new JUnitStatus(2, WizardMessages.getString("UpdateTestSuite.infinite_recursion"));
                }
                ++i;
            }
            return null;
        }
    }
}

