/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangeProvider;
import org.eclipse.pde.core.IModelProviderListener;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.BinaryRepositoryProvider;
import org.eclipse.pde.internal.core.ModelProviderEvent;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.bundle.BundleFragmentModel;
import org.eclipse.pde.internal.core.bundle.BundlePluginModel;
import org.eclipse.pde.internal.core.bundle.BundlePluginModelBase;
import org.eclipse.pde.internal.core.bundle.WorkspaceBundleModel;
import org.eclipse.pde.internal.core.feature.WorkspaceFeatureModel;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModel;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.plugin.WorkspaceExtensionsModel;
import org.eclipse.pde.internal.core.plugin.WorkspaceFragmentModel;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModel;
import org.eclipse.pde.internal.core.site.WorkspaceSiteBuildModel;
import org.eclipse.pde.internal.core.site.WorkspaceSiteModel;
import org.eclipse.team.core.RepositoryProvider;

public class WorkspaceModelManager
implements IResourceChangeListener,
IResourceDeltaVisitor {
    private Map fModels;
    private Map fFragmentModels;
    private List fFeatureModels;
    private ArrayList fChangedModels;
    private ArrayList fListeners = new ArrayList();
    private boolean fInitialized = false;
    private boolean fModelsLocked;

    public static boolean isPluginProject(IProject project) {
        if (project.isOpen()) {
            return WorkspaceModelManager.hasBundleManifest(project) || WorkspaceModelManager.hasPluginManifest(project) || WorkspaceModelManager.hasFragmentManifest(project);
        }
        return false;
    }

    public static boolean hasBundleManifest(IProject project) {
        return project.exists((IPath)new Path("META-INF/MANIFEST.MF"));
    }

    public static boolean hasPluginManifest(IProject project) {
        return project.exists((IPath)new Path("plugin.xml"));
    }

    public static boolean hasFragmentManifest(IProject project) {
        return project.exists((IPath)new Path("fragment.xml"));
    }

    public static boolean hasFeatureManifest(IProject project) {
        return project.exists((IPath)new Path("feature.xml"));
    }

    public static boolean isFeatureProject(IProject project) {
        if (project.isOpen()) {
            return project.exists((IPath)new Path("feature.xml"));
        }
        return false;
    }

    public static boolean isBinaryPluginProject(IProject project) {
        if (WorkspaceModelManager.isPluginProject(project)) {
            try {
                String binary = project.getPersistentProperty(PDECore.EXTERNAL_PROJECT_PROPERTY);
                if (binary != null) {
                    RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project);
                    return provider == null || provider instanceof BinaryRepositoryProvider;
                }
            }
            catch (CoreException e) {
                PDECore.logException(e);
            }
        }
        return false;
    }

    public static boolean isJavaPluginProject(IProject project) {
        if (WorkspaceModelManager.isPluginProject(project)) {
            try {
                if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                    return true;
                }
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    public static boolean isUnsharedPluginProject(IProject project) {
        return RepositoryProvider.getProvider((IProject)project) == null || WorkspaceModelManager.isBinaryPluginProject(project);
    }

    public boolean getAllEditableModelsUnused(Class modelClass) {
        return true;
    }

    private IModel getWorkspaceModel(IProject project) {
        this.initializeWorkspaceModels();
        if (WorkspaceModelManager.hasFeatureManifest(project)) {
            return this.getWorkspaceModel(project, this.fFeatureModels);
        }
        if (WorkspaceModelManager.hasBundleManifest(project)) {
            IModel model = (IModel)this.fModels.get(project);
            return model != null ? model : (IModel)this.fFragmentModels.get(project);
        }
        if (WorkspaceModelManager.hasPluginManifest(project)) {
            return (IModel)this.fModels.get(project);
        }
        if (WorkspaceModelManager.hasFragmentManifest(project)) {
            return (IModel)this.fFragmentModels.get(project);
        }
        return null;
    }

    public IPluginModelBase getWorkspacePluginModel(IProject project) {
        IModel model = this.getWorkspaceModel(project);
        return model instanceof IPluginModelBase ? (IPluginModelBase)model : null;
    }

    public IFeatureModel getFeatureModel(IProject project) {
        IModel model = this.getWorkspaceModel(project);
        return model instanceof IFeatureModel ? (IFeatureModel)model : null;
    }

    private void handleFileDelta(IResourceDelta delta) {
        IFile file = (IFile)delta.getResource();
        if (file.getName().equals(".options")) {
            PDECore.getDefault().getTracingOptionsManager().reset();
            return;
        }
        if (file.getName().equals("build.properties") && WorkspaceModelManager.isPluginProject(file.getProject())) {
            this.fireModelsChanged(new IModel[]{this.getWorkspaceModel(file.getProject())});
            return;
        }
        if (!this.isSupportedFile(file)) {
            return;
        }
        int kind = delta.getKind();
        switch (kind) {
            case 1: {
                this.handleFileAdded(file);
                break;
            }
            case 2: {
                this.handleFileRemoved(file);
                break;
            }
            case 4: {
                this.handleFileChanged(file, delta);
            }
        }
    }

    private void handleFileAdded(IFile file) {
        IModel model = this.getWorkspaceModel(file);
        if (model != null) {
            this.removeWorkspaceModel(file.getProject());
        }
        this.addWorkspaceModel(file.getProject(), true);
    }

    private void handleFileRemoved(IFile file) {
        IModel model = this.getWorkspaceModel(file);
        String fileName = file.getName().toLowerCase();
        if (model != null) {
            if (model instanceof IBundlePluginModelBase) {
                IBundlePluginModelBase bModel = (IBundlePluginModelBase)model;
                if (fileName.equals("plugin.xml") || fileName.equals("fragment.xml")) {
                    bModel.setExtensionsModel(null);
                } else {
                    this.removeWorkspaceModel(file.getProject());
                    if (bModel.getExtensionsModel() != null) {
                        this.switchToPluginMode(bModel);
                    }
                }
            } else {
                this.removeWorkspaceModel(file.getProject());
            }
        }
    }

    private void switchToPluginMode(IBundlePluginModelBase bModel) {
        IPluginModelBase model = null;
        IProject project = bModel.getUnderlyingResource().getProject();
        model = bModel instanceof IBundlePluginModel ? this.createWorkspacePluginModel(project.getFile("plugin.xml")) : this.createWorkspaceFragmentModel(project.getFile("fragment.xml"));
        if (model != null && model.getPluginBase().getId() != null) {
            if (model instanceof IPluginModel) {
                this.fModels.put(project, model);
            } else {
                this.fFragmentModels.put(project, model);
            }
            if (this.fChangedModels == null) {
                this.fChangedModels = new ArrayList();
            }
            this.fChangedModels.add(new ModelChange(model, true));
        }
    }

    private void handleFileChanged(IFile file, IResourceDelta delta) {
        IModel model = this.getWorkspaceModel(file);
        if (model == null) {
            this.handleFileAdded(file);
            return;
        }
        if ((0x100 & delta.getFlags()) != 0) {
            if (model instanceof IBundlePluginModelBase) {
                if (this.isBundleManifestFile(file)) {
                    this.loadModel(((IBundlePluginModelBase)model).getBundleModel(), true);
                } else {
                    this.loadModel(((IBundlePluginModelBase)model).getExtensionsModel(), true);
                }
            } else {
                this.loadModel(model, true);
            }
            if (model instanceof IPluginModelBase) {
                String id = ((IPluginModelBase)model).getPluginBase().getId();
                if (id == null || id.length() == 0) {
                    return;
                }
                this.addWorkspaceModel(file.getProject(), true);
            }
            this.fireModelsChanged(new IModel[]{model});
        }
    }

    public void fireModelsChanged(IModel[] models) {
        ModelProviderEvent event = new ModelProviderEvent(this, 4, null, null, models);
        this.fireModelProviderEvent(event);
    }

    private boolean isSupportedFile(IFile file) {
        if (this.isBundleManifestFile(file)) {
            return true;
        }
        String name = file.getName().toLowerCase();
        if (!(name.equals("plugin.xml") || name.equals("fragment.xml") || name.equals("feature.xml"))) {
            return false;
        }
        IPath expectedPath = file.getProject().getFullPath().append(name);
        return expectedPath.equals((Object)file.getFullPath());
    }

    private boolean isBundleManifestFile(IFile file) {
        IPath path = file.getProjectRelativePath();
        return path.segmentCount() == 2 && path.segment(0).equals("META-INF") && path.segment(1).equals("MANIFEST.MF");
    }

    private IModel getWorkspaceModel(IFile file) {
        IProject project = file.getProject();
        if (this.isBundleManifestFile(file)) {
            IModel model = (IModel)this.fModels.get(project);
            return model != null ? model : (IModel)this.fFragmentModels.get(project);
        }
        IPath path = file.getProjectRelativePath();
        if (path.equals((Object)new Path("plugin.xml"))) {
            return (IModel)this.fModels.get(project);
        }
        if (path.equals((Object)new Path("fragment.xml"))) {
            return (IModel)this.fFragmentModels.get(project);
        }
        if (path.equals((Object)new Path("feature.xml"))) {
            return this.getWorkspaceModel(file.getProject(), this.fFeatureModels);
        }
        return null;
    }

    private IModel getWorkspaceModel(IProject project, List models) {
        int i = 0;
        while (i < models.size()) {
            IModel model = (IModel)models.get(i);
            IFile file = (IFile)model.getUnderlyingResource();
            if (file.getProject().equals((Object)project)) {
                return model;
            }
            ++i;
        }
        return null;
    }

    public IPluginModelBase[] getAllModels() {
        this.initializeWorkspaceModels();
        ArrayList result = new ArrayList();
        Iterator iter = this.fModels.values().iterator();
        while (iter.hasNext()) {
            result.add(iter.next());
        }
        iter = this.fFragmentModels.values().iterator();
        while (iter.hasNext()) {
            result.add(iter.next());
        }
        return result.toArray(new IPluginModelBase[result.size()]);
    }

    public void removeModelProviderListener(IModelProviderListener listener) {
        this.fListeners.remove(listener);
    }

    public void addModelProviderListener(IModelProviderListener listener) {
        this.fListeners.add(listener);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        switch (event.getType()) {
            case 1: {
                this.handleResourceDelta(event.getDelta());
                this.processModelChanges();
                break;
            }
            case 2: {
                IProject project = (IProject)event.getResource();
                this.removeWorkspaceModel(project);
                this.processModelChanges();
            }
        }
    }

    private void removeWorkspaceModel(IProject project) {
        IModel model = null;
        if (this.fModels.containsKey(project)) {
            model = (IModel)this.fModels.remove(project);
        } else if (this.fFragmentModels.containsKey(project)) {
            model = (IModel)this.fFragmentModels.remove(project);
        } else {
            model = this.getWorkspaceModel(project, this.fFeatureModels);
            if (model != null) {
                this.fFeatureModels.remove(model);
            }
        }
        if (model != null) {
            if (model instanceof IPluginModelBase) {
                PDECore.getDefault().getTracingOptionsManager().reset();
            }
            if (this.fChangedModels == null) {
                this.fChangedModels = new ArrayList();
            }
            this.fChangedModels.add(new ModelChange(model, false));
        }
    }

    private void handleResourceDelta(IResourceDelta delta) {
        try {
            delta.accept((IResourceDeltaVisitor)this);
        }
        catch (CoreException e) {
            PDECore.logException(e);
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        if (delta != null) {
            IResource resource = delta.getResource();
            if (resource instanceof IProject) {
                IProject project = (IProject)resource;
                if (delta.getKind() == 1 || project.isOpen() && (delta.getFlags() & 0x4000) != 0) {
                    this.addWorkspaceModel(project, true);
                    return false;
                }
                if (delta.getKind() == 2) {
                    this.removeWorkspaceModel(project);
                    return false;
                }
                return true;
            }
            if (resource instanceof IFile) {
                this.handleFileDelta(delta);
            } else if (resource instanceof IFolder) {
                return resource.getName().equals("META-INF");
            }
        }
        return true;
    }

    private synchronized void initializeWorkspaceModels() {
        IProject project;
        if (this.fInitialized || this.fModelsLocked) {
            return;
        }
        this.fModelsLocked = true;
        this.fModels = Collections.synchronizedMap(new HashMap());
        this.fFragmentModels = Collections.synchronizedMap(new HashMap());
        this.fFeatureModels = Collections.synchronizedList(new ArrayList());
        IWorkspace workspace = PDECore.getWorkspace();
        IProject[] projects = workspace.getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            project = projects[i];
            if (WorkspaceModelManager.isPluginProject(project)) {
                this.addWorkspaceModel(project, false);
            }
            ++i;
        }
        i = 0;
        while (i < projects.length) {
            project = projects[i];
            if (WorkspaceModelManager.isFeatureProject(project)) {
                this.addWorkspaceModel(project, false);
            }
            ++i;
        }
        workspace.addResourceChangeListener((IResourceChangeListener)this, 2);
        JavaCore.addPreProcessingResourceChangedListener((IResourceChangeListener)this);
        this.fModelsLocked = false;
        this.fInitialized = true;
    }

    private IFeatureModel createFeatureModel(IFile file) {
        if (!file.exists()) {
            return null;
        }
        WorkspaceFeatureModel model = new WorkspaceFeatureModel(file);
        this.loadModel(model, false);
        return model;
    }

    private IPluginModelBase createPluginModel(IProject project) {
        if (WorkspaceModelManager.hasBundleManifest(project)) {
            return this.createWorkspaceBundleModel(project.getFile("META-INF/MANIFEST.MF"));
        }
        if (WorkspaceModelManager.hasPluginManifest(project)) {
            return this.createWorkspacePluginModel(project.getFile("plugin.xml"));
        }
        return this.createWorkspaceFragmentModel(project.getFile("fragment.xml"));
    }

    private IPluginModelBase createWorkspacePluginModel(IFile file) {
        if (!file.exists()) {
            return null;
        }
        WorkspacePluginModel model = new WorkspacePluginModel(file);
        this.loadModel(model, false);
        return model;
    }

    private IPluginModelBase createWorkspaceFragmentModel(IFile file) {
        if (!file.exists()) {
            return null;
        }
        WorkspaceFragmentModel model = new WorkspaceFragmentModel(file);
        this.loadModel(model, false);
        return model;
    }

    private IPluginModelBase createWorkspaceBundleModel(IFile file) {
        if (!file.exists()) {
            return null;
        }
        PDEState state = PDECore.getDefault().getExternalModelManager().getState();
        BundleDescription desc = state.addBundle(new File(file.getLocation().removeLastSegments(2).toString()));
        if (desc == null) {
            return null;
        }
        if (desc.getSymbolicName() == null || desc.getSymbolicName().length() == 0) {
            return null;
        }
        WorkspaceBundleModel model = new WorkspaceBundleModel(file);
        this.loadModel(model, false);
        BundlePluginModelBase bmodel = null;
        boolean fragment = model.isFragmentModel();
        bmodel = fragment ? new BundleFragmentModel() : new BundlePluginModel();
        bmodel.setEnabled(true);
        bmodel.setBundleModel(model);
        bmodel.setBundleDescription(desc);
        IFile efile = file.getProject().getFile(fragment ? "fragment.xml" : "plugin.xml");
        if (efile.exists()) {
            WorkspaceExtensionsModel extModel = new WorkspaceExtensionsModel(efile);
            this.loadModel(extModel, false);
            bmodel.setExtensionsModel(extModel);
            extModel.setBundleModel(bmodel);
        }
        return bmodel;
    }

    private void loadModel(IModel model, boolean reload) {
        IFile file = (IFile)model.getUnderlyingResource();
        InputStream stream = null;
        boolean outOfSync = false;
        try {
            stream = file.getContents(false);
        }
        catch (CoreException e) {
            outOfSync = true;
            try {
                stream = file.getContents(true);
            }
            catch (CoreException coreException) {
                PDECore.logException(e);
                return;
            }
        }
        try {
            if (reload) {
                model.reload(stream, outOfSync);
            } else {
                model.load(stream, outOfSync);
            }
            stream.close();
        }
        catch (Exception e) {
            PDECore.logException(e);
        }
    }

    private void addWorkspaceModel(IProject project, boolean notify) {
        IModelChangeProvider model = null;
        if (WorkspaceModelManager.isPluginProject(project)) {
            model = this.createPluginModel(project);
            if (model != null) {
                if (model instanceof IFragmentModel) {
                    this.fFragmentModels.put(project, model);
                } else {
                    this.fModels.put(project, model);
                }
                if (notify) {
                    if (this.fChangedModels == null) {
                        this.fChangedModels = new ArrayList();
                    }
                    this.fChangedModels.add(new ModelChange((IModel)((Object)model), true));
                }
                if (project.getFile(".options").exists()) {
                    PDECore.getDefault().getTracingOptionsManager().reset();
                }
            }
        } else if (WorkspaceModelManager.isFeatureProject(project) && (model = this.createFeatureModel(project.getFile("feature.xml"))) != null) {
            this.fFeatureModels.add(model);
        }
    }

    public IPluginModel[] getPluginModels() {
        this.initializeWorkspaceModels();
        return this.fModels.values().toArray(new IPluginModel[this.fModels.size()]);
    }

    public IFragmentModel[] getFragmentModels() {
        this.initializeWorkspaceModels();
        return this.fFragmentModels.values().toArray(new IFragmentModel[this.fFragmentModels.size()]);
    }

    public IFeatureModel[] getFeatureModels() {
        this.initializeWorkspaceModels();
        return this.fFeatureModels.toArray(new IFeatureModel[this.fFeatureModels.size()]);
    }

    public IFragment[] getFragmentsFor(String pluginId, String version) {
        this.initializeWorkspaceModels();
        ArrayList<IFragment> result = new ArrayList<IFragment>();
        Iterator iter = this.fFragmentModels.values().iterator();
        while (iter.hasNext()) {
            IFragment fragment = ((IFragmentModel)iter.next()).getFragment();
            if (!PDECore.compare(fragment.getPluginId(), fragment.getPluginVersion(), pluginId, version, fragment.getRule())) continue;
            result.add(fragment);
        }
        return result.toArray(new IFragment[result.size()]);
    }

    public void shutdown() {
        PDECore.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        JavaCore.removePreProcessingResourceChangedListener((IResourceChangeListener)this);
    }

    public IModel getModel(IFile file) {
        String name = file.getName().toLowerCase();
        IProject project = file.getProject();
        if (WorkspaceModelManager.isPluginProject(project) && WorkspaceModelManager.hasBundleManifest(project) && file.getProjectRelativePath().equals((Object)new Path("META-INF/MANIFEST.MF"))) {
            return new WorkspaceBundleModel(file);
        }
        if (name.equals("plugin.xml")) {
            return new WorkspacePluginModel(file);
        }
        if (name.equals("fragment.xml")) {
            return new WorkspaceFragmentModel(file);
        }
        if (name.equals("build.properties")) {
            return new WorkspaceBuildModel(file);
        }
        if (name.equals("feature.xml")) {
            return new WorkspaceFeatureModel(file);
        }
        if (name.equals("site.xml")) {
            return new WorkspaceSiteModel(file);
        }
        if (name.equals("sitebuild.xml")) {
            return new WorkspaceSiteBuildModel(file);
        }
        return null;
    }

    private void processModelChanges() {
        if (this.fChangedModels == null) {
            return;
        }
        if (this.fChangedModels.size() == 0) {
            this.fChangedModels = null;
            return;
        }
        Vector<IModel> added = new Vector<IModel>();
        Vector<IModel> removed = new Vector<IModel>();
        Vector<IModel> changed = new Vector<IModel>();
        int i = 0;
        while (i < this.fChangedModels.size()) {
            ModelChange change = (ModelChange)this.fChangedModels.get(i);
            switch (change.type) {
                case 1: {
                    added.add(change.model);
                    break;
                }
                case 2: {
                    removed.add(change.model);
                    break;
                }
                case 4: {
                    changed.add(change.model);
                }
            }
            ++i;
        }
        IModel[] addedArray = added.size() > 0 ? added.toArray(new IModel[added.size()]) : null;
        IModel[] removedArray = removed.size() > 0 ? removed.toArray(new IModel[removed.size()]) : null;
        IModel[] changedArray = changed.size() > 0 ? changed.toArray(new IModel[changed.size()]) : null;
        int type = 0;
        if (addedArray != null) {
            type |= 1;
        }
        if (removedArray != null) {
            type |= 2;
        }
        if (changedArray != null) {
            type |= 4;
        }
        this.fChangedModels = null;
        if (type != 0) {
            ModelProviderEvent event = new ModelProviderEvent(this, type, addedArray, removedArray, changedArray);
            this.fireModelProviderEvent(event);
        }
    }

    private void fireModelProviderEvent(ModelProviderEvent event) {
        Iterator iter = this.fListeners.iterator();
        while (iter.hasNext()) {
            ((IModelProviderListener)iter.next()).modelsChanged(event);
        }
    }

    class ModelChange {
        IModel model;
        int type;

        public ModelChange(IModel model, boolean added) {
            this.model = model;
            this.type = added ? 1 : 2;
        }

        public ModelChange(IModel model) {
            this.model = model;
            this.type = 4;
        }
    }
}

