/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelProviderEvent;
import org.eclipse.pde.core.IModelProviderListener;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.IFileAdapterFactory;
import org.eclipse.pde.internal.core.IPluginModelListener;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.PluginModelDelta;
import org.eclipse.pde.internal.core.RequiredPluginsClasspathContainer;
import org.eclipse.pde.internal.core.SearchablePluginsManager;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;

public class PluginModelManager
implements IAdaptable {
    private static final String OSGI_RUNTIME = "org.eclipse.osgi";
    private IModelProviderListener providerListener = new IModelProviderListener(){

        public void modelsChanged(IModelProviderEvent e) {
            PluginModelManager.this.handleModelsChanged(e);
        }
    };
    private ExternalModelManager externalManager;
    private WorkspaceModelManager workspaceManager;
    private SearchablePluginsManager searchablePluginsManager;
    private ArrayList listeners = new ArrayList();
    private Map fEntries;

    public PluginModelManager() {
        this.searchablePluginsManager = new SearchablePluginsManager(this);
    }

    public boolean isOSGiRuntime() {
        try {
            ModelEntry entry = this.findEntry("org.eclipse.platform");
            if (entry != null) {
                IPluginModelBase model = entry.getActiveModel();
                IResource resource = model.getUnderlyingResource();
                int version = new PluginVersionIdentifier(model.getPluginBase().getVersion()).getMajorComponent();
                if (resource != null && version < 3) {
                    IProject project = resource.getProject();
                    if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                        IJavaProject jProject = JavaCore.create((IProject)project);
                        IPackageFragmentRoot[] roots = jProject.getPackageFragmentRoots();
                        int i = 0;
                        while (i < roots.length) {
                            if (roots[i].getKind() == 1) {
                                return false;
                            }
                            ++i;
                        }
                    }
                    if (project.getFile("startup.jar").exists()) {
                        return false;
                    }
                }
            }
        }
        catch (Exception exception) {}
        return this.findEntry(OSGI_RUNTIME) != null;
    }

    public Object getAdapter(Class key) {
        return null;
    }

    public void addPluginModelListener(IPluginModelListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removePluginModelListener(IPluginModelListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public boolean isEmpty() {
        return this.getEntryTable().isEmpty();
    }

    public ModelEntry[] getEntries() {
        Collection values = this.getEntryTable().values();
        return values.toArray(new ModelEntry[values.size()]);
    }

    public IPluginModelBase[] getPlugins() {
        Collection values = this.getEntryTable().values();
        ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>();
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            ModelEntry entry = (ModelEntry)((Object)iter.next());
            IPluginModelBase model = entry.getActiveModel();
            if (!model.isEnabled()) continue;
            result.add(model);
        }
        return result.toArray(new IPluginModelBase[result.size()]);
    }

    public IPluginModel[] getPluginsOnly() {
        Collection values = this.getEntryTable().values();
        ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>();
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            ModelEntry entry = (ModelEntry)((Object)iter.next());
            IPluginModelBase model = entry.getActiveModel();
            if (!model.isEnabled() || !(model instanceof IPluginModel)) continue;
            result.add(model);
        }
        return result.toArray(new IPluginModel[result.size()]);
    }

    public IFragmentModel[] getFragments() {
        Collection values = this.getEntryTable().values();
        ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>();
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            ModelEntry entry = (ModelEntry)((Object)iter.next());
            IPluginModelBase model = entry.getActiveModel();
            if (!(model instanceof IFragmentModel)) continue;
            result.add(model);
        }
        return result.toArray(new IFragmentModel[result.size()]);
    }

    public ModelEntry findEntry(IProject project) {
        Map map = this.getEntryTable();
        IPluginModelBase model = this.workspaceManager.getWorkspacePluginModel(project);
        if (model == null) {
            return null;
        }
        String id = model.getPluginBase().getId();
        if (id == null || id.length() == 0) {
            return null;
        }
        return (ModelEntry)((Object)map.get(id));
    }

    public IPluginModelBase findModel(IProject project) {
        ModelEntry entry = this.findEntry(project);
        return entry != null ? entry.getActiveModel() : null;
    }

    public ModelEntry findEntry(String id) {
        if (id == null) {
            return null;
        }
        return (ModelEntry)((Object)this.getEntryTable().get(id));
    }

    public IPluginModelBase findModel(String id) {
        ModelEntry entry = this.findEntry(id);
        return entry == null ? null : entry.getActiveModel();
    }

    public IPluginModelBase findPlugin(String id, String version, int match) {
        return this.findModel(id);
    }

    public IPluginModel findPluginModel(String id) {
        IPluginModelBase model = this.findModel(id);
        return model != null && model instanceof IPluginModel ? (IPluginModel)model : null;
    }

    public IFragmentModel findFragmentModel(String id) {
        IPluginModelBase model = this.findModel(id);
        return model != null && model instanceof IFragmentModel ? (IFragmentModel)model : null;
    }

    private void handleModelsChanged(IModelProviderEvent e) {
        ModelEntry entry;
        IPluginBase plugin;
        IPluginModelBase model;
        int i;
        PluginModelDelta delta = new PluginModelDelta();
        ArrayList<IPluginBase> changedPlugins = new ArrayList<IPluginBase>();
        ArrayList<String> oldIds = new ArrayList<String>();
        boolean javaSearchAffected = false;
        if ((e.getEventTypes() & 2) != 0) {
            IModel[] removed = e.getRemovedModels();
            i = 0;
            while (i < removed.length) {
                if (removed[i] instanceof IPluginModelBase) {
                    model = (IPluginModelBase)removed[i];
                    plugin = model.getPluginBase();
                    entry = this.updateTable(plugin.getId(), model, false, delta);
                    if (entry != null && (model.getUnderlyingResource() != null || entry.isInJavaSearch())) {
                        javaSearchAffected = true;
                    }
                    changedPlugins.add(plugin);
                }
                ++i;
            }
        }
        if ((e.getEventTypes() & 1) != 0) {
            IModel[] added = e.getAddedModels();
            i = 0;
            while (i < added.length) {
                if (added[i] instanceof IPluginModelBase) {
                    model = (IPluginModelBase)added[i];
                    plugin = model.getPluginBase();
                    entry = this.updateTable(plugin.getId(), model, true, delta);
                    if (entry != null && (model.getUnderlyingResource() != null || entry.isInJavaSearch())) {
                        javaSearchAffected = true;
                    }
                    changedPlugins.add(plugin);
                }
                ++i;
            }
        }
        if ((e.getEventTypes() & 4) != 0) {
            IModel[] changed = e.getChangedModels();
            i = 0;
            while (i < changed.length) {
                if (changed[i] instanceof IPluginModelBase) {
                    model = (IPluginModelBase)changed[i];
                    boolean workspace = model.getUnderlyingResource() != null;
                    this.updateBundleDescription(model);
                    IPluginBase plugin2 = model.getPluginBase();
                    String id = plugin2.getId();
                    if (id != null) {
                        ModelEntry entry2 = (ModelEntry)((Object)this.getEntryTable().get(plugin2.getId()));
                        String oldId = null;
                        if (entry2 != null) {
                            if (workspace && model != entry2.getWorkspaceModel()) {
                                if (this.isBundlePluginSwap(model, entry2)) {
                                    if (entry2.isInJavaSearch()) {
                                        javaSearchAffected = true;
                                    }
                                    delta.addEntry(entry2, 4);
                                } else {
                                    oldId = this.handleIdChange(id, model, entry2, delta);
                                }
                            } else {
                                if (workspace || entry2.isInJavaSearch()) {
                                    javaSearchAffected = true;
                                }
                                delta.addEntry(entry2, 4);
                            }
                            changedPlugins.add(plugin2);
                        } else if (workspace) {
                            oldId = this.handleIdChange(id, model, null, delta);
                            changedPlugins.add(plugin2);
                        }
                        if (oldId != null) {
                            oldIds.add(oldId);
                        }
                    }
                }
                ++i;
            }
        }
        this.updateAffectedEntries(changedPlugins.toArray(new IPluginBase[changedPlugins.size()]), oldIds);
        if (javaSearchAffected) {
            this.searchablePluginsManager.updateClasspathContainer();
        }
        this.fireDelta(delta);
    }

    private boolean isBundlePluginSwap(IPluginModelBase model, ModelEntry entry) {
        IPluginModelBase workspaceModel = entry.getWorkspaceModel();
        if (workspaceModel == null) {
            return false;
        }
        boolean swap = false;
        if (model instanceof IBundlePluginModelBase && !(workspaceModel instanceof IBundlePluginModelBase)) {
            swap = true;
        } else if (!(model instanceof IBundlePluginModelBase) && workspaceModel instanceof IBundlePluginModelBase) {
            swap = true;
        }
        if (swap) {
            entry.setWorkspaceModel(model);
        }
        return swap;
    }

    private ModelEntry findOldEntry(IPluginModelBase model) {
        Collection values = this.getEntryTable().values();
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            ModelEntry entry = (ModelEntry)((Object)iter.next());
            IPluginModelBase candidate = entry.getWorkspaceModel();
            if (model != candidate) continue;
            return entry;
        }
        return null;
    }

    private String handleIdChange(String newId, IPluginModelBase model, ModelEntry newEntry, PluginModelDelta delta) {
        ModelEntry oldEntry = this.findOldEntry(model);
        String oldId = null;
        if (oldEntry != null) {
            oldEntry.setWorkspaceModel(null);
            if (oldEntry.isEmpty()) {
                this.getEntryTable().remove(oldEntry.getId());
                delta.addEntry(oldEntry, 2);
            } else {
                delta.addEntry(oldEntry, 4);
            }
            oldId = oldEntry.getId();
        }
        if (newEntry != null) {
            newEntry.setWorkspaceModel(model);
            delta.addEntry(newEntry, 4);
        } else {
            newEntry = new ModelEntry(this, newId);
            this.getEntryTable().put(newId, newEntry);
            delta.addEntry(newEntry, 1);
        }
        return oldId;
    }

    private ModelEntry updateTable(String id, IPluginModelBase model, boolean added, PluginModelDelta delta) {
        boolean workspace;
        boolean bl = workspace = model.getUnderlyingResource() != null;
        if (id == null) {
            return null;
        }
        Map entries = this.getEntryTable();
        ModelEntry entry = (ModelEntry)((Object)entries.get(id));
        int kind = 0;
        if (added && entry == null) {
            entry = new ModelEntry(this, id);
            entries.put(id, entry);
            kind = 1;
            try {
                entry.updateClasspathContainer(false, true);
            }
            catch (CoreException coreException) {}
        }
        if (added) {
            if (workspace) {
                entry.setWorkspaceModel(model);
            } else {
                entry.setExternalModel(model);
            }
        } else if (entry != null) {
            if (workspace) {
                entry.setWorkspaceModel(null);
            } else {
                entry.setExternalModel(null);
            }
            if (entry.isEmpty()) {
                entries.remove(id);
                kind = 2;
            }
        }
        if (workspace) {
            PDEState state = this.externalManager.getState();
            if (added) {
                this.addWorkspaceBundleToState(model, state);
            } else {
                this.removeWorkspaceBundleFromState(model, state);
            }
            state.resolveState(true);
        }
        if (kind == 0) {
            kind = 4;
        }
        delta.addEntry(entry, kind);
        return entry;
    }

    private void updateAffectedEntries(IPluginBase[] changedPlugins, ArrayList oldIds) {
        ModelEntry[] entries = this.getEntries();
        HashMap<IJavaProject, RequiredPluginsClasspathContainer> map = new HashMap<IJavaProject, RequiredPluginsClasspathContainer>();
        int i = 0;
        while (i < entries.length) {
            ModelEntry entry = entries[i];
            if (entry.isAffected(changedPlugins, oldIds)) {
                try {
                    if (entry.shouldUpdateClasspathContainer(true, true)) {
                        IProject proj = entry.getWorkspaceModel().getUnderlyingResource().getProject();
                        entry.getClasspathContainer().reset();
                        map.put(JavaCore.create((IProject)proj), entry.getClasspathContainer());
                    }
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
        if (map.size() > 0) {
            try {
                IJavaProject[] jProjects = map.keySet().toArray(new IJavaProject[map.size()]);
                IClasspathContainer[] containers = map.values().toArray(new IClasspathContainer[map.size()]);
                JavaCore.setClasspathContainer((IPath)new Path("org.eclipse.pde.core.requiredPlugins"), (IJavaProject[])jProjects, (IClasspathContainer[])containers, null);
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    private synchronized void initializeTable() {
        if (this.fEntries != null) {
            return;
        }
        this.fEntries = Collections.synchronizedMap(new TreeMap());
        IPluginModelBase[] models = this.externalManager.getAllModels();
        this.addToTable(models, false);
        models = this.workspaceManager.getAllModels();
        this.addToTable(models, true);
        this.addWorkspaceBundlesToState();
        this.searchablePluginsManager.initialize();
    }

    private Map getEntryTable() {
        this.initializeTable();
        return this.fEntries;
    }

    public void addWorkspaceBundlesToState() {
        IPluginModelBase[] models = this.workspaceManager.getAllModels();
        PDEState state = this.externalManager.getState();
        int i = 0;
        while (i < models.length) {
            this.addWorkspaceBundleToState(models[i], state);
            ++i;
        }
        state.resolveState(true);
    }

    private void addWorkspaceBundleToState(IPluginModelBase model, PDEState state) {
        if (!(model instanceof IBundlePluginModelBase)) {
            return;
        }
        String id = model.getPluginBase().getId();
        if (id == null) {
            return;
        }
        ModelEntry entry = this.findEntry(id);
        if (entry == null) {
            return;
        }
        IPluginModelBase external = entry.getExternalModel();
        if (external != null) {
            BundleDescription desc = external.getBundleDescription();
            state.removeBundleDescription(desc);
        }
        if (model.getBundleDescription() != null) {
            state.removeBundleDescription(model.getBundleDescription());
        }
        IResource file = model.getUnderlyingResource();
        model.setBundleDescription(state.addBundle(new File(file.getLocation().removeLastSegments(2).toString())));
    }

    private void removeWorkspaceBundleFromState(IPluginModelBase model, PDEState state) {
        BundleDescription description = model.getBundleDescription();
        if (description == null) {
            return;
        }
        state.removeBundleDescription(description);
        String id = model.getPluginBase().getId();
        if (id == null) {
            return;
        }
        ModelEntry entry = this.findEntry(id);
        if (entry == null) {
            return;
        }
        IPluginModelBase external = entry.getExternalModel();
        if (external != null) {
            BundleDescription desc = external.getBundleDescription();
            state.addBundleDescription(desc);
        }
    }

    private void updateBundleDescription(IPluginModelBase model) {
        BundleDescription description = model.getBundleDescription();
        if (description == null) {
            return;
        }
        PDEState state = this.externalManager.getState();
        state.removeBundleDescription(description);
        IResource file = model.getUnderlyingResource();
        String path = file != null ? file.getLocation().removeLastSegments(2).toString() : model.getInstallLocation();
        BundleDescription newDesc = state.addBundle(new File(path));
        model.setBundleDescription(newDesc);
        state.resolveState(true);
    }

    private void addToTable(IPluginModelBase[] pmodels, boolean workspace) {
        int i = 0;
        while (i < pmodels.length) {
            this.addToTable(pmodels[i], workspace);
            ++i;
        }
    }

    private void addToTable(IPluginModelBase model, boolean workspace) {
        String id = model.getPluginBase().getId();
        if (id == null) {
            return;
        }
        Map entries = this.getEntryTable();
        ModelEntry entry = (ModelEntry)((Object)entries.get(id));
        if (entry == null) {
            entry = new ModelEntry(this, id);
            entries.put(id, entry);
        }
        if (workspace) {
            entry.setWorkspaceModel(model);
        } else {
            entry.setExternalModel(model);
        }
    }

    private void fireDelta(PluginModelDelta delta) {
        Object[] entries = this.listeners.toArray();
        int i = 0;
        while (i < entries.length) {
            ((IPluginModelListener)entries[i]).modelsChanged(delta);
            ++i;
        }
    }

    public void connect(WorkspaceModelManager wm, ExternalModelManager em) {
        this.externalManager = em;
        this.workspaceManager = wm;
        this.externalManager.addModelProviderListener(this.providerListener);
        this.workspaceManager.addModelProviderListener(this.providerListener);
    }

    public void shutdown() {
        if (this.workspaceManager != null) {
            this.workspaceManager.removeModelProviderListener(this.providerListener);
        }
        if (this.externalManager != null) {
            this.externalManager.removeModelProviderListener(this.providerListener);
        }
        this.searchablePluginsManager.shutdown();
    }

    public void setInJavaSearch(ModelEntry[] entries, boolean value, IProgressMonitor monitor) throws CoreException {
        PluginModelDelta delta = new PluginModelDelta();
        int i = 0;
        while (i < entries.length) {
            ModelEntry entry = entries[i];
            if (entry.isInJavaSearch() != value) {
                entry.setInJavaSearch(value);
                delta.addEntry(entry, 4);
            }
            ++i;
        }
        if (delta.getKind() != 0) {
            this.searchablePluginsManager.persistStates(monitor);
            this.fireDelta(delta);
        }
    }

    void searchablePluginsRemoved() {
        ModelEntry[] entries = this.getEntries();
        PluginModelDelta delta = new PluginModelDelta();
        int i = 0;
        while (i < entries.length) {
            ModelEntry entry = entries[i];
            if (entry.isInJavaSearch()) {
                entry.setInJavaSearch(false);
                delta.addEntry(entry, 4);
            }
            ++i;
        }
        if (delta.getKind() != 0) {
            this.fireDelta(delta);
        }
    }

    public IFileAdapterFactory getFileAdapterFactory() {
        return this.searchablePluginsManager;
    }

    public SearchablePluginsManager getSearchablePluginsManager() {
        this.initializeTable();
        return this.searchablePluginsManager;
    }
}

