/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.builders;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.builders.PluginErrorReporter;
import org.eclipse.pde.internal.core.PDECore;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ValidatingSAXParser {
    private static SAXParserFactory fFactory;

    public static void parse(IFile file, PluginErrorReporter reporter, boolean useSystemId) {
        try {
            if (!useSystemId) {
                ValidatingSAXParser.parse(file, reporter);
                return;
            }
            InputSource source = new InputSource(file.getContents());
            URL dtdLocation = PDECore.getDefault().getDescriptor().getInstallURL();
            source.setSystemId(dtdLocation.toString());
            ValidatingSAXParser.getParser().parse(source, (DefaultHandler)reporter);
        }
        catch (SAXException sAXException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (IOException iOException) {
        }
        catch (CoreException coreException) {}
    }

    public static void parse(IFile file, PluginErrorReporter reporter) {
        try {
            ValidatingSAXParser.parse(file.getContents(), reporter);
        }
        catch (CoreException coreException) {}
    }

    public static void parse(InputStream is, PluginErrorReporter reporter) {
        try {
            ValidatingSAXParser.getParser().parse(is, (DefaultHandler)reporter);
        }
        catch (Exception exception) {}
    }

    private static SAXParser getParser() throws ParserConfigurationException, SAXException {
        if (fFactory == null) {
            fFactory = SAXParserFactory.newInstance();
        }
        return fFactory.newSAXParser();
    }
}

