/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.runtime.registry;

import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.pde.internal.runtime.PDERuntimePlugin;
import org.eclipse.pde.internal.runtime.PDERuntimePluginImages;
import org.eclipse.pde.internal.runtime.registry.PluginObjectAdapter;
import org.eclipse.pde.internal.runtime.registry.RegistryBrowserContentProvider;
import org.eclipse.pde.internal.runtime.registry.RegistryBrowserLabelProvider;
import org.eclipse.pde.internal.runtime.registry.TogglePropertiesAction;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class RegistryBrowser
extends ViewPart
implements BundleListener,
IRegistryChangeListener {
    public static final String KEY_REFRESH_LABEL = "RegistryView.refresh.label";
    public static final String KEY_REFRESH_TOOLTIP = "RegistryView.refresh.tooltip";
    public static final String SHOW_RUNNING_PLUGINS = "RegistryView.showRunning.label";
    public static final String REGISTRY_ORIENTATION = "RegistryView.orientation";
    public static final String KEY_COLLAPSE_ALL_LABEL = "RegistryView.collapseAll.label";
    public static final String KEY_COLLAPSE_ALL_TOOLTIP = "RegistryView.collapseAll.tooltip";
    public static final int VERTICAL_ORIENTATION = 1;
    public static final int HORIZONTAL_ORIENTATION = 2;
    public static final int SINGLE_PANE_ORIENTATION = 3;
    private TreeViewer treeViewer;
    private IMemento memento;
    private static int orientation;
    private int[] horizontalSashWeight;
    private int[] verticalSashWeight;
    private static final int[] DEFAULT_SASH_WEIGHTS;
    private Action refreshAction;
    private Action showPluginsAction;
    private Action collapseAllAction;
    private Action[] toggleViewAction;
    private DrillDownAdapter drillDownAdapter;
    private SashForm fSashForm;
    private Label fPropertyLabel;
    private Label fPropertyImage;
    private PropertySheetPage fPropertySheet;

    static {
        DEFAULT_SASH_WEIGHTS = new int[]{13, 6};
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento == null ? XMLMemento.createWriteRoot((String)"REGISTRYVIEW") : memento;
        this.initializeMemento();
        orientation = this.memento.getInteger(REGISTRY_ORIENTATION);
    }

    private void initializeMemento() {
        if (this.memento.getString(SHOW_RUNNING_PLUGINS) == null) {
            this.memento.putString(SHOW_RUNNING_PLUGINS, "true");
        }
        if (this.memento.getString("RegistryView.showPropertiesSheet.label") == null) {
            this.memento.putString("RegistryView.showPropertiesSheet.label", "true");
        }
        if (this.memento.getInteger(REGISTRY_ORIENTATION) == null) {
            this.memento.putInteger(REGISTRY_ORIENTATION, 2);
        }
    }

    public void dispose() {
        Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
        PDERuntimePlugin.getDefault().getBundleContext().removeBundleListener((BundleListener)this);
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        this.fSashForm = new SashForm(parent, 256);
        this.fSashForm.setLayout((Layout)new GridLayout());
        this.fSashForm.setLayoutData((Object)new GridData(1808));
        this.setSashForm(this.fSashForm);
        this.makeActions();
        this.createTreeViewer();
        this.createAttributesViewer();
        this.fillToolBar();
        this.treeViewer.refresh();
        this.setViewOrientation(orientation);
        Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)this);
        PDERuntimePlugin.getDefault().getBundleContext().addBundleListener((BundleListener)this);
    }

    private void createTreeViewer() {
        Tree tree = new Tree((Composite)this.getSashForm(), 0x800000);
        this.treeViewer = new TreeViewer(tree);
        boolean showRunning = this.memento.getString(SHOW_RUNNING_PLUGINS).equals("true");
        this.treeViewer.setContentProvider((IContentProvider)new RegistryBrowserContentProvider(this.treeViewer, showRunning));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new RegistryBrowserLabelProvider(this.treeViewer));
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setSorter(new ViewerSorter(){});
        this.treeViewer.setInput((Object)new PluginObjectAdapter(Platform.getPluginRegistry()));
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
                RegistryBrowser.this.updateAttributesView(selection);
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
                RegistryBrowser.this.updateAttributesView(selection);
                if (selection != null && RegistryBrowser.this.treeViewer.isExpandable(selection)) {
                    RegistryBrowser.this.treeViewer.setExpandedState(selection, !RegistryBrowser.this.treeViewer.getExpandedState(selection));
                }
            }
        });
        WorkbenchHelp.setHelp((Control)this.treeViewer.getControl(), (String)"org.eclipse.pde.doc.user.registry_view");
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        MenuManager popupMenuManager = new MenuManager();
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager mng) {
                RegistryBrowser.this.fillContextMenu(mng);
            }
        };
        popupMenuManager.setRemoveAllWhenShown(true);
        popupMenuManager.addMenuListener(listener);
        Menu menu = popupMenuManager.createContextMenu((Control)tree);
        tree.setMenu(menu);
    }

    protected void createAttributesViewer() {
        Composite composite = new Composite((Composite)this.getSashForm(), 0x800000);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.fPropertyImage = new Label(composite, 0);
        GridData gd = new GridData(4);
        gd.widthHint = 20;
        this.fPropertyImage.setLayoutData((Object)gd);
        this.fPropertyLabel = new Label(composite, 0);
        this.fPropertyLabel.setLayoutData((Object)new GridData(768));
        this.createPropertySheet(composite);
    }

    protected void createPropertySheet(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        composite.setLayoutData((Object)gd);
        this.fPropertySheet = new PropertySheetPage();
        this.fPropertySheet.createControl(composite);
        gd = new GridData(1808);
        this.fPropertySheet.getControl().setLayoutData((Object)gd);
        this.fPropertySheet.makeContributions((IMenuManager)new MenuManager(), (IToolBarManager)new ToolBarManager(), null);
    }

    private void fillToolBar() {
        this.drillDownAdapter = new RegistryDrillDownAdapter(this.treeViewer);
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager mng = bars.getToolBarManager();
        this.drillDownAdapter.addNavigationActions(mng);
        mng.add((IAction)this.refreshAction);
        mng.add((IContributionItem)new Separator());
        mng.add((IAction)this.collapseAllAction);
        IMenuManager mgr = bars.getMenuManager();
        mgr.add((IAction)this.toggleViewAction[0]);
        mgr.add((IAction)this.toggleViewAction[1]);
        mgr.add((IAction)this.toggleViewAction[2]);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.showPluginsAction);
    }

    public void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.refreshAction);
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator());
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    protected SashForm getSashForm() {
        return this.fSashForm;
    }

    public void saveState(IMemento memento) {
        if (memento == null || this.memento == null || this.treeViewer == null) {
            return;
        }
        boolean showRunning = ((RegistryBrowserContentProvider)this.treeViewer.getContentProvider()).isShowRunning();
        if (showRunning) {
            this.memento.putString(SHOW_RUNNING_PLUGINS, "true");
        } else {
            this.memento.putString(SHOW_RUNNING_PLUGINS, "false");
        }
        this.memento.putInteger(REGISTRY_ORIENTATION, orientation);
        memento.putMemento(this.memento);
    }

    public void updateAttributesView(Object selection) {
        this.fPropertyImage.setImage(((RegistryBrowserLabelProvider)this.treeViewer.getLabelProvider()).getImage(selection));
        this.fPropertyLabel.setText(((RegistryBrowserLabelProvider)this.treeViewer.getLabelProvider()).getText(selection));
        if (selection != null) {
            this.fPropertySheet.selectionChanged(null, (ISelection)new StructuredSelection(selection));
        } else {
            this.fPropertySheet.selectionChanged(null, (ISelection)new StructuredSelection(new Object()));
        }
    }

    private void setSashForm(SashForm sashForm) {
        this.fSashForm = sashForm;
    }

    public void setFocus() {
    }

    public void bundleChanged(BundleEvent event) {
        if (this.treeViewer == null) {
            return;
        }
        final RegistryBrowserContentProvider provider = (RegistryBrowserContentProvider)this.treeViewer.getContentProvider();
        final IPluginDescriptor descriptor = Platform.getPluginRegistry().getPluginDescriptor(event.getBundle().getSymbolicName());
        if (descriptor == null) {
            return;
        }
        final PluginObjectAdapter adapter = new PluginObjectAdapter(descriptor);
        this.treeViewer.getTree().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (RegistryBrowser.this.treeViewer == null || RegistryBrowser.this.treeViewer.getTree() == null) {
                    return;
                }
                TreeItem[] items = RegistryBrowser.this.treeViewer.getTree().getItems();
                if (items != null) {
                    int i = 0;
                    while (i < items.length) {
                        IPluginDescriptor desc;
                        Object object;
                        PluginObjectAdapter plugin = (PluginObjectAdapter)((Object)items[i].getData());
                        if (plugin != null && (object = plugin.getObject()) instanceof IPluginDescriptor && (desc = (IPluginDescriptor)object).equals(descriptor)) {
                            RegistryBrowser.this.treeViewer.remove((Object)plugin);
                            break;
                        }
                        ++i;
                    }
                }
                if (provider.isShowRunning() && !descriptor.isPluginActivated()) {
                    return;
                }
                RegistryBrowser.this.treeViewer.add(RegistryBrowser.this.treeViewer.getInput(), (Object)adapter);
            }
        });
    }

    public void registryChanged(IRegistryChangeEvent event) {
        final IExtensionDelta[] deltas = event.getExtensionDeltas();
        this.treeViewer.getTree().getDisplay().syncExec(new Runnable(){

            public void run() {
                int i = 0;
                while (i < deltas.length) {
                    IExtension ext = deltas[i].getExtension();
                    IExtensionPoint extPoint = deltas[i].getExtensionPoint();
                    IPluginDescriptor descriptor = extPoint.getDeclaringPluginDescriptor();
                    PluginObjectAdapter adapter = new PluginObjectAdapter(descriptor);
                    if (deltas[i].getKind() == 1) {
                        if (ext != null) {
                            RegistryBrowser.this.treeViewer.add((Object)adapter, (Object)ext);
                        }
                        if (extPoint != null) {
                            RegistryBrowser.this.treeViewer.add((Object)adapter, (Object)extPoint);
                        }
                    } else {
                        if (ext != null) {
                            RegistryBrowser.this.treeViewer.remove((Object)ext);
                        }
                        if (extPoint != null) {
                            RegistryBrowser.this.treeViewer.remove((Object)extPoint);
                        }
                        RegistryBrowser.this.treeViewer.refresh();
                    }
                    ++i;
                }
            }
        });
    }

    public void makeActions() {
        this.refreshAction = new Action("refresh"){

            public void run() {
                BusyIndicator.showWhile((Display)RegistryBrowser.this.treeViewer.getTree().getDisplay(), (Runnable)new Runnable(this){
                    final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        RegistryBrowser.access$1(7.access$0(this.this$1)).refresh();
                    }
                });
            }

            static /* synthetic */ RegistryBrowser access$0(7 var0) {
                return var0.RegistryBrowser.this;
            }
        };
        this.refreshAction.setText(PDERuntimePlugin.getResourceString(KEY_REFRESH_LABEL));
        this.refreshAction.setToolTipText(PDERuntimePlugin.getResourceString(KEY_REFRESH_TOOLTIP));
        this.refreshAction.setImageDescriptor(PDERuntimePluginImages.DESC_REFRESH);
        this.refreshAction.setDisabledImageDescriptor(PDERuntimePluginImages.DESC_REFRESH_DISABLED);
        this.showPluginsAction = new Action(PDERuntimePlugin.getResourceString(SHOW_RUNNING_PLUGINS)){

            public void run() {
                ((RegistryBrowserContentProvider)RegistryBrowser.this.treeViewer.getContentProvider()).setShowRunning(RegistryBrowser.this.showPluginsAction.isChecked());
                RegistryBrowser.this.handleShowRunningPlugins(RegistryBrowser.this.showPluginsAction.isChecked());
            }
        };
        this.showPluginsAction.setChecked(this.memento.getString(SHOW_RUNNING_PLUGINS).equals("true"));
        this.collapseAllAction = new Action("collapseAll"){

            public void run() {
                RegistryBrowser.this.treeViewer.collapseAll();
            }
        };
        this.collapseAllAction.setText(PDERuntimePlugin.getResourceString(KEY_COLLAPSE_ALL_LABEL));
        this.collapseAllAction.setImageDescriptor(PDERuntimePluginImages.DESC_COLLAPSE_ALL);
        this.collapseAllAction.setToolTipText(PDERuntimePlugin.getResourceString(KEY_COLLAPSE_ALL_TOOLTIP));
        this.toggleViewAction = new TogglePropertiesAction[3];
        this.toggleViewAction[0] = new TogglePropertiesAction(this, 1);
        this.toggleViewAction[1] = new TogglePropertiesAction(this, 2);
        this.toggleViewAction[2] = new TogglePropertiesAction(this, 3);
        if (orientation == 1) {
            this.toggleViewAction[0].setChecked(true);
        } else if (orientation == 2) {
            this.toggleViewAction[1].setChecked(true);
        } else {
            this.toggleViewAction[2].setChecked(true);
        }
    }

    protected void handleShowRunningPlugins(boolean showRunning) {
        if (showRunning) {
            TreeItem[] items = this.treeViewer.getTree().getItems();
            if (items == null) {
                return;
            }
            int i = 0;
            while (i < items.length) {
                IPluginDescriptor desc;
                Object object;
                PluginObjectAdapter plugin = (PluginObjectAdapter)((Object)items[i].getData());
                if (plugin != null && (object = plugin.getObject()) instanceof IPluginDescriptor && !(desc = (IPluginDescriptor)object).isPluginActivated()) {
                    this.treeViewer.remove((Object)plugin);
                }
                ++i;
            }
        } else {
            IPluginDescriptor[] descriptors = Platform.getPluginRegistry().getPluginDescriptors();
            int i = 0;
            while (i < descriptors.length) {
                if (!descriptors[i].isPluginActivated()) {
                    this.treeViewer.add(this.treeViewer.getInput(), (Object)new PluginObjectAdapter(descriptors[i]));
                }
                ++i;
            }
        }
    }

    protected void setLastSashWeights(int[] weights) {
        if (orientation == 2) {
            this.horizontalSashWeight = weights;
        } else if (orientation == 1) {
            this.verticalSashWeight = weights;
        }
    }

    public void setViewOrientation(int viewOrientation) {
        this.setLastSashWeights(this.getSashForm().getWeights());
        if (viewOrientation == 3) {
            this.getSashForm().setMaximizedControl(this.treeViewer.getControl());
        } else {
            if (viewOrientation == 1) {
                this.getSashForm().setOrientation(512);
            } else {
                this.getSashForm().setOrientation(256);
            }
            this.getSashForm().setMaximizedControl(null);
            this.getSashForm().setWeights(this.getLastSashWeights(viewOrientation));
        }
        orientation = viewOrientation;
    }

    protected int[] getLastSashWeights(int viewOrientation) {
        if (viewOrientation == 2) {
            if (this.horizontalSashWeight == null) {
                this.horizontalSashWeight = DEFAULT_SASH_WEIGHTS;
            }
            return this.horizontalSashWeight;
        }
        if (this.verticalSashWeight == null) {
            this.verticalSashWeight = DEFAULT_SASH_WEIGHTS;
        }
        return this.verticalSashWeight;
    }

    class RegistryDrillDownAdapter
    extends DrillDownAdapter {
        public RegistryDrillDownAdapter(TreeViewer tree) {
            super(tree);
        }

        public void goInto() {
            super.goInto();
            RegistryBrowser.this.showPluginsAction.setEnabled(!this.canGoHome());
        }

        public void goBack() {
            super.goBack();
            RegistryBrowser.this.showPluginsAction.setEnabled(!this.canGoHome());
        }

        public void goHome() {
            super.goHome();
            RegistryBrowser.this.showPluginsAction.setEnabled(!this.canGoHome());
        }

        public void goInto(Object newInput) {
            super.goInto(newInput);
            RegistryBrowser.this.showPluginsAction.setEnabled(!this.canGoHome());
        }
    }
}

