/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathsBlock;
import org.eclipse.jdt.ui.wizards.NewElementWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.WorkbenchHelp;

public class JavaCapabilityConfigurationPage
extends NewElementWizardPage {
    private static final String PAGE_NAME = "JavaCapabilityConfigurationPage";
    private IJavaProject fJavaProject = null;
    private BuildPathsBlock fBuildPathsBlock;

    public JavaCapabilityConfigurationPage() {
        super(PAGE_NAME);
        this.setTitle(NewWizardMessages.getString("JavaCapabilityConfigurationPage.title"));
        this.setDescription(NewWizardMessages.getString("JavaCapabilityConfigurationPage.description"));
        IStatusChangeListener listener = new IStatusChangeListener(){

            public void statusChanged(IStatus status) {
                JavaCapabilityConfigurationPage.this.updateStatus(status);
            }
        };
        this.fBuildPathsBlock = new BuildPathsBlock(listener, 0);
    }

    public void init(IJavaProject jproject, IPath defaultOutputLocation, IClasspathEntry[] defaultEntries, boolean defaultsOverrideExistingClasspath) {
        if (!defaultsOverrideExistingClasspath && jproject.exists() && jproject.getProject().getFile(".classpath").exists()) {
            defaultOutputLocation = null;
            defaultEntries = null;
        }
        this.fBuildPathsBlock.init(jproject, defaultOutputLocation, defaultEntries);
        this.fJavaProject = jproject;
    }

    public void createControl(Composite parent) {
        Control control = this.fBuildPathsBlock.createControl(parent);
        this.setControl(control);
        Dialog.applyDialogFont((Control)control);
        WorkbenchHelp.setHelp((Control)control, (String)"org.eclipse.jdt.ui.new_javaproject_wizard_page_context");
    }

    public IPath getOutputLocation() {
        return this.fBuildPathsBlock.getOutputLocation();
    }

    public IClasspathEntry[] getRawClassPath() {
        return this.fBuildPathsBlock.getRawClassPath();
    }

    public IJavaProject getJavaProject() {
        return this.fJavaProject;
    }

    public IRunnableWithProgress getRunnable() {
        if (this.getJavaProject() != null) {
            return new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        JavaCapabilityConfigurationPage.this.configureJavaProject(monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
        }
        return null;
    }

    public static void createProject(IProject project, IPath locationPath, IProgressMonitor monitor) throws CoreException {
        BuildPathsBlock.createProject(project, locationPath, monitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void configureJavaProject(IProgressMonitor monitor) throws CoreException, InterruptedException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        int nSteps = 6;
        monitor.beginTask(NewWizardMessages.getString("JavaCapabilityConfigurationPage.op_desc_java"), nSteps);
        try {
            try {
                IProject project = this.getJavaProject().getProject();
                BuildPathsBlock.addJavaNature(project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.fBuildPathsBlock.configureJavaProject((IProgressMonitor)new SubProgressMonitor(monitor, 5));
            }
            catch (OperationCanceledException operationCanceledException) {
                throw new InterruptedException();
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        monitor.done();
    }
}

