/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.Resources;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.jdt.internal.ui.dialogs.OptionalMessageDialog;
import org.eclipse.jdt.internal.ui.dialogs.ProblemDialog;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.text.comment.CommentFormattingContext;
import org.eclipse.jdt.internal.ui.text.comment.CommentFormattingStrategy;
import org.eclipse.jdt.internal.ui.text.java.JavaFormattingStrategy;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;

public class FormatAllAction
extends SelectionDispatchAction {
    public FormatAllAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.getString("FormatAllAction.label"));
        this.setToolTipText(ActionMessages.getString("FormatAllAction.tooltip"));
        this.setDescription(ActionMessages.getString("FormatAllAction.description"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.format_all_action");
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.isEnabled(selection));
    }

    private ICompilationUnit[] getCompilationUnits(IStructuredSelection selection) {
        HashSet<IJavaElement> result = new HashSet<IJavaElement>();
        Object[] selected = selection.toArray();
        int i = 0;
        while (i < selected.length) {
            block15: {
                try {
                    if (selected[i] instanceof IJavaElement) {
                        IJavaElement elem = (IJavaElement)selected[i];
                        if (!elem.exists()) break block15;
                        switch (elem.getElementType()) {
                            case 7: {
                                if (elem.getParent().getElementType() != 5) break;
                                result.add(elem.getParent());
                                break;
                            }
                            case 5: {
                                result.add(elem);
                                break;
                            }
                            case 4: {
                                this.collectCompilationUnits((IPackageFragment)elem, result);
                                break;
                            }
                            case 3: {
                                this.collectCompilationUnits((IPackageFragmentRoot)elem, result);
                                break;
                            }
                            case 2: {
                                IPackageFragmentRoot[] roots = ((IJavaProject)elem).getPackageFragmentRoots();
                                int k = 0;
                                while (k < roots.length) {
                                    this.collectCompilationUnits(roots[k], result);
                                    ++k;
                                }
                                break block15;
                            }
                        }
                        break block15;
                    }
                    if (selected[i] instanceof LogicalPackage) {
                        IPackageFragment[] packageFragments = ((LogicalPackage)((Object)selected[i])).getFragments();
                        int k = 0;
                        while (k < packageFragments.length) {
                            IPackageFragment pack = packageFragments[k];
                            if (pack.exists()) {
                                this.collectCompilationUnits(pack, result);
                            }
                            ++k;
                        }
                    }
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e);
                }
            }
            ++i;
        }
        return result.toArray(new ICompilationUnit[result.size()]);
    }

    private void collectCompilationUnits(IPackageFragment pack, Collection result) throws JavaModelException {
        result.addAll(Arrays.asList(pack.getCompilationUnits()));
    }

    private void collectCompilationUnits(IPackageFragmentRoot root, Collection result) throws JavaModelException {
        if (root.getKind() == 1) {
            IJavaElement[] children = root.getChildren();
            int i = 0;
            while (i < children.length) {
                this.collectCompilationUnits((IPackageFragment)children[i], result);
                ++i;
            }
        }
    }

    private boolean isEnabled(IStructuredSelection selection) {
        Object[] selected = selection.toArray();
        int i = 0;
        while (i < selected.length) {
            try {
                if (selected[i] instanceof IJavaElement) {
                    IJavaElement elem = (IJavaElement)selected[i];
                    if (elem.exists()) {
                        switch (elem.getElementType()) {
                            case 7: {
                                return elem.getParent().getElementType() == 5;
                            }
                            case 5: {
                                return true;
                            }
                            case 3: 
                            case 4: {
                                IPackageFragmentRoot root = (IPackageFragmentRoot)elem.getAncestor(3);
                                return root.getKind() == 1;
                            }
                            case 2: {
                                return true;
                            }
                        }
                    }
                } else if (selected[i] instanceof LogicalPackage) {
                    return true;
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
            ++i;
        }
        return false;
    }

    public void run(ITextSelection selection) {
    }

    public void run(IStructuredSelection selection) {
        int returnCode;
        ICompilationUnit[] cus = this.getCompilationUnits(selection);
        if (cus.length == 0) {
            return;
        }
        if (cus.length > 1 && (returnCode = OptionalMessageDialog.open("FormatAll", this.getShell(), ActionMessages.getString("FormatAllAction.noundo.title"), null, ActionMessages.getString("FormatAllAction.noundo.message"), 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0)) != 1025 && returnCode != 0) {
            return;
        }
        IStatus status = Resources.makeCommittable(this.getResources(cus), (Object)this.getShell());
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)ActionMessages.getString("FormatAllAction.failedvalidateedit.title"), (String)ActionMessages.getString("FormatAllAction.failedvalidateedit.message"), (IStatus)status);
            return;
        }
        this.runOnMultiple(cus);
    }

    private IResource[] getResources(ICompilationUnit[] cus) {
        IResource[] res = new IResource[cus.length];
        int i = 0;
        while (i < res.length) {
            res[i] = cus[i].getResource();
            ++i;
        }
        return res;
    }

    public void runOnMultiple(final ICompilationUnit[] cus) {
        try {
            String message = ActionMessages.getString("FormatAllAction.status.description");
            final MultiStatus status = new MultiStatus("org.eclipse.jdt.ui", 0, message, null);
            if (cus.length == 1) {
                EditorUtility.openInEditor(cus[0]);
            }
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) {
                    FormatAllAction.this.doRunOnMultiple(cus, status, monitor);
                }
            }));
            if (!status.isOK()) {
                String title = ActionMessages.getString("FormatAllAction.multi.status.title");
                ProblemDialog.open(this.getShell(), title, null, (IStatus)status);
            }
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), ActionMessages.getString("FormatAllAction.error.title"), ActionMessages.getString("FormatAllAction.error.message"));
        }
        catch (InterruptedException interruptedException) {
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), ActionMessages.getString("FormatAllAction.error.title"), ActionMessages.getString("FormatAllAction.error.message"));
        }
    }

    private static Map getFomatterSettings(IJavaProject project) {
        Map options = project.getOptions(true);
        new CommentFormattingContext().storeToMap(PreferenceConstants.getPreferenceStore(), options, false);
        return options;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doFormat(IDocument document, Map options) {
        CommentFormattingContext context = new CommentFormattingContext();
        try {
            context.setProperty("formatting.context.preferences", options);
            context.setProperty("formatting.context.document", true);
            MultiPassContentFormatter formatter = new MultiPassContentFormatter("___java_partitioning", "__dftl_partition_content_type");
            formatter.setMasterStrategy((IFormattingStrategy)new JavaFormattingStrategy());
            formatter.setSlaveStrategy((IFormattingStrategy)new CommentFormattingStrategy(null), "__java_javadoc");
            formatter.setSlaveStrategy((IFormattingStrategy)new CommentFormattingStrategy(null), "__java_singleline_comment");
            formatter.setSlaveStrategy((IFormattingStrategy)new CommentFormattingStrategy(null), "__java_multiline_comment");
            try {
                this.startSequentialRewriteMode(document);
                formatter.format(document, (IFormattingContext)context);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.stopSequentialRewriteMode(document);
                throw throwable;
            }
            {
                Object var5_7 = null;
                this.stopSequentialRewriteMode(document);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            context.dispose();
            throw throwable;
        }
        {
            Object var7_10 = null;
        }
        context.dispose();
    }

    private void startSequentialRewriteMode(IDocument document) {
        if (document instanceof IDocumentExtension) {
            IDocumentExtension extension = (IDocumentExtension)document;
            extension.startSequentialRewrite(false);
        }
    }

    private void stopSequentialRewriteMode(IDocument document) {
        if (document instanceof IDocumentExtension) {
            IDocumentExtension extension = (IDocumentExtension)document;
            extension.stopSequentialRewrite();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doRunOnMultiple(ICompilationUnit[] cus, MultiStatus status, IProgressMonitor monitor) throws OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.setTaskName(ActionMessages.getString("FormatAllAction.operation.description"));
        monitor.beginTask("", cus.length * 4);
        try {
            Map lastOptions = null;
            IJavaProject lastProject = null;
            int i = 0;
            while (i < cus.length) {
                ICompilationUnit cu = cus[i];
                IPath path = cu.getPath();
                if (lastProject == null || !lastProject.equals(cu.getJavaProject())) {
                    lastProject = cu.getJavaProject();
                    lastOptions = FormatAllAction.getFomatterSettings(lastProject);
                }
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
                try {
                    Object var11_12;
                    try {
                        manager.connect(path, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        monitor.subTask(path.makeRelative().toString());
                        ITextFileBuffer fileBuffer = manager.getTextFileBuffer(path);
                        this.formatCompilationUnit(fileBuffer, lastOptions);
                        if (fileBuffer.isDirty() && !fileBuffer.isShared()) {
                            fileBuffer.commit((IProgressMonitor)new SubProgressMonitor(monitor, 2), false);
                        } else {
                            monitor.worked(2);
                        }
                    }
                    catch (Throwable throwable) {
                        var11_12 = null;
                        manager.disconnect(path, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        throw throwable;
                    }
                    {
                        var11_12 = null;
                        manager.disconnect(path, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                }
                catch (CoreException e) {
                    status.add(e.getStatus());
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var13_16 = null;
        }
        monitor.done();
    }

    private void formatCompilationUnit(final ITextFileBuffer fileBuffer, final Map options) {
        if (fileBuffer.isShared()) {
            this.getShell().getDisplay().syncExec(new Runnable(){

                public void run() {
                    FormatAllAction.this.doFormat(fileBuffer.getDocument(), options);
                }
            });
        } else {
            this.doFormat(fileBuffer.getDocument(), options);
        }
    }

    public static class ObjectDelegate
    implements IObjectActionDelegate {
        private FormatAllAction fAction;

        public void setActivePart(IAction action, IWorkbenchPart targetPart) {
            this.fAction = new FormatAllAction((IWorkbenchSite)targetPart.getSite());
        }

        public void run(IAction action) {
            this.fAction.run();
        }

        public void selectionChanged(IAction action, ISelection selection) {
            if (this.fAction == null) {
                action.setEnabled(false);
            }
        }
    }
}

