/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.viewsupport;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.viewsupport.ISelectionListenerWithAST;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class SelectionListenerWithASTManager {
    private static SelectionListenerWithASTManager fgDefault;
    private Map fListenerGroups = new HashMap();

    public static SelectionListenerWithASTManager getDefault() {
        if (fgDefault == null) {
            fgDefault = new SelectionListenerWithASTManager();
        }
        return fgDefault;
    }

    private SelectionListenerWithASTManager() {
    }

    public void addListener(ITextEditor part, ISelectionListenerWithAST listener) {
        PartListenerGroup partListener = (PartListenerGroup)this.fListenerGroups.get(part);
        if (partListener == null) {
            partListener = new PartListenerGroup(part);
            this.fListenerGroups.put(part, partListener);
        }
        partListener.install(listener);
    }

    public void removeListener(ITextEditor part, ISelectionListenerWithAST listener) {
        PartListenerGroup partListener = (PartListenerGroup)this.fListenerGroups.get(part);
        if (partListener != null) {
            partListener.uninstall(listener);
            if (partListener.isEmpty()) {
                this.fListenerGroups.remove(part);
            }
        }
    }

    public void forceSelectionChange(ITextEditor part, ITextSelection selection) {
        PartListenerGroup partListener = (PartListenerGroup)this.fListenerGroups.get(part);
        if (partListener != null) {
            partListener.firePostSelectionChanged(selection);
        }
    }

    private static final class PartListenerGroup {
        private ITextEditor fPart;
        private ISelectionChangedListener fSelectionListener;
        private ISelectionChangedListener fPostSelectionListener;
        private Job fCurrentJob;
        private ListenerList fAstListeners;
        static /* synthetic */ Class class$0;

        public PartListenerGroup(ITextEditor part) {
            this.fPart = part;
            this.fCurrentJob = null;
            this.fAstListeners = new ListenerList();
            this.fSelectionListener = new ISelectionChangedListener(this){
                final /* synthetic */ PartListenerGroup this$1;
                {
                    this.this$1 = partListenerGroup;
                }

                public void selectionChanged(SelectionChangedEvent event) {
                    ISelection selection = event.getSelection();
                    if (selection instanceof ITextSelection) {
                        this.this$1.fireSelectionChanged((ITextSelection)selection);
                    }
                }
            };
            this.fPostSelectionListener = new ISelectionChangedListener(this){
                final /* synthetic */ PartListenerGroup this$1;
                {
                    this.this$1 = partListenerGroup;
                }

                public void selectionChanged(SelectionChangedEvent event) {
                    ISelection selection = event.getSelection();
                    if (selection instanceof ITextSelection) {
                        this.this$1.firePostSelectionChanged((ITextSelection)selection);
                    }
                }
            };
        }

        public boolean isEmpty() {
            return this.fAstListeners.isEmpty();
        }

        public void install(ISelectionListenerWithAST listener) {
            ISelectionProvider selectionProvider;
            if (this.isEmpty() && (selectionProvider = this.fPart.getSelectionProvider()) instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)selectionProvider).addPostSelectionChangedListener(this.fPostSelectionListener);
                selectionProvider.addSelectionChangedListener(this.fSelectionListener);
            }
            this.fAstListeners.add((Object)listener);
        }

        public void uninstall(ISelectionListenerWithAST listener) {
            ISelectionProvider selectionProvider;
            this.fAstListeners.remove((Object)listener);
            if (this.isEmpty() && (selectionProvider = this.fPart.getSelectionProvider()) instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)selectionProvider).removePostSelectionChangedListener(this.fPostSelectionListener);
                selectionProvider.removeSelectionChangedListener(this.fSelectionListener);
            }
        }

        public void fireSelectionChanged(ITextSelection selection) {
            if (this.fCurrentJob != null) {
                this.fCurrentJob.cancel();
            }
        }

        public void firePostSelectionChanged(ITextSelection selection) {
            IJavaElement input;
            if (this.fCurrentJob != null) {
                this.fCurrentJob.cancel();
            }
            if ((input = this.getJavaElement()) == null) {
                return;
            }
            this.fCurrentJob = new Job(this, JavaUIMessages.getString("SelectionListenerWithASTManager.job.title"), input, selection){
                final /* synthetic */ PartListenerGroup this$1;
                private final /* synthetic */ IJavaElement val$input;
                private final /* synthetic */ ITextSelection val$selection;
                {
                    this.this$1 = partListenerGroup;
                    this.val$input = iJavaElement;
                    this.val$selection = iTextSelection;
                }

                public IStatus run(IProgressMonitor monitor) {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    PartListenerGroup partListenerGroup = this.this$1;
                    synchronized (partListenerGroup) {
                        return this.this$1.calculateASTandInform(this.val$input, this.val$selection, monitor);
                    }
                }
            };
            this.fCurrentJob.setPriority(50);
            this.fCurrentJob.setSystem(true);
            this.fCurrentJob.schedule();
        }

        private IJavaElement getJavaElement() {
            IEditorInput editorInput = this.fPart.getEditorInput();
            if (editorInput != null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return (IJavaElement)editorInput.getAdapter((Class)clazz);
            }
            return null;
        }

        protected IStatus calculateASTandInform(IJavaElement input, ITextSelection selection, IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            try {
                CompilationUnit astRoot = JavaPlugin.getDefault().getASTProvider().getAST(input, true, monitor);
                if (astRoot != null && !monitor.isCanceled()) {
                    Object[] listeners = this.fAstListeners.getListeners();
                    int i = 0;
                    while (i < listeners.length) {
                        ((ISelectionListenerWithAST)listeners[i]).selectionChanged((IEditorPart)this.fPart, selection, astRoot);
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        ++i;
                    }
                    return Status.OK_STATUS;
                }
            }
            catch (OperationCanceledException operationCanceledException) {}
            return Status.CANCEL_STATUS;
        }
    }
}

