/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.CompletionRequestorAdapter;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.codeassist.IExtendedCompletionRequestor;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.TypeFilter;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.java.AnonymousTypeCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.GetterSetterCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaTextMessages;
import org.eclipse.jdt.internal.ui.text.java.JavaTypeCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.MethodCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.OverrideCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.ProposalContextInformation;
import org.eclipse.jdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Image;

public class ResultCollector
extends CompletionRequestorAdapter
implements IExtendedCompletionRequestor {
    private static final char[] METHOD_WITH_ARGUMENTS_TRIGGERS = new char[]{'(', '-', ' '};
    private static final char[] METHOD_TRIGGERS = new char[]{';', ',', '.', '\t', '[', ' '};
    private static final char[] TYPE_TRIGGERS = new char[]{'.', '\t', '[', '(', ' '};
    private static final char[] VAR_TRIGGER = new char[]{'\t', ' ', '=', ';', '.'};
    protected IJavaProject fJavaProject;
    protected ICompilationUnit fCompilationUnit;
    protected int fCodeAssistOffset;
    protected int fContextOffset;
    protected ITextViewer fTextViewer;
    private ArrayList fFields = new ArrayList();
    private ArrayList fKeywords = new ArrayList(10);
    private ArrayList fLabels = new ArrayList(10);
    private ArrayList fMethods = new ArrayList();
    private ArrayList fModifiers = new ArrayList(10);
    private ArrayList fPackages = new ArrayList();
    private ArrayList fTypes = new ArrayList();
    private ArrayList fVariables = new ArrayList();
    private IProblem fLastProblem;
    private ImageDescriptorRegistry fRegistry = JavaPlugin.getImageDescriptorRegistry();
    private ArrayList[] fResults = new ArrayList[]{this.fPackages, this.fLabels, this.fModifiers, this.fKeywords, this.fTypes, this.fMethods, this.fFields, this.fVariables};
    private Set fSuggestedMethodNames = new HashSet();
    private int fUserReplacementLength;
    private boolean fPreventEating = true;

    public void acceptClass(char[] packageName, char[] typeName, char[] completionName, int modifiers, int start, int end, int relevance) {
        if (TypeFilter.isFiltered(packageName)) {
            return;
        }
        ImageDescriptor descriptor = JavaElementImageProvider.getTypeImageDescriptor(false, false, false, modifiers);
        if (Flags.isDeprecated((int)modifiers)) {
            descriptor = this.getDeprecatedDescriptor(descriptor);
        }
        ProposalInfo info = new ProposalInfo(this.fJavaProject, packageName, typeName);
        this.fTypes.add(this.createTypeCompletion(start, end, new String(completionName), descriptor, new String(typeName), new String(packageName), info, relevance));
    }

    public void acceptError(IProblem error) {
        this.fLastProblem = error;
    }

    public void acceptField(char[] declaringTypePackageName, char[] declaringTypeName, char[] name, char[] typePackageName, char[] typeName, char[] completionName, int modifiers, int start, int end, int relevance) {
        if (TypeFilter.isFiltered(declaringTypePackageName)) {
            return;
        }
        ImageDescriptor descriptor = this.getFieldDescriptor(modifiers);
        StringBuffer nameBuffer = new StringBuffer();
        nameBuffer.append(name);
        if (typeName.length > 0) {
            nameBuffer.append("   ");
            nameBuffer.append(typeName);
        }
        if (declaringTypeName != null && declaringTypeName.length > 0) {
            nameBuffer.append(" - ");
            nameBuffer.append(declaringTypeName);
        }
        JavaCompletionProposal proposal = this.createCompletion(start, end, new String(completionName), descriptor, nameBuffer.toString(), relevance);
        proposal.setProposalInfo(new ProposalInfo(this.fJavaProject, declaringTypePackageName, declaringTypeName, name));
        proposal.setTriggerCharacters(VAR_TRIGGER);
        this.fFields.add(proposal);
    }

    public void acceptInterface(char[] packageName, char[] typeName, char[] completionName, int modifiers, int start, int end, int relevance) {
        if (TypeFilter.isFiltered(packageName)) {
            return;
        }
        ImageDescriptor descriptor = JavaElementImageProvider.getTypeImageDescriptor(true, false, false, modifiers);
        if (Flags.isDeprecated((int)modifiers)) {
            descriptor = this.getDeprecatedDescriptor(descriptor);
        }
        ProposalInfo info = new ProposalInfo(this.fJavaProject, packageName, typeName);
        this.fTypes.add(this.createTypeCompletion(start, end, new String(completionName), descriptor, new String(typeName), new String(packageName), info, relevance));
    }

    public void acceptAnonymousType(char[] superTypePackageName, char[] superTypeName, char[][] parameterPackageNames, char[][] parameterTypeNames, char[][] parameterNames, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
        if (TypeFilter.isFiltered(superTypePackageName)) {
            return;
        }
        JavaCompletionProposal proposal = this.createAnonymousTypeCompletion(superTypePackageName, superTypeName, parameterTypeNames, parameterNames, completionName, completionStart, completionEnd, relevance);
        proposal.setProposalInfo(new ProposalInfo(this.fJavaProject, superTypePackageName, superTypeName));
        this.fTypes.add(proposal);
    }

    public void acceptKeyword(char[] keyword, int start, int end, int relevance) {
        String kw = new String(keyword);
        this.fKeywords.add(this.createCompletion(start, end, kw, null, kw, relevance));
    }

    public void acceptLabel(char[] labelName, int start, int end, int relevance) {
        String ln = new String(labelName);
        this.fLabels.add(this.createCompletion(start, end, ln, null, ln, relevance));
    }

    public void acceptLocalVariable(char[] name, char[] typePackageName, char[] typeName, int modifiers, int start, int end, int relevance) {
        StringBuffer buf = new StringBuffer();
        buf.append(name);
        if (typeName != null) {
            buf.append("    ");
            buf.append(typeName);
        }
        JavaCompletionProposal proposal = this.createCompletion(start, end, new String(name), JavaPluginImages.DESC_OBJS_LOCAL_VARIABLE, buf.toString(), relevance);
        proposal.setTriggerCharacters(VAR_TRIGGER);
        this.fVariables.add(proposal);
    }

    protected String getParameterSignature(char[][] parameterTypeNames, char[][] parameterNames) {
        StringBuffer buf = new StringBuffer();
        if (parameterTypeNames != null) {
            int i = 0;
            while (i < parameterTypeNames.length) {
                if (i > 0) {
                    buf.append(',');
                    buf.append(' ');
                }
                buf.append(parameterTypeNames[i]);
                if (parameterNames != null && parameterNames[i] != null) {
                    buf.append(' ');
                    buf.append(parameterNames[i]);
                }
                ++i;
            }
        }
        return buf.toString();
    }

    public void acceptMethod(char[] declaringTypePackageName, char[] declaringTypeName, char[] name, char[][] parameterPackageNames, char[][] parameterTypeNames, char[][] parameterNames, char[] returnTypePackageName, char[] returnTypeName, char[] completionName, int modifiers, int start, int end, int relevance) {
        if (completionName == null) {
            return;
        }
        if (TypeFilter.isFiltered(declaringTypePackageName)) {
            return;
        }
        JavaCompletionProposal proposal = this.createMethodCallCompletion(declaringTypeName, name, parameterPackageNames, parameterTypeNames, parameterNames, returnTypeName, completionName, modifiers, start, end, relevance);
        boolean isConstructor = returnTypeName == null ? true : returnTypeName.length == 0;
        proposal.setProposalInfo(new ProposalInfo(this.fJavaProject, declaringTypePackageName, declaringTypeName, name, parameterPackageNames, parameterTypeNames, isConstructor));
        boolean hasOpeningBracket = completionName.length == 0 || completionName.length > 0 && completionName[completionName.length - 1] == ')';
        ProposalContextInformation contextInformation = null;
        if (hasOpeningBracket && parameterTypeNames.length > 0) {
            contextInformation = new ProposalContextInformation();
            contextInformation.setInformationDisplayString(this.getParameterSignature(parameterTypeNames, parameterNames));
            contextInformation.setContextDisplayString(proposal.getDisplayString());
            contextInformation.setImage(proposal.getImage());
            int position = completionName.length == 0 ? this.fContextOffset : -1;
            contextInformation.setContextInformationPosition(position);
            proposal.setContextInformation(contextInformation);
        }
        boolean userMustCompleteParameters = contextInformation != null && completionName.length > 0;
        char[] triggers = userMustCompleteParameters ? METHOD_WITH_ARGUMENTS_TRIGGERS : METHOD_TRIGGERS;
        proposal.setTriggerCharacters(triggers);
        if (userMustCompleteParameters) {
            proposal.setCursorPosition(completionName.length - 1);
        }
        this.fMethods.add(proposal);
    }

    public void acceptModifier(char[] modifier, int start, int end, int relevance) {
        String mod = new String(modifier);
        this.fModifiers.add(this.createCompletion(start, end, mod, null, mod, relevance));
    }

    public void acceptPackage(char[] packageName, char[] completionName, int start, int end, int relevance) {
        if (TypeFilter.isFiltered(packageName)) {
            return;
        }
        this.fPackages.add(this.createCompletion(start, end, new String(completionName), JavaPluginImages.DESC_OBJS_PACKAGE, new String(packageName), relevance));
    }

    public void acceptType(char[] packageName, char[] typeName, char[] completionName, int start, int end, int relevance) {
        if (TypeFilter.isFiltered(packageName)) {
            return;
        }
        ProposalInfo info = new ProposalInfo(this.fJavaProject, packageName, typeName);
        this.fTypes.add(this.createTypeCompletion(start, end, new String(completionName), JavaPluginImages.DESC_OBJS_CLASS, new String(typeName), new String(packageName), info, relevance));
    }

    public void acceptMethodDeclaration(char[] declaringTypePackageName, char[] declaringTypeName, char[] name, char[][] parameterPackageNames, char[][] parameterTypeNames, char[][] parameterNames, char[] returnTypePackageName, char[] returnTypeName, char[] completionName, int modifiers, int start, int end, int relevance) {
        StringBuffer displayString = this.getMethodDisplayString(null, name, parameterTypeNames, parameterNames, returnTypeName);
        displayString.append(" - ");
        displayString.append(JavaTextMessages.getFormattedString("ResultCollector.overridingmethod", new String(declaringTypeName)));
        StringBuffer typeName = new StringBuffer();
        if (declaringTypePackageName.length > 0) {
            typeName.append(declaringTypePackageName);
            typeName.append('.');
        }
        typeName.append(declaringTypeName);
        String[] paramTypes = new String[parameterTypeNames.length];
        int i = 0;
        while (i < parameterTypeNames.length) {
            paramTypes[i] = Signature.createTypeSignature((char[])parameterTypeNames[i], (boolean)true);
            ++i;
        }
        OverrideCompletionProposal proposal = new OverrideCompletionProposal(this.fJavaProject, this.fCompilationUnit, typeName.toString(), new String(name), paramTypes, start, this.getLength(start, end), displayString.toString(), new String(completionName));
        proposal.setImage(this.getImage(this.getMemberDescriptor(modifiers)));
        proposal.setProposalInfo(new ProposalInfo(this.fJavaProject, declaringTypePackageName, declaringTypeName, name, parameterPackageNames, parameterTypeNames, returnTypeName.length == 0));
        proposal.setRelevance(relevance + 100);
        this.fMethods.add(proposal);
        this.fSuggestedMethodNames.add(new String(name));
    }

    public void acceptPotentialMethodDeclaration(char[] declaringTypePackageName, char[] declaringTypeName, char[] selector, int completionStart, int completionEnd, int relevance) {
        if (this.fCompilationUnit == null) {
            return;
        }
        String prefix = new String(selector);
        try {
            IType type;
            IJavaElement element = this.fCompilationUnit.getElementAt(this.fCodeAssistOffset);
            if (element != null && (type = (IType)element.getAncestor(7)) != null) {
                GetterSetterCompletionProposal.evaluateProposals(type, prefix, completionStart, completionEnd - completionStart, relevance + 100, this.fSuggestedMethodNames, this.fMethods);
                MethodCompletionProposal.evaluateProposals(type, prefix, completionStart, completionEnd - completionStart, relevance + 99, this.fSuggestedMethodNames, this.fMethods);
            }
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
    }

    public void acceptVariableName(char[] typePackageName, char[] typeName, char[] name, char[] completionName, int start, int end, int relevance) {
        StringBuffer buf = new StringBuffer();
        buf.append(name);
        if (typeName != null && typeName.length > 0) {
            buf.append(" - ");
            buf.append(typeName);
        }
        JavaCompletionProposal proposal = this.createCompletion(start, end, new String(completionName), null, buf.toString(), relevance);
        proposal.setTriggerCharacters(VAR_TRIGGER);
        this.fVariables.add(proposal);
    }

    public String getErrorMessage() {
        if (this.fLastProblem != null) {
            return this.fLastProblem.getMessage();
        }
        return "";
    }

    public JavaCompletionProposal[] getResults() {
        int totLen = 0;
        int i = 0;
        while (i < this.fResults.length) {
            totLen += this.fResults[i].size();
            ++i;
        }
        JavaCompletionProposal[] result = new JavaCompletionProposal[totLen];
        int k = 0;
        int i2 = 0;
        while (i2 < this.fResults.length) {
            ArrayList curr = this.fResults[i2];
            int currLen = curr.size();
            int j = 0;
            while (j < currLen) {
                JavaCompletionProposal proposal = (JavaCompletionProposal)curr.get(j);
                proposal.setRelevance(proposal.getRelevance() * 16 + i2);
                result[k++] = proposal;
                ++j;
            }
            ++i2;
        }
        return result;
    }

    public JavaCompletionProposal[] getKeywordCompletions() {
        return this.fKeywords.toArray(new JavaCompletionProposal[this.fKeywords.size()]);
    }

    private StringBuffer getMethodDisplayString(char[] declaringTypeName, char[] name, char[][] parameterTypeNames, char[][] parameterNames, char[] returnTypeName) {
        StringBuffer nameBuffer = new StringBuffer();
        nameBuffer.append(name);
        nameBuffer.append('(');
        if (parameterTypeNames != null && parameterTypeNames.length > 0) {
            nameBuffer.append(this.getParameterSignature(parameterTypeNames, parameterNames));
        }
        nameBuffer.append(')');
        if (returnTypeName != null && returnTypeName.length > 0) {
            nameBuffer.append("  ");
            nameBuffer.append(returnTypeName);
        }
        if (declaringTypeName != null && declaringTypeName.length > 0) {
            nameBuffer.append(" - ");
            nameBuffer.append(declaringTypeName);
        }
        return nameBuffer;
    }

    protected JavaCompletionProposal createMethodCallCompletion(char[] declaringTypeName, char[] name, char[][] parameterTypePackageNames, char[][] parameterTypeNames, char[][] parameterNames, char[] returnTypeName, char[] completionName, int modifiers, int start, int end, int relevance) {
        ImageDescriptor descriptor = this.getMemberDescriptor(modifiers);
        StringBuffer nameBuffer = this.getMethodDisplayString(declaringTypeName, name, parameterTypeNames, parameterNames, returnTypeName);
        return this.createCompletion(start, end, new String(completionName), descriptor, nameBuffer.toString(), relevance);
    }

    protected JavaCompletionProposal createAnonymousTypeCompletion(char[] declaringTypePackageName, char[] declaringTypeName, char[][] parameterTypeNames, char[][] parameterNames, char[] completionName, int start, int end, int relevance) {
        StringBuffer declTypeBuf = new StringBuffer();
        if (declaringTypePackageName.length > 0) {
            declTypeBuf.append(declaringTypePackageName);
            declTypeBuf.append('.');
        }
        declTypeBuf.append(declaringTypeName);
        StringBuffer nameBuffer = new StringBuffer();
        nameBuffer.append(declaringTypeName);
        nameBuffer.append('(');
        if (parameterTypeNames.length > 0) {
            nameBuffer.append(this.getParameterSignature(parameterTypeNames, parameterNames));
        }
        nameBuffer.append(')');
        nameBuffer.append("  ");
        nameBuffer.append(JavaTextMessages.getString("ResultCollector.anonymous_type"));
        int length = end - start;
        return new AnonymousTypeCompletionProposal(this.fJavaProject, this.fCompilationUnit, start, length, new String(completionName), nameBuffer.toString(), declTypeBuf.toString(), relevance);
    }

    protected JavaCompletionProposal createTypeCompletion(int start, int end, String completion, ImageDescriptor descriptor, String typeName, String containerName, ProposalInfo proposalInfo, int relevance) {
        String fullName = JavaModelUtil.concatenateName(containerName, typeName);
        StringBuffer buf = new StringBuffer(Signature.getSimpleName((String)fullName));
        String typeQualifier = Signature.getQualifier((String)fullName);
        if (typeQualifier.length() > 0) {
            buf.append(" - ");
            buf.append(typeQualifier);
        } else if (containerName != null) {
            buf.append(JavaTextMessages.getString("ResultCollector.default_package"));
        }
        String name = buf.toString();
        ICompilationUnit cu = null;
        if (containerName != null && this.fCompilationUnit != null && completion.equals(fullName)) {
            cu = this.fCompilationUnit;
        }
        JavaTypeCompletionProposal proposal = new JavaTypeCompletionProposal(completion, cu, start, this.getLength(start, end), this.getImage(descriptor), name, relevance, typeName, containerName);
        proposal.setProposalInfo(proposalInfo);
        proposal.setTriggerCharacters(TYPE_TRIGGERS);
        return proposal;
    }

    protected ImageDescriptor getMemberDescriptor(int modifiers) {
        ImageDescriptor desc = JavaElementImageProvider.getMethodImageDescriptor(false, modifiers);
        if (Flags.isDeprecated((int)modifiers)) {
            desc = this.getDeprecatedDescriptor(desc);
        }
        if (Flags.isStatic((int)modifiers)) {
            desc = this.getStaticDescriptor(desc);
        }
        return desc;
    }

    protected ImageDescriptor getFieldDescriptor(int modifiers) {
        ImageDescriptor desc = JavaElementImageProvider.getFieldImageDescriptor(false, modifiers);
        if (Flags.isDeprecated((int)modifiers)) {
            desc = this.getDeprecatedDescriptor(desc);
        }
        if (Flags.isStatic((int)modifiers)) {
            desc = this.getStaticDescriptor(desc);
        }
        return desc;
    }

    protected ImageDescriptor getDeprecatedDescriptor(ImageDescriptor descriptor) {
        return new JavaElementImageDescriptor(descriptor, 1024, JavaElementImageProvider.SMALL_SIZE);
    }

    protected ImageDescriptor getStaticDescriptor(ImageDescriptor descriptor) {
        return new JavaElementImageDescriptor(descriptor, 8, JavaElementImageProvider.SMALL_SIZE);
    }

    protected JavaCompletionProposal createCompletion(int start, int end, String completion, ImageDescriptor descriptor, String name, int relevance) {
        return new JavaCompletionProposal(completion, start, this.getLength(start, end), this.getImage(descriptor), name, relevance, this.fTextViewer);
    }

    private int getLength(int start, int end) {
        int length;
        if (this.fUserReplacementLength == -1) {
            length = this.fPreventEating ? this.fCodeAssistOffset - start : end - start;
        } else {
            length = this.fUserReplacementLength;
            if (start < this.fCodeAssistOffset) {
                length += this.fCodeAssistOffset - start;
            }
        }
        return length;
    }

    private Image getImage(ImageDescriptor descriptor) {
        return descriptor == null ? null : this.fRegistry.get(descriptor);
    }

    public void reset(int codeAssistOffset, int contextOffset, IJavaProject jproject, ICompilationUnit cu) {
        this.fJavaProject = jproject;
        this.fCompilationUnit = cu;
        this.fCodeAssistOffset = codeAssistOffset;
        this.fContextOffset = contextOffset;
        this.fUserReplacementLength = -1;
        this.fLastProblem = null;
        int i = 0;
        while (i < this.fResults.length) {
            this.fResults[i].clear();
            ++i;
        }
        this.fSuggestedMethodNames.clear();
    }

    public void reset(int codeAssistOffset, IJavaProject jproject, ICompilationUnit cu) {
        this.reset(codeAssistOffset, -1, jproject, cu);
    }

    public void setViewer(ITextViewer viewer) {
        this.fTextViewer = viewer;
    }

    public void setReplacementLength(int length) {
        this.fUserReplacementLength = length;
    }

    public void setPreventEating(boolean preventEating) {
        this.fPreventEating = preventEating;
    }
}

