/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.preferences.CompilerConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.CompilerPreferencePage;
import org.eclipse.jdt.internal.ui.preferences.PreferencePageSupport;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.help.WorkbenchHelp;

public class CompilerPropertyPage
extends PropertyPage {
    private CompilerConfigurationBlock fConfigurationBlock;
    private Control fConfigurationBlockControl;
    private ControlEnableState fBlockEnableState = null;
    private SelectionButtonDialogField fUseWorkspaceSettings;
    private SelectionButtonDialogField fChangeWorkspaceSettings;
    private SelectionButtonDialogField fUseProjectSettings;
    private IStatus fBlockStatus = new StatusInfo();
    static /* synthetic */ Class class$0;

    public CompilerPropertyPage() {
        IDialogFieldListener listener = new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                CompilerPropertyPage.this.doDialogFieldChanged(field);
            }
        };
        this.fUseWorkspaceSettings = new SelectionButtonDialogField(16);
        this.fUseWorkspaceSettings.setDialogFieldListener(listener);
        this.fUseWorkspaceSettings.setLabelText(PreferencesMessages.getString("CompilerPropertyPage.useworkspacesettings.label"));
        this.fChangeWorkspaceSettings = new SelectionButtonDialogField(8);
        this.fChangeWorkspaceSettings.setLabelText(PreferencesMessages.getString("CompilerPropertyPage.useworkspacesettings.change"));
        this.fChangeWorkspaceSettings.setDialogFieldListener(listener);
        this.fUseWorkspaceSettings.attachDialogField(this.fChangeWorkspaceSettings);
        this.fUseProjectSettings = new SelectionButtonDialogField(16);
        this.fUseProjectSettings.setDialogFieldListener(listener);
        this.fUseProjectSettings.setLabelText(PreferencesMessages.getString("CompilerPropertyPage.useprojectsettings.label"));
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.jdt.ui.compiler_property_page_context");
    }

    protected Control createContents(Composite parent) {
        IStatusChangeListener listener = new IStatusChangeListener(){

            public void statusChanged(IStatus status) {
                CompilerPropertyPage.this.fBlockStatus = status;
                CompilerPropertyPage.this.doStatusChanged();
            }
        };
        this.fConfigurationBlock = new CompilerConfigurationBlock(listener, this.getProject());
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.fUseWorkspaceSettings.doFillIntoGrid(composite, 1);
        LayoutUtil.setHorizontalGrabbing((Control)this.fUseWorkspaceSettings.getSelectionButton(null));
        this.fChangeWorkspaceSettings.doFillIntoGrid(composite, 1);
        this.fUseProjectSettings.doFillIntoGrid(composite, 2);
        GridData data = new GridData(272);
        data.horizontalSpan = 2;
        this.fConfigurationBlockControl = this.fConfigurationBlock.createContents(composite);
        this.fConfigurationBlockControl.setLayoutData((Object)data);
        boolean useProjectSettings = this.fConfigurationBlock.hasProjectSpecificOptions();
        this.fUseProjectSettings.setSelection(useProjectSettings);
        this.fUseWorkspaceSettings.setSelection(!useProjectSettings);
        this.updateEnableState();
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private boolean useProjectSettings() {
        return this.fUseProjectSettings.isSelected();
    }

    private void doDialogFieldChanged(DialogField field) {
        if (field == this.fChangeWorkspaceSettings) {
            String id = "org.eclipse.jdt.ui.preferences.CompilerPreferencePage";
            CompilerPreferencePage page = new CompilerPreferencePage();
            PreferencePageSupport.showPreferencePage(this.getShell(), id, (IPreferencePage)page);
        } else {
            this.updateEnableState();
            this.doStatusChanged();
        }
    }

    private void doStatusChanged() {
        this.updateStatus((IStatus)(this.useProjectSettings() ? this.fBlockStatus : new StatusInfo()));
    }

    private IJavaProject getProject() {
        IAdaptable iAdaptable = this.getElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IJavaProject)iAdaptable.getAdapter((Class)clazz);
    }

    private void updateEnableState() {
        if (this.useProjectSettings()) {
            if (this.fBlockEnableState != null) {
                this.fBlockEnableState.restore();
                this.fBlockEnableState = null;
            }
        } else if (this.fBlockEnableState == null) {
            this.fBlockEnableState = ControlEnableState.disable((Control)this.fConfigurationBlockControl);
        }
    }

    protected void performDefaults() {
        if (this.useProjectSettings()) {
            this.fUseProjectSettings.setSelection(false);
            this.fUseWorkspaceSettings.setSelection(true);
            this.fConfigurationBlock.performDefaults();
        }
        super.performDefaults();
    }

    public boolean performOk() {
        return this.fConfigurationBlock.performOk(this.useProjectSettings());
    }

    private void updateStatus(IStatus status) {
        this.setValid(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, status);
    }
}

