/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathsBlock;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class BuildPathDialog
extends StatusDialog {
    private IJavaProject fProject;
    private BuildPathsBlock fBlock;

    public BuildPathDialog(Shell parent, IJavaProject project) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        Assert.isNotNull((Object)project);
        this.fProject = project;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(JavaUIMessages.getFormattedString("BuildPathDialog.title", this.fProject.getElementName()));
    }

    protected Control createDialogArea(Composite parent) {
        IStatusChangeListener listener = new IStatusChangeListener(){

            public void statusChanged(IStatus status) {
                BuildPathDialog.this.updateStatus(status);
            }
        };
        Composite result = (Composite)super.createDialogArea(parent);
        this.fBlock = new BuildPathsBlock(listener, 0);
        this.fBlock.init(this.fProject, null, null);
        this.fBlock.createControl(result).setLayoutData((Object)new GridData(1808));
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.configureBuildPath();
        }
        super.buttonPressed(buttonId);
    }

    private void configureBuildPath() {
        Shell shell = this.getShell();
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
                BuildPathDialog.this.fBlock.configureJavaProject(monitor);
            }
        };
        WorkbenchRunnableAdapter op = new WorkbenchRunnableAdapter(runnable);
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            String title = PreferencesMessages.getString("BuildPathsPropertyPage.error.title");
            String message = PreferencesMessages.getString("BuildPathsPropertyPage.error.message");
            ExceptionHandler.handle(e, shell, title, message);
        }
        catch (InterruptedException interruptedException) {}
    }
}

