/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.browsing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.IWorkingCopy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.browsing.JavaBrowsingPart;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

class JavaBrowsingContentProvider
extends StandardJavaElementContentProvider
implements IElementChangedListener {
    private StructuredViewer fViewer;
    private Object fInput;
    private JavaBrowsingPart fBrowsingPart;
    private int fReadsInDisplayThread;

    public JavaBrowsingContentProvider(boolean provideMembers, JavaBrowsingPart browsingPart) {
        super(provideMembers);
        this.fBrowsingPart = browsingPart;
        this.fViewer = this.fBrowsingPart.getViewer();
        JavaCore.addElementChangedListener((IElementChangedListener)this);
    }

    public boolean hasChildren(Object element) {
        this.startReadInDisplayThread();
        try {
            boolean bl = super.hasChildren(element);
            Object var2_3 = null;
            this.finishedReadInDisplayThread();
            return bl;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.finishedReadInDisplayThread();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object[] getChildren(Object element) {
        Object[] objectArray;
        block16: {
            Object[] objectArray2;
            block15: {
                Object[] objectArray3;
                block14: {
                    Object[] objectArray4;
                    block13: {
                        Object[] objectArray5;
                        block12: {
                            if (!this.exists(element)) {
                                return StandardJavaElementContentProvider.NO_CHILDREN;
                            }
                            this.startReadInDisplayThread();
                            try {
                                try {
                                    if (element instanceof Collection) {
                                        Collection elements = (Collection)element;
                                        if (elements.isEmpty()) {
                                            Object[] objectArray6 = StandardJavaElementContentProvider.NO_CHILDREN;
                                            Object var6_11 = null;
                                            this.finishedReadInDisplayThread();
                                            return objectArray6;
                                        }
                                        Object[] result = new Object[]{};
                                        Iterator iter = ((Collection)element).iterator();
                                        while (true) {
                                            if (!iter.hasNext()) break;
                                            Object[] children = this.getChildren(iter.next());
                                            if (children == StandardJavaElementContentProvider.NO_CHILDREN) continue;
                                            result = StandardJavaElementContentProvider.concatenate(result, children);
                                        }
                                        Object[] objectArray7 = result;
                                        Object var6_12 = null;
                                        this.finishedReadInDisplayThread();
                                        return objectArray7;
                                    }
                                    if (element instanceof IPackageFragment) {
                                        objectArray5 = this.getPackageContents((IPackageFragment)element);
                                        break block12;
                                    }
                                    if (this.fProvideMembers && element instanceof IType) {
                                        objectArray4 = this.getChildren((IType)element);
                                        break block13;
                                    }
                                    if (this.fProvideMembers && element instanceof ISourceReference && element instanceof IParent) {
                                        objectArray3 = this.removeImportAndPackageDeclarations(super.getChildren(element));
                                        break block14;
                                    }
                                    if (element instanceof IJavaProject) {
                                        objectArray2 = this.getPackageFragmentRoots((IJavaProject)element);
                                        break block15;
                                    }
                                    objectArray = super.getChildren(element);
                                    break block16;
                                }
                                catch (JavaModelException javaModelException) {
                                    Object[] objectArray8 = StandardJavaElementContentProvider.NO_CHILDREN;
                                    Object var6_18 = null;
                                    this.finishedReadInDisplayThread();
                                    return objectArray8;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var6_19 = null;
                                this.finishedReadInDisplayThread();
                                throw throwable;
                            }
                        }
                        Object var6_13 = null;
                        this.finishedReadInDisplayThread();
                        return objectArray5;
                    }
                    Object var6_14 = null;
                    this.finishedReadInDisplayThread();
                    return objectArray4;
                }
                Object var6_15 = null;
                this.finishedReadInDisplayThread();
                return objectArray3;
            }
            Object var6_16 = null;
            this.finishedReadInDisplayThread();
            return objectArray2;
        }
        Object var6_17 = null;
        this.finishedReadInDisplayThread();
        return objectArray;
    }

    private Object[] getPackageContents(IPackageFragment fragment) throws JavaModelException {
        ICompilationUnit[] sourceRefs;
        if (fragment.getKind() == 1) {
            sourceRefs = fragment.getCompilationUnits();
        } else {
            IClassFile[] classFiles = fragment.getClassFiles();
            ArrayList<IClassFile> topLevelClassFile = new ArrayList<IClassFile>();
            int i = 0;
            while (i < classFiles.length) {
                IType type = classFiles[i].getType();
                if (type != null && type.getDeclaringType() == null && !type.isAnonymous() && !type.isLocal()) {
                    topLevelClassFile.add(classFiles[i]);
                }
                ++i;
            }
            sourceRefs = topLevelClassFile.toArray(new ISourceReference[topLevelClassFile.size()]);
        }
        Object[] result = new Object[]{};
        int i = 0;
        while (i < sourceRefs.length) {
            result = StandardJavaElementContentProvider.concatenate(result, this.removeImportAndPackageDeclarations(this.getChildren(sourceRefs[i])));
            ++i;
        }
        return StandardJavaElementContentProvider.concatenate(result, fragment.getNonJavaResources());
    }

    private Object[] removeImportAndPackageDeclarations(Object[] members) {
        ArrayList<Object> tempResult = new ArrayList<Object>(members.length);
        int i = 0;
        while (i < members.length) {
            if (!(members[i] instanceof IImportContainer) && !(members[i] instanceof IPackageDeclaration)) {
                tempResult.add(members[i]);
            }
            ++i;
        }
        return tempResult.toArray();
    }

    private Object[] getChildren(IType type) throws JavaModelException {
        Object parent = type.isBinary() ? type.getClassFile() : type.getCompilationUnit();
        if (type.getDeclaringType() != null) {
            return type.getChildren();
        }
        IJavaElement[] members = parent.getChildren();
        ArrayList<IJavaElement> tempResult = new ArrayList<IJavaElement>(members.length);
        int i = 0;
        while (i < members.length) {
            if (members[i] instanceof IImportContainer) {
                tempResult.add(members[i]);
            }
            ++i;
        }
        tempResult.addAll(Arrays.asList(type.getChildren()));
        return tempResult.toArray();
    }

    protected Object[] getPackageFragmentRoots(IJavaProject project) throws JavaModelException {
        if (!project.getProject().isOpen()) {
            return StandardJavaElementContentProvider.NO_CHILDREN;
        }
        IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
        ArrayList<Object> list = new ArrayList<Object>(roots.length);
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            if (!root.isExternal()) {
                IJavaElement[] children = root.getChildren();
                int k = 0;
                while (k < children.length) {
                    list.add(children[k]);
                    ++k;
                }
            } else if (this.hasChildren(root)) {
                list.add(root);
            }
            ++i;
        }
        return StandardJavaElementContentProvider.concatenate(list.toArray(), project.getNonJavaResources());
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        if (newInput instanceof Collection) {
            Collection col = (Collection)newInput;
            newInput = !col.isEmpty() ? col.iterator().next() : null;
        }
        this.fInput = newInput;
    }

    public void dispose() {
        super.dispose();
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
    }

    public void elementChanged(ElementChangedEvent event) {
        try {
            this.processDelta(event.getDelta());
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e.getStatus());
        }
    }

    protected void processDelta(IJavaElementDelta delta) throws JavaModelException {
        IJavaElementDelta[] affectedChildren;
        IJavaElement inputsParent;
        IPackageFragmentRoot pkgRoot;
        int kind = delta.getKind();
        int flags = delta.getFlags();
        IJavaElement element = delta.getElement();
        boolean isElementValidForView = this.fBrowsingPart.isValidElement(element);
        if (!this.getProvideWorkingCopy() && element instanceof IWorkingCopy && ((IWorkingCopy)element).isWorkingCopy()) {
            return;
        }
        if (element != null && element.getElementType() == 5 && !this.isOnClassPath((ICompilationUnit)element)) {
            return;
        }
        if ((flags & 0x400) != 0 || (flags & 0x200) != 0) {
            this.postRefresh(element);
            return;
        }
        if (kind == 2) {
            Object parent = this.internalGetParent(element);
            if (isElementValidForView) {
                if (element instanceof IClassFile) {
                    this.postRemove(((IClassFile)element).getType());
                } else if (element instanceof ICompilationUnit && !((ICompilationUnit)element).isWorkingCopy()) {
                    this.postRefresh(null);
                } else if (element instanceof ICompilationUnit && ((ICompilationUnit)element).isWorkingCopy()) {
                    if (this.getProvideWorkingCopy()) {
                        this.postRefresh(null);
                    }
                } else if (parent instanceof ICompilationUnit && this.getProvideWorkingCopy() && !((ICompilationUnit)parent).isWorkingCopy()) {
                    if (element instanceof IWorkingCopy && ((IWorkingCopy)element).isWorkingCopy()) {
                        this.postRefresh(null);
                    }
                } else if (element instanceof IWorkingCopy && ((IWorkingCopy)element).isWorkingCopy() && parent != null && parent.equals(this.fInput)) {
                    this.postRefresh(null);
                } else {
                    this.postRemove(element);
                }
            }
            if (this.fBrowsingPart.isAncestorOf(element, this.fInput)) {
                if (element instanceof IWorkingCopy && ((IWorkingCopy)element).isWorkingCopy()) {
                    this.postAdjustInputAndSetSelection(JavaModelUtil.toOriginal((IJavaElement)this.fInput));
                } else {
                    this.postAdjustInputAndSetSelection(null);
                }
            }
            if (this.fInput != null && this.fInput.equals(element)) {
                this.postRefresh(null);
            }
            if (parent instanceof IPackageFragment && this.fBrowsingPart.isValidElement(parent) && this.isPackageFragmentEmpty((IJavaElement)((IPackageFragment)parent)) && this.fViewer.testFindItem(parent) != null) {
                this.postRefresh(null);
            }
            return;
        }
        if (kind == 1 && delta.getMovedFromElement() != null && element instanceof ICompilationUnit) {
            return;
        }
        if (kind == 1) {
            if (isElementValidForView) {
                Object parent = this.internalGetParent(element);
                if (element instanceof IClassFile) {
                    this.postAdd(parent, ((IClassFile)element).getType());
                } else if (element instanceof ICompilationUnit && !((ICompilationUnit)element).isWorkingCopy()) {
                    this.postAdd(parent, ((ICompilationUnit)element).getTypes());
                } else if (!(parent instanceof ICompilationUnit) || !this.getProvideWorkingCopy() || ((ICompilationUnit)parent).isWorkingCopy()) {
                    if (element instanceof IWorkingCopy && ((IWorkingCopy)element).isWorkingCopy()) {
                        this.postRefresh(null);
                    } else {
                        this.postAdd(parent, element);
                    }
                }
            } else if (this.fInput == null) {
                IJavaElement newInput = this.fBrowsingPart.findInputForJavaElement(element);
                if (newInput != null) {
                    this.postAdjustInputAndSetSelection(element);
                }
            } else if (element instanceof IType && this.fBrowsingPart.isValidInput(element)) {
                IJavaElement cu1 = element.getAncestor(5);
                IJavaElement cu2 = ((IJavaElement)this.fInput).getAncestor(5);
                if (cu1 != null && cu2 != null && cu1.equals(cu2)) {
                    this.postAdjustInputAndSetSelection(element);
                }
            }
            return;
        }
        if (kind == 4) {
            if (this.fInput != null && this.fInput.equals(element) && (flags & 8) != 0 && (flags & 0x4000) != 0) {
                this.postRefresh(null, true);
                return;
            }
            if (isElementValidForView && (flags & 2) != 0) {
                this.postUpdateIcon(element);
            }
        }
        if (this.isClassPathChange(delta)) {
            this.postRefresh(null);
        }
        if ((flags & 0x8000) != 0 && this.fInput instanceof IJavaElement && (pkgRoot = (IPackageFragmentRoot)element).equals(inputsParent = ((IJavaElement)this.fInput).getAncestor(3))) {
            this.postRefresh(null);
        }
        if (element instanceof IPackageFragmentRoot && ((flags & 0x1000) != 0 || (flags & 0x2000) != 0)) {
            this.postUpdateIcon(element);
        }
        if ((affectedChildren = delta.getAffectedChildren()).length > 1) {
            if (element instanceof IPackageFragment) {
                IJavaElement parent = (IJavaElement)this.internalGetParent(element);
                if (element.equals(this.fInput)) {
                    this.postRefresh(element);
                } else {
                    this.postRefresh(parent);
                }
            }
            if (element instanceof IPackageFragmentRoot && isElementValidForView) {
                this.postRefresh(this.skipProjectPackageFragmentRoot((IPackageFragmentRoot)element));
                return;
            }
        }
        int i = 0;
        while (i < affectedChildren.length) {
            this.processDelta(affectedChildren[i]);
            ++i;
        }
    }

    private boolean isOnClassPath(ICompilationUnit element) throws JavaModelException {
        IJavaProject project = element.getJavaProject();
        if (project == null || !project.exists()) {
            return false;
        }
        return project.isOnClasspath((IJavaElement)element);
    }

    private void postUpdateIcon(final IJavaElement element) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = JavaBrowsingContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    JavaBrowsingContentProvider.this.fViewer.update((Object)element, new String[]{"org.eclipse.jface.image"});
                }
            }
        });
    }

    private void postRefresh(final Object root, boolean updateLabels) {
        if (!updateLabels) {
            this.postRefresh(root);
            return;
        }
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = JavaBrowsingContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    JavaBrowsingContentProvider.this.fViewer.refresh(root, true);
                }
            }
        });
    }

    private void postRefresh(final Object root) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = JavaBrowsingContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    JavaBrowsingContentProvider.this.fViewer.refresh(root, false);
                }
            }
        });
    }

    private void postAdd(Object parent, Object element) {
        this.postAdd(parent, new Object[]{element});
    }

    private void postAdd(final Object parent, final Object[] elements) {
        if (elements == null || elements.length <= 0) {
            return;
        }
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = JavaBrowsingContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    Object[] newElements = JavaBrowsingContentProvider.this.getNewElements(elements);
                    if (JavaBrowsingContentProvider.this.fViewer instanceof AbstractTreeViewer) {
                        if (JavaBrowsingContentProvider.this.fViewer.testFindItem(parent) == null) {
                            Object root = ((AbstractTreeViewer)JavaBrowsingContentProvider.this.fViewer).getInput();
                            if (root != null) {
                                ((AbstractTreeViewer)JavaBrowsingContentProvider.this.fViewer).add(root, newElements);
                            }
                        } else {
                            ((AbstractTreeViewer)JavaBrowsingContentProvider.this.fViewer).add(parent, newElements);
                        }
                    } else if (JavaBrowsingContentProvider.this.fViewer instanceof ListViewer) {
                        ((ListViewer)JavaBrowsingContentProvider.this.fViewer).add(newElements);
                    } else if (JavaBrowsingContentProvider.this.fViewer instanceof TableViewer) {
                        ((TableViewer)JavaBrowsingContentProvider.this.fViewer).add(newElements);
                    }
                    if (JavaBrowsingContentProvider.this.fViewer.testFindItem(elements[0]) != null) {
                        JavaBrowsingContentProvider.this.fBrowsingPart.adjustInputAndSetSelection(elements[0]);
                    }
                }
            }
        });
    }

    private Object[] getNewElements(Object[] elements) {
        int elementsLength = elements.length;
        ArrayList<Object> result = new ArrayList<Object>(elementsLength);
        int i = 0;
        while (i < elementsLength) {
            Object element = elements[i];
            if (this.fViewer.testFindItem(element) == null) {
                result.add(element);
            }
            ++i;
        }
        return result.toArray();
    }

    private void postRemove(Object element) {
        this.postRemove(new Object[]{element});
    }

    private void postRemove(final Object[] elements) {
        if (elements.length <= 0) {
            return;
        }
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = JavaBrowsingContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    if (JavaBrowsingContentProvider.this.fViewer instanceof AbstractTreeViewer) {
                        ((AbstractTreeViewer)JavaBrowsingContentProvider.this.fViewer).remove(elements);
                    } else if (JavaBrowsingContentProvider.this.fViewer instanceof ListViewer) {
                        ((ListViewer)JavaBrowsingContentProvider.this.fViewer).remove(elements);
                    } else if (JavaBrowsingContentProvider.this.fViewer instanceof TableViewer) {
                        ((TableViewer)JavaBrowsingContentProvider.this.fViewer).remove(elements);
                    }
                }
            }
        });
    }

    private void postAdjustInputAndSetSelection(final Object element) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = JavaBrowsingContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    ctrl.setRedraw(false);
                    JavaBrowsingContentProvider.this.fBrowsingPart.adjustInputAndSetSelection(element);
                    ctrl.setRedraw(true);
                }
            }
        });
    }

    protected void startReadInDisplayThread() {
        if (this.isDisplayThread()) {
            ++this.fReadsInDisplayThread;
        }
    }

    protected void finishedReadInDisplayThread() {
        if (this.isDisplayThread()) {
            --this.fReadsInDisplayThread;
        }
    }

    private boolean isDisplayThread() {
        Control ctrl = this.fViewer.getControl();
        if (ctrl == null) {
            return false;
        }
        Display currentDisplay = Display.getCurrent();
        return currentDisplay != null && currentDisplay.equals(ctrl.getDisplay());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void postRunnable(Runnable r) {
        Control ctrl = this.fViewer.getControl();
        if (ctrl == null) return;
        if (ctrl.isDisposed()) return;
        this.fBrowsingPart.setProcessSelectionEvents(false);
        try {
            if (this.isDisplayThread() && this.fReadsInDisplayThread == 0) {
                ctrl.getDisplay().syncExec(r);
            } else {
                ctrl.getDisplay().asyncExec(r);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.fBrowsingPart.setProcessSelectionEvents(true);
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.fBrowsingPart.setProcessSelectionEvents(true);
            return;
        }
    }

    protected Object internalGetParent(Object element) {
        if (element instanceof IJavaProject) {
            return ((IJavaProject)element).getJavaModel();
        }
        if (element instanceof IResource) {
            IContainer parent = ((IResource)element).getParent();
            IJavaElement jParent = JavaCore.create((IResource)parent);
            if (jParent != null) {
                return jParent;
            }
            return parent;
        }
        if (element instanceof IPackageFragment) {
            IPackageFragmentRoot parent = (IPackageFragmentRoot)((IPackageFragment)element).getParent();
            return this.skipProjectPackageFragmentRoot(parent);
        }
        if (element instanceof IJavaElement) {
            return ((IJavaElement)element).getParent();
        }
        return null;
    }
}

