/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.HierarchicalASTVisitor;
import org.eclipse.jdt.internal.corext.dom.OldASTRewrite;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.code.NameCollector;
import org.eclipse.jdt.internal.corext.refactoring.code.TempAssignmentFinder;
import org.eclipse.jdt.internal.corext.refactoring.rename.TempDeclarationFinder;
import org.eclipse.jdt.internal.corext.refactoring.rename.TempOccurrenceAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class PromoteTempToFieldRefactoring
extends Refactoring {
    private final int fSelectionStart;
    private final int fSelectionLength;
    private final ICompilationUnit fCu;
    public static final int INITIALIZE_IN_FIELD = 0;
    public static final int INITIALIZE_IN_METHOD = 1;
    public static final int INITIALIZE_IN_CONSTRUCTOR = 2;
    private String fFieldName;
    private int fVisibility;
    private boolean fDeclareStatic;
    private boolean fDeclareFinal;
    private int fInitializeIn;
    private CompilationUnit fCompilationUnitNode;
    private VariableDeclaration fTempDeclarationNode;
    private final CodeGenerationSettings fCodeGenerationSettings;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    private PromoteTempToFieldRefactoring(ICompilationUnit cu, int selectionStart, int selectionLength, CodeGenerationSettings codeGenerationSettings) {
        Assert.isTrue(selectionStart >= 0);
        Assert.isTrue(selectionLength >= 0);
        Assert.isTrue(cu.exists());
        Assert.isNotNull(codeGenerationSettings);
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fCu = cu;
        this.fFieldName = "";
        this.fVisibility = 2;
        this.fDeclareStatic = false;
        this.fDeclareFinal = false;
        this.fInitializeIn = 1;
        this.fCodeGenerationSettings = codeGenerationSettings;
    }

    public static boolean isAvailable(ILocalVariable variable) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)variable);
    }

    public static PromoteTempToFieldRefactoring create(ICompilationUnit cu, int selectionStart, int selectionLength, CodeGenerationSettings codeGenerationSettings) {
        return new PromoteTempToFieldRefactoring(cu, selectionStart, selectionLength, codeGenerationSettings);
    }

    public String getName() {
        return RefactoringCoreMessages.getString("PromoteTempToFieldRefactoring.name");
    }

    public int[] getAvailableVisibilities() {
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[1] = 4;
        nArray[3] = 2;
        return nArray;
    }

    public int getVisibility() {
        return this.fVisibility;
    }

    public boolean getDeclareFinal() {
        return this.fDeclareFinal;
    }

    public boolean getDeclareStatic() {
        return this.fDeclareStatic;
    }

    public String getFieldName() {
        return this.fFieldName;
    }

    public int getInitializeIn() {
        return this.fInitializeIn;
    }

    public void setVisibility(int accessModifier) {
        Assert.isTrue(accessModifier == 2 || accessModifier == 0 || accessModifier == 4 || accessModifier == 1);
        this.fVisibility = accessModifier;
    }

    public void setDeclareFinal(boolean declareFinal) {
        this.fDeclareFinal = declareFinal;
    }

    public void setDeclareStatic(boolean declareStatic) {
        this.fDeclareStatic = declareStatic;
    }

    public void setFieldName(String fieldName) {
        Assert.isNotNull(fieldName);
        this.fFieldName = fieldName;
    }

    public void setInitializeIn(int initializeIn) {
        Assert.isTrue(initializeIn == 2 || initializeIn == 0 || initializeIn == 1);
        this.fInitializeIn = initializeIn;
    }

    public boolean canEnableSettingStatic() {
        return this.fInitializeIn != 2 && !this.isTempDeclaredInStaticMethod();
    }

    public boolean canEnableSettingFinal() {
        if (this.fInitializeIn == 2) {
            return this.canEnableSettingDeclareInConstructors() && !this.tempHasAssignmentsOtherThanInitialization();
        }
        if (this.fInitializeIn == 0) {
            return this.canEnableSettingDeclareInFieldDeclaration() && !this.tempHasAssignmentsOtherThanInitialization();
        }
        return false;
    }

    private boolean tempHasAssignmentsOtherThanInitialization() {
        TempAssignmentFinder assignmentFinder = new TempAssignmentFinder(this.fTempDeclarationNode);
        this.fCompilationUnitNode.accept((ASTVisitor)assignmentFinder);
        return assignmentFinder.hasAssignments();
    }

    public boolean canEnableSettingDeclareInConstructors() {
        return !this.fDeclareStatic && !this.getMethodDeclaration().isConstructor() && !this.isDeclaredInAnonymousClass() && !this.isTempDeclaredInStaticMethod() && this.tempHasInitializer();
    }

    public boolean canEnableSettingDeclareInMethod() {
        return !this.fDeclareFinal && this.tempHasInitializer();
    }

    private boolean tempHasInitializer() {
        return this.getTempInitializer() != null;
    }

    public boolean canEnableSettingDeclareInFieldDeclaration() {
        return this.tempHasInitializer();
    }

    private Expression getTempInitializer() {
        return this.fTempDeclarationNode.getInitializer();
    }

    private boolean isTempDeclaredInStaticMethod() {
        return Modifier.isStatic((int)this.getMethodDeclaration().getModifiers());
    }

    private MethodDeclaration getMethodDeclaration() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.MethodDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (MethodDeclaration)ASTNodes.getParent((ASTNode)this.fTempDeclarationNode, clazz);
    }

    private boolean isDeclaredInAnonymousClass() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jdt.core.dom.AnonymousClassDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return ASTNodes.getParent((ASTNode)this.fTempDeclarationNode, clazz) != null;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = Checks.validateModifiesFiles(ResourceUtil.getFiles(new ICompilationUnit[]{this.fCu}), this.getValidationContext());
        if (result.hasFatalError()) {
            return result;
        }
        this.initAST(pm);
        if (this.fTempDeclarationNode == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("PromoteTempToFieldRefactoring.select_declaration"));
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.MethodDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!Checks.isDeclaredIn(this.fTempDeclarationNode, clazz)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("PromoteTempToFieldRefactoring.only_declared_in_methods"));
        }
        if (this.isMethodParameter()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("PromoteTempToFieldRefactoring.method_parameters"));
        }
        if (this.isTempAnExceptionInCatchBlock()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("PromoteTempToFieldRefactoring.exceptions"));
        }
        result.merge(this.checkTempTypeForLocalTypeUsage());
        if (result.hasFatalError()) {
            return result;
        }
        this.initializeDefaults();
        return result;
    }

    private void initializeDefaults() {
        this.fVisibility = 2;
        this.fDeclareStatic = Modifier.isStatic((int)this.getMethodDeclaration().getModifiers());
        this.fDeclareFinal = false;
        if (this.canEnableSettingDeclareInMethod()) {
            this.fInitializeIn = 1;
        } else if (this.canEnableSettingDeclareInFieldDeclaration()) {
            this.fInitializeIn = 0;
        } else if (this.canEnableSettingDeclareInConstructors()) {
            this.fInitializeIn = 2;
        }
        this.fFieldName = this.getInitialFieldName();
    }

    public String[] guessFieldNames() {
        String tempName = this.fTempDeclarationNode.getName().getIdentifier();
        String rawTempName = NamingConventions.removePrefixAndSuffixForLocalVariableName((IJavaProject)this.fCu.getJavaProject(), (String)tempName);
        String[] excludedNames = this.getNamesOfFieldsInDeclaringType();
        int dim = this.getTempTypeArrayDimensions();
        String[] suggestedNames = StubUtility.getFieldNameSuggestions(this.fCu.getJavaProject(), rawTempName, dim, this.getModifiers(), excludedNames);
        return suggestedNames;
    }

    private String getInitialFieldName() {
        String[] suggestedNames = this.guessFieldNames();
        if (suggestedNames.length > 0) {
            String longest = suggestedNames[0];
            int i = 1;
            while (i < suggestedNames.length) {
                if (suggestedNames[i].length() > longest.length()) {
                    longest = suggestedNames[i];
                }
                ++i;
            }
            return longest;
        }
        return this.fTempDeclarationNode.getName().getIdentifier();
    }

    private String[] getNamesOfFieldsInDeclaringType() {
        TypeDeclaration type = this.getEnclosingType();
        FieldDeclaration[] fields = type.getFields();
        ArrayList<String> result = new ArrayList<String>(fields.length);
        int i = 0;
        while (i < fields.length) {
            Iterator iter = fields[i].fragments().iterator();
            while (iter.hasNext()) {
                VariableDeclarationFragment field = (VariableDeclarationFragment)iter.next();
                result.add(field.getName().getIdentifier());
            }
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    private int getTempTypeArrayDimensions() {
        int dim = 0;
        Type tempType = this.getTempDeclarationStatement().getType();
        if (tempType.isArrayType()) {
            dim += ((ArrayType)tempType).getDimensions();
        }
        return dim += this.fTempDeclarationNode.getExtraDimensions();
    }

    private RefactoringStatus checkTempInitializerForLocalTypeUsage() {
        Expression initializer = this.fTempDeclarationNode.getInitializer();
        if (initializer == null) {
            return null;
        }
        LocalTypeAndVariableUsageAnalyzer localTypeAnalyer = new LocalTypeAndVariableUsageAnalyzer();
        initializer.accept((ASTVisitor)localTypeAnalyer);
        if (!localTypeAnalyer.getUsageOfEnclosingNodes().isEmpty()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("PromoteTempToFieldRefactoring.uses_types_declared_locally"));
        }
        return null;
    }

    private RefactoringStatus checkTempTypeForLocalTypeUsage() {
        VariableDeclarationStatement vds = this.getTempDeclarationStatement();
        if (vds == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("PromoteTempToFieldRefactoring.cannot_promote"));
        }
        Type type = vds.getType();
        ITypeBinding binding = type.resolveBinding();
        if (binding == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("PromoteTempToFieldRefactoring.cannot_promote"));
        }
        if (binding.isLocal()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("PromoteTempToFieldRefactoring.uses_type_declared_locally"));
        }
        return null;
    }

    private VariableDeclarationStatement getTempDeclarationStatement() {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jdt.core.dom.VariableDeclarationStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (VariableDeclarationStatement)ASTNodes.getParent((ASTNode)this.fTempDeclarationNode, clazz);
    }

    private boolean isTempAnExceptionInCatchBlock() {
        return this.fTempDeclarationNode.getParent() instanceof CatchClause;
    }

    private boolean isMethodParameter() {
        return this.fTempDeclarationNode.getParent() instanceof MethodDeclaration;
    }

    private void initAST(IProgressMonitor pm) {
        this.fCompilationUnitNode = new RefactoringASTParser(2).parse(this.fCu, true, pm);
        this.fTempDeclarationNode = TempDeclarationFinder.findTempDeclaration(this.fCompilationUnitNode, this.fSelectionStart, this.fSelectionLength);
    }

    public RefactoringStatus validateInput() {
        return Checks.checkFieldName(this.fFieldName);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result;
        block5: {
            RefactoringStatus refactoringStatus;
            try {
                result = new RefactoringStatus();
                if (this.fInitializeIn != 1) {
                    result.merge(this.checkTempInitializerForLocalTypeUsage());
                }
                if (!result.hasFatalError()) break block5;
                refactoringStatus = result;
                Object var3_5 = null;
            }
            catch (Throwable throwable) {
                Object var3_7 = null;
                pm.done();
                throw throwable;
            }
            pm.done();
            return refactoringStatus;
        }
        result.merge(this.checkClashesWithExistingFields());
        if (this.fInitializeIn == 2) {
            result.merge(this.checkClashesInConstructors());
        }
        RefactoringStatus refactoringStatus = result;
        Object var3_6 = null;
        pm.done();
        return refactoringStatus;
    }

    private RefactoringStatus checkClashesInConstructors() {
        Assert.isTrue(this.fInitializeIn == 2);
        Assert.isTrue(!this.isDeclaredInAnonymousClass());
        TypeDeclaration declaringType = (TypeDeclaration)this.getMethodDeclaration().getParent();
        MethodDeclaration[] methods = declaringType.getMethods();
        int i = 0;
        while (i < methods.length) {
            MethodDeclaration method = methods[i];
            if (method.isConstructor()) {
                NameCollector nameCollector = new NameCollector((ASTNode)method){

                    protected boolean visitNode(ASTNode node) {
                        return true;
                    }
                };
                method.accept((ASTVisitor)nameCollector);
                List names = nameCollector.getNames();
                if (names.contains(this.fFieldName)) {
                    String[] keys = new String[]{this.fFieldName, Bindings.asString((IBinding)method.resolveBinding())};
                    String msg = RefactoringCoreMessages.getFormattedString("PromoteTempToFieldRefactoring.Name_conflict", keys);
                    return RefactoringStatus.createFatalErrorStatus((String)msg);
                }
            }
            ++i;
        }
        return null;
    }

    private RefactoringStatus checkClashesWithExistingFields() {
        FieldDeclaration[] existingFields = this.getFieldDeclarationsInDeclaringType();
        int i = 0;
        while (i < existingFields.length) {
            FieldDeclaration declaration = existingFields[i];
            VariableDeclarationFragment[] fragments = declaration.fragments().toArray(new VariableDeclarationFragment[declaration.fragments().size()]);
            int j = 0;
            while (j < fragments.length) {
                VariableDeclarationFragment fragment = fragments[j];
                if (this.fFieldName.equals(fragment.getName().getIdentifier())) {
                    RefactoringStatusContext context = JavaStatusContext.create(this.fCu, (ASTNode)fragment);
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("PromoteTempToFieldRefactoring.Name_conflict_with_field"), (RefactoringStatusContext)context);
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private FieldDeclaration[] getFieldDeclarationsInDeclaringType() {
        return PromoteTempToFieldRefactoring.getFieldDeclarations(this.getBodyDeclarationListOfDeclaringType());
    }

    private List getBodyDeclarationListOfDeclaringType() {
        ASTNode methodParent = this.getMethodDeclaration().getParent();
        if (methodParent instanceof TypeDeclaration) {
            return ((TypeDeclaration)methodParent).bodyDeclarations();
        }
        if (methodParent instanceof AnonymousClassDeclaration) {
            return ((AnonymousClassDeclaration)methodParent).bodyDeclarations();
        }
        Assert.isTrue(false);
        return null;
    }

    private static FieldDeclaration[] getFieldDeclarations(List bodyDeclarations) {
        ArrayList fields = new ArrayList(1);
        Iterator iter = bodyDeclarations.iterator();
        while (iter.hasNext()) {
            Object each = iter.next();
            if (!(each instanceof FieldDeclaration)) continue;
            fields.add(each);
        }
        return fields.toArray(new FieldDeclaration[fields.size()]);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        Change change;
        pm.beginTask("", 1);
        try {
            OldASTRewrite rewrite = new OldASTRewrite((ASTNode)this.fCompilationUnitNode);
            this.addFieldDeclaration(rewrite);
            if (this.fInitializeIn == 1 && this.tempHasInitializer()) {
                this.addLocalDeclarationSplit(rewrite);
            } else {
                this.addLocalDeclarationRemoval(rewrite);
            }
            if (this.fInitializeIn == 2) {
                this.addInitializersToConstructors(rewrite);
            }
            if (!this.fFieldName.equals(this.fTempDeclarationNode.getName().getIdentifier())) {
                this.addTempRenames(rewrite);
            }
            change = this.createChange(rewrite);
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return change;
    }

    private void addTempRenames(OldASTRewrite rewrite) {
        TempOccurrenceAnalyzer analyzer = new TempOccurrenceAnalyzer(this.fTempDeclarationNode, false);
        analyzer.perform();
        SimpleName[] tempRefs = analyzer.getReferenceNodes();
        int j = 0;
        while (j < tempRefs.length) {
            SimpleName occurence = tempRefs[j];
            SimpleName newName = this.getAST().newSimpleName(this.fFieldName);
            rewrite.replace((ASTNode)occurence, (ASTNode)newName, null);
            ++j;
        }
    }

    private void addInitializersToConstructors(OldASTRewrite rewrite) throws CoreException {
        Assert.isTrue(!this.isDeclaredInAnonymousClass());
        TypeDeclaration typeDeclaration = (TypeDeclaration)this.getMethodDeclaration().getParent();
        MethodDeclaration[] allConstructors = PromoteTempToFieldRefactoring.getAllConstructors(typeDeclaration);
        if (allConstructors.length == 0) {
            this.addNewConstructorWithInitializing(rewrite, typeDeclaration);
        } else {
            int i = 0;
            while (i < allConstructors.length) {
                MethodDeclaration constructor = allConstructors[i];
                if (PromoteTempToFieldRefactoring.shouldInsertTempInitialization(constructor)) {
                    this.addFieldInitializationToConstructor(rewrite, constructor);
                }
                ++i;
            }
        }
    }

    private void addNewConstructorWithInitializing(OldASTRewrite rewrite, TypeDeclaration typeDeclaration) throws CoreException {
        String constructorSource = CodeFormatterUtil.format(4, this.getNewConstructorSource(typeDeclaration), 0, null, this.getLineSeperator(), this.fCu.getJavaProject());
        BodyDeclaration newConstructor = (BodyDeclaration)rewrite.createStringPlaceholder(constructorSource, 31);
        rewrite.markAsInserted((ASTNode)newConstructor);
        int constructorInsertIndex = this.computeInsertIndexForNewConstructor(typeDeclaration);
        typeDeclaration.bodyDeclarations().add(constructorInsertIndex, newConstructor);
    }

    private String getEnclosingTypeName() {
        return this.getEnclosingType().getName().getIdentifier();
    }

    private TypeDeclaration getEnclosingType() {
        VariableDeclarationStatement variableDeclarationStatement = this.getTempDeclarationStatement();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.jdt.core.dom.TypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (TypeDeclaration)ASTNodes.getParent((ASTNode)variableDeclarationStatement, clazz);
    }

    private String getNewConstructorSource(TypeDeclaration typeDeclaration) throws CoreException {
        String lineDelimiter = this.getLineSeperator();
        String bodyStatement = String.valueOf(this.fFieldName) + '=' + this.getTempInitializerCode() + ';';
        String constructorBody = CodeGeneration.getMethodBodyContent(this.fCu, this.getEnclosingTypeName(), this.getEnclosingTypeName(), true, bodyStatement, lineDelimiter);
        if (constructorBody == null) {
            constructorBody = "";
        }
        return String.valueOf(this.getNewConstructorComment()) + PromoteTempToFieldRefactoring.getModifierStringForDefaultConstructor(typeDeclaration) + ' ' + this.getEnclosingTypeName() + '(' + "){" + lineDelimiter + constructorBody + lineDelimiter + '}';
    }

    private String getLineSeperator() {
        try {
            return StubUtility.getLineDelimiterUsed((IJavaElement)this.fCu);
        }
        catch (JavaModelException javaModelException) {
            return System.getProperty("line.separator", "\n");
        }
    }

    private String getNewConstructorComment() throws CoreException {
        if (this.fCodeGenerationSettings.createComments) {
            String comment = CodeGeneration.getMethodComment(this.fCu, this.getEnclosingTypeName(), this.getEnclosingTypeName(), new String[0], new String[0], null, null, this.getLineSeperator());
            if (comment == null) {
                return "";
            }
            return String.valueOf(comment) + this.getLineSeperator();
        }
        return "";
    }

    private int computeInsertIndexForNewConstructor(TypeDeclaration typeDeclaration) {
        List bodyDeclarations = typeDeclaration.bodyDeclarations();
        if (bodyDeclarations.isEmpty()) {
            return 0;
        }
        int firstMethodIndex = this.findFirstMethodIndex(typeDeclaration);
        if (firstMethodIndex == -1) {
            return bodyDeclarations.size();
        }
        return firstMethodIndex;
    }

    private int findFirstMethodIndex(TypeDeclaration typeDeclaration) {
        int i = 0;
        int n = typeDeclaration.bodyDeclarations().size();
        while (i < n) {
            if (typeDeclaration.bodyDeclarations().get(i) instanceof MethodDeclaration) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void addFieldInitializationToConstructor(OldASTRewrite rewrite, MethodDeclaration constructor) throws JavaModelException {
        if (constructor.getBody() == null) {
            constructor.setBody(this.getAST().newBlock());
        }
        List statements = constructor.getBody().statements();
        ExpressionStatement initialization = this.createExpressionStatementThatInitializesField(rewrite);
        rewrite.markAsInserted((ASTNode)initialization);
        statements.add(initialization);
    }

    private static String getModifierStringForDefaultConstructor(TypeDeclaration typeDeclaration) {
        return JdtFlags.getVisibilityString(typeDeclaration.getModifiers());
    }

    private static boolean shouldInsertTempInitialization(MethodDeclaration constructor) {
        Assert.isTrue(constructor.isConstructor());
        if (constructor.getBody() == null) {
            return false;
        }
        List statements = constructor.getBody().statements();
        if (statements == null) {
            return false;
        }
        return statements.size() <= 0 || !(statements.get(0) instanceof ConstructorInvocation);
    }

    private static MethodDeclaration[] getAllConstructors(TypeDeclaration typeDeclaration) {
        MethodDeclaration[] allMethods = typeDeclaration.getMethods();
        ArrayList<MethodDeclaration> result = new ArrayList<MethodDeclaration>(Math.min(allMethods.length, 1));
        int i = 0;
        while (i < allMethods.length) {
            MethodDeclaration declaration = allMethods[i];
            if (declaration.isConstructor()) {
                result.add(declaration);
            }
            ++i;
        }
        return result.toArray(new MethodDeclaration[result.size()]);
    }

    private Change createChange(OldASTRewrite rewrite) throws CoreException {
        CompilationUnitChange result = new CompilationUnitChange("", this.fCu);
        TextBuffer textBuffer = TextBuffer.create(this.fCu.getBuffer().getContents());
        MultiTextEdit resultingEdits = new MultiTextEdit();
        rewrite.rewriteNode(textBuffer, (TextEdit)resultingEdits);
        TextChangeCompatibility.addTextEdit((TextChange)result, RefactoringCoreMessages.getString("PromoteTempToFieldRefactoring.editName"), (TextEdit)resultingEdits);
        rewrite.removeModifications();
        return result;
    }

    private void addLocalDeclarationSplit(OldASTRewrite rewrite) throws JavaModelException {
        VariableDeclarationStatement tempDeclarationStatement = this.getTempDeclarationStatement();
        Block block = (Block)tempDeclarationStatement.getParent();
        int statementIndex = block.statements().indexOf(tempDeclarationStatement);
        Assert.isTrue(statementIndex != -1);
        List fragments = tempDeclarationStatement.fragments();
        int fragmentIndex = fragments.indexOf(this.fTempDeclarationNode);
        Assert.isTrue(fragmentIndex != -1);
        int i1 = fragmentIndex;
        int n = fragments.size();
        while (i1 < n) {
            VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(i1);
            rewrite.remove((ASTNode)fragment, null);
            ++i1;
        }
        if (fragmentIndex == 0) {
            rewrite.remove((ASTNode)tempDeclarationStatement, null);
        }
        Assert.isTrue(this.tempHasInitializer());
        ExpressionStatement assignmentStatement = this.createExpressionStatementThatInitializesField(rewrite);
        rewrite.markAsInserted((ASTNode)assignmentStatement);
        block.statements().add(statementIndex + 1, assignmentStatement);
        if (fragmentIndex + 1 < fragments.size()) {
            VariableDeclarationFragment firstFragmentAfter = (VariableDeclarationFragment)fragments.get(fragmentIndex + 1);
            VariableDeclarationFragment copyfirstFragmentAfter = (VariableDeclarationFragment)rewrite.createCopyTarget((ASTNode)firstFragmentAfter);
            VariableDeclarationStatement statement = this.getAST().newVariableDeclarationStatement(copyfirstFragmentAfter);
            int i = fragmentIndex + 2;
            while (i < fragments.size()) {
                VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(i);
                VariableDeclarationFragment fragmentCopy = (VariableDeclarationFragment)rewrite.createCopyTarget((ASTNode)fragment);
                rewrite.markAsInserted((ASTNode)fragmentCopy);
                statement.fragments().add(fragmentCopy);
                ++i;
            }
            rewrite.markAsInserted((ASTNode)statement);
            block.statements().add(statementIndex + 2, statement);
        }
    }

    private ExpressionStatement createExpressionStatementThatInitializesField(OldASTRewrite rewrite) throws JavaModelException {
        Assignment assignment = this.getAST().newAssignment();
        SimpleName fieldName = this.getAST().newSimpleName(this.fFieldName);
        assignment.setLeftHandSide((Expression)fieldName);
        String initializerCode = this.getTempInitializerCode();
        Expression tempInitializerCopy = (Expression)rewrite.createStringPlaceholder(initializerCode, 32);
        assignment.setRightHandSide(tempInitializerCopy);
        ExpressionStatement assignmentStatement = this.getAST().newExpressionStatement((Expression)assignment);
        return assignmentStatement;
    }

    private String getTempInitializerCode() throws JavaModelException {
        return this.fCu.getBuffer().getText(this.getTempInitializer().getStartPosition(), this.getTempInitializer().getLength());
    }

    private void addLocalDeclarationRemoval(OldASTRewrite rewrite) {
        VariableDeclarationStatement tempDeclarationStatement = this.getTempDeclarationStatement();
        List fragments = tempDeclarationStatement.fragments();
        int fragmentIndex = fragments.indexOf(this.fTempDeclarationNode);
        Assert.isTrue(fragmentIndex != -1);
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(fragmentIndex);
        rewrite.remove((ASTNode)fragment, null);
        if (fragments.size() == 1) {
            rewrite.remove((ASTNode)tempDeclarationStatement, null);
        }
    }

    private void addFieldDeclaration(OldASTRewrite rewrite) {
        List bodyDeclarations = this.getBodyDeclarationListOfDeclaringType();
        FieldDeclaration[] fields = this.getFieldDeclarationsInDeclaringType();
        int insertIndex = fields.length == 0 ? 0 : bodyDeclarations.indexOf(fields[fields.length - 1]) + 1;
        FieldDeclaration fieldDeclaration = this.createNewFieldDeclaration(rewrite);
        rewrite.markAsInserted((ASTNode)fieldDeclaration);
        bodyDeclarations.add(insertIndex, fieldDeclaration);
    }

    private FieldDeclaration createNewFieldDeclaration(OldASTRewrite rewrite) {
        VariableDeclarationFragment fragment = this.getAST().newVariableDeclarationFragment();
        SimpleName variableName = this.getAST().newSimpleName(this.fFieldName);
        fragment.setName(variableName);
        fragment.setExtraDimensions(this.fTempDeclarationNode.getExtraDimensions());
        if (this.fInitializeIn == 0 && this.tempHasInitializer()) {
            Expression initializer = (Expression)rewrite.createCopyTarget((ASTNode)this.getTempInitializer());
            fragment.setInitializer(initializer);
        }
        FieldDeclaration fieldDeclaration = this.getAST().newFieldDeclaration(fragment);
        VariableDeclarationStatement vds = this.getTempDeclarationStatement();
        Type type = (Type)rewrite.createCopyTarget((ASTNode)vds.getType());
        fieldDeclaration.setType(type);
        fieldDeclaration.setModifiers(this.getModifiers());
        return fieldDeclaration;
    }

    private int getModifiers() {
        int flags = this.fVisibility;
        if (this.fDeclareFinal) {
            flags |= 0x10;
        }
        if (this.fDeclareStatic) {
            flags |= 8;
        }
        return flags;
    }

    private AST getAST() {
        return this.fTempDeclarationNode.getAST();
    }

    private static class LocalTypeAndVariableUsageAnalyzer
    extends HierarchicalASTVisitor {
        private final List fLocalDefinitions = new ArrayList(0);
        private final List fLocalReferencesToEnclosing = new ArrayList(0);

        LocalTypeAndVariableUsageAnalyzer() {
        }

        public List getUsageOfEnclosingNodes() {
            return this.fLocalReferencesToEnclosing;
        }

        public boolean visit(SimpleName node) {
            IBinding binding;
            ITypeBinding typeBinding = node.resolveTypeBinding();
            if (typeBinding != null && typeBinding.isLocal()) {
                if (node.isDeclaration()) {
                    this.fLocalDefinitions.add(typeBinding);
                } else if (!this.fLocalDefinitions.contains(typeBinding)) {
                    this.fLocalReferencesToEnclosing.add(node);
                }
            }
            if ((binding = node.resolveBinding()) != null && binding.getKind() == 3 && !((IVariableBinding)binding).isField()) {
                if (node.isDeclaration()) {
                    this.fLocalDefinitions.add(binding);
                } else if (!this.fLocalDefinitions.contains(binding)) {
                    this.fLocalReferencesToEnclosing.add(node);
                }
            }
            return super.visit(node);
        }
    }
}

