/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.program.launchConfigurations;

import java.io.File;
import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.RefreshTab;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsUtil;
import org.eclipse.ui.externaltools.internal.program.launchConfigurations.BackgroundResourceRefresher;
import org.eclipse.ui.externaltools.internal.program.launchConfigurations.ExternalToolsProgramMessages;

public class ProgramLaunchDelegate
implements ILaunchConfigurationDelegate {
    private static IWindowListener windowListener;

    /*
     * Unable to fully structure code
     */
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        block20: {
            if (monitor.isCanceled()) {
                return;
            }
            location = ExternalToolsUtil.getLocation(configuration);
            if (monitor.isCanceled()) {
                return;
            }
            workingDirectory = ExternalToolsUtil.getWorkingDirectory(configuration);
            if (monitor.isCanceled()) {
                return;
            }
            arguments = ExternalToolsUtil.getArguments(configuration);
            if (monitor.isCanceled()) {
                return;
            }
            cmdLineLength = 1;
            if (arguments != null) {
                cmdLineLength += arguments.length;
            }
            cmdLine = new String[cmdLineLength];
            cmdLine[0] = location.toOSString();
            if (arguments != null) {
                System.arraycopy(arguments, 0, cmdLine, 1, arguments.length);
            }
            workingDir = null;
            if (workingDirectory != null) {
                workingDir = workingDirectory.toFile();
            }
            if (monitor.isCanceled()) {
                return;
            }
            envp = DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration);
            if (monitor.isCanceled()) {
                return;
            }
            if (ProgramLaunchDelegate.windowListener == null) {
                ProgramLaunchDelegate.windowListener = new ProgramLaunchWindowListener();
                PlatformUI.getWorkbench().addWindowListener(ProgramLaunchDelegate.windowListener);
            }
            p = DebugPlugin.exec((String[])cmdLine, (File)workingDir, (String[])envp);
            process = null;
            processAttributes = new HashMap<String, String>();
            programName = location.lastSegment();
            extension = location.getFileExtension();
            if (extension != null) {
                programName = programName.substring(0, programName.length() - (extension.length() + 1));
            }
            programName = programName.toLowerCase();
            processAttributes.put(IProcess.ATTR_PROCESS_TYPE, programName);
            if (p != null) {
                monitor.beginTask(MessageFormat.format(ExternalToolsProgramMessages.getString("ProgramLaunchDelegate.3"), new String[]{configuration.getName()}), -1);
                process = DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)location.toOSString(), processAttributes);
                if (process == null) {
                    p.destroy();
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.externaltools", 150, ExternalToolsProgramMessages.getString("ProgramLaunchDelegate.4"), null));
                }
            }
            process.setAttribute(IProcess.ATTR_CMDLINE, this.generateCommandLine(cmdLine));
            if (!CommonTab.isLaunchInBackground((ILaunchConfiguration)configuration)) ** GOTO lbl59
            if (RefreshTab.getRefreshScope((ILaunchConfiguration)configuration) == null) break block20;
            refresher = new BackgroundResourceRefresher(configuration, process);
            refresher.startBackgroundRefresh();
            break block20;
lbl-1000:
            // 1 sources

            {
                try {
                    if (monitor.isCanceled()) {
                        process.terminate();
                        break;
                    }
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException v0) {}
lbl59:
                // 3 sources

                ** while (!process.isTerminated())
            }
lbl60:
            // 2 sources

            RefreshTab.refreshResources((ILaunchConfiguration)configuration, (IProgressMonitor)monitor);
        }
    }

    private String generateCommandLine(String[] commandLine) {
        if (commandLine.length < 1) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < commandLine.length) {
            buf.append(' ');
            char[] characters = commandLine[i].toCharArray();
            StringBuffer command = new StringBuffer();
            boolean containsSpace = false;
            int j = 0;
            while (j < characters.length) {
                char character = characters[j];
                if (character == '\"') {
                    command.append('\\');
                } else if (character == ' ') {
                    containsSpace = true;
                }
                command.append(character);
                ++j;
            }
            if (containsSpace) {
                buf.append('\"');
                buf.append(command);
                buf.append('\"');
            } else {
                buf.append(command);
            }
            ++i;
        }
        return buf.toString();
    }

    private class ProgramLaunchWindowListener
    implements IWindowListener {
        ProgramLaunchWindowListener() {
        }

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (windows.length > 1) {
                return;
            }
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType programType = manager.getLaunchConfigurationType("org.eclipse.ui.externaltools.ProgramLaunchConfigurationType");
            if (programType == null) {
                return;
            }
            ILaunch[] launches = manager.getLaunches();
            int i = 0;
            while (i < launches.length) {
                block6: {
                    ILaunchConfigurationType configType;
                    try {
                        ILaunchConfiguration config = launches[i].getLaunchConfiguration();
                        if (config == null) break block6;
                        configType = config.getType();
                    }
                    catch (CoreException coreException) {
                        break block6;
                    }
                    if (configType.equals(programType) && !launches[i].isTerminated()) {
                        MessageDialog.openWarning((Shell)window.getShell(), (String)ExternalToolsProgramMessages.getString("ProgramLaunchDelegate.Workbench_Closing_1"), (String)ExternalToolsProgramMessages.getString("ProgramLaunchDelegate.The_workbench_is_exiting"));
                        break;
                    }
                }
                ++i;
            }
        }

        public void windowOpened(IWorkbenchWindow window) {
        }
    }
}

