/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.launchConfigurations;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.RefreshTab;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsLaunchConfigurationMessages;

public class ExternalToolsUtil {
    protected static void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.externaltools", code, message, exception));
    }

    public static IPath getLocation(ILaunchConfiguration configuration) throws CoreException {
        String location = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", null);
        if (location == null) {
            ExternalToolsUtil.abort(MessageFormat.format(ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsUtil.Location_not_specified_by_{0}_1"), configuration.getName()), null, 0);
        } else {
            String expandedLocation = ExternalToolsUtil.getStringVariableManager().performStringSubstitution(location);
            if (expandedLocation == null || expandedLocation.length() == 0) {
                String msg = MessageFormat.format(ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsUtil.invalidLocation_{0}"), configuration.getName());
                ExternalToolsUtil.abort(msg, null, 0);
            } else {
                File file = new File(expandedLocation);
                if (file.isFile()) {
                    return new Path(expandedLocation);
                }
                String msg = MessageFormat.format(ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsUtil.invalidLocation_{0}"), configuration.getName());
                ExternalToolsUtil.abort(msg, null, 0);
            }
        }
        return null;
    }

    public static boolean getCaptureOutput(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_CAPTURE_OUTPUT", true);
    }

    public static IPath getWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        String expandedLocation;
        String location = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", null);
        if (location != null && (expandedLocation = ExternalToolsUtil.getStringVariableManager().performStringSubstitution(location)).length() > 0) {
            File path = new File(expandedLocation);
            if (path.isDirectory()) {
                return new Path(expandedLocation);
            }
            String msg = MessageFormat.format(ExternalToolsLaunchConfigurationMessages.getString("ExternalToolsUtil.invalidDirectory_{0}"), expandedLocation, configuration.getName());
            ExternalToolsUtil.abort(msg, null, 0);
        }
        return null;
    }

    public static String[] getArguments(ILaunchConfiguration configuration) throws CoreException {
        String args = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", null);
        if (args != null) {
            String expanded = ExternalToolsUtil.getStringVariableManager().performStringSubstitution(args);
            return ExternalToolsUtil.parseStringIntoList(expanded);
        }
        return null;
    }

    private static IStringVariableManager getStringVariableManager() {
        return VariablesPlugin.getDefault().getStringVariableManager();
    }

    public static boolean isBuilderEnabled(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_BUILDER_ENABLED", true);
    }

    public static IResource[] getResourcesForBuildScope(ILaunchConfiguration configuration) throws CoreException {
        String scope = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_BUILD_SCOPE", null);
        if (scope == null) {
            return null;
        }
        return RefreshTab.getRefreshResources((String)scope);
    }

    public static String[] parseStringIntoList(String arguments) {
        if (arguments == null || arguments.length() == 0) {
            return new String[0];
        }
        ArgumentParser parser = new ArgumentParser(arguments);
        String[] res = parser.parseArguments();
        return res;
    }

    private static class ArgumentParser {
        private String fArgs;
        private int fIndex = 0;
        private int ch = -1;

        public ArgumentParser(String args) {
            this.fArgs = args;
        }

        public String[] parseArguments() {
            ArrayList<String> v = new ArrayList<String>();
            this.ch = this.getNext();
            while (this.ch > 0) {
                if (Character.isWhitespace((char)this.ch)) {
                    this.ch = this.getNext();
                    continue;
                }
                if (this.ch == 34) {
                    v.add(this.parseString());
                    continue;
                }
                v.add(this.parseToken());
            }
            String[] result = new String[v.size()];
            v.toArray(result);
            return result;
        }

        private int getNext() {
            if (this.fIndex < this.fArgs.length()) {
                return this.fArgs.charAt(this.fIndex++);
            }
            return -1;
        }

        private String parseString() {
            StringBuffer buf = new StringBuffer();
            this.ch = this.getNext();
            while (this.ch > 0 && this.ch != 34) {
                if (this.ch == 92) {
                    this.ch = this.getNext();
                    if (this.ch != 34) {
                        buf.append('\\');
                    } else if (Platform.getOS().equals("win32")) {
                        buf.append('\\');
                    }
                }
                if (this.ch <= 0) continue;
                buf.append((char)this.ch);
                this.ch = this.getNext();
            }
            this.ch = this.getNext();
            return buf.toString();
        }

        private String parseToken() {
            StringBuffer buf = new StringBuffer();
            while (this.ch > 0 && !Character.isWhitespace((char)this.ch)) {
                if (this.ch == 92) {
                    this.ch = this.getNext();
                    if (Character.isWhitespace((char)this.ch)) {
                        buf.append('\\');
                        return buf.toString();
                    }
                    if (this.ch > 0) {
                        if (this.ch != 34) {
                            buf.append('\\');
                        } else if (Platform.getOS().equals("win32")) {
                            buf.append('\\');
                        }
                        buf.append((char)this.ch);
                        this.ch = this.getNext();
                        continue;
                    }
                    if (this.ch != -1) continue;
                    buf.append('\\');
                    continue;
                }
                if (this.ch == 34) {
                    buf.append(this.parseString());
                    continue;
                }
                buf.append((char)this.ch);
                this.ch = this.getNext();
            }
            return buf.toString();
        }
    }
}

