/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.ReferenceCounter;
import org.eclipse.ui.internal.misc.Assert;
import org.eclipse.ui.internal.misc.ProgramImageDescriptor;
import org.eclipse.ui.internal.util.BundleUtility;

public class WorkbenchImages {
    private static Map descriptors = new HashMap();
    private static ImageRegistry imageRegistry = null;
    private static ReferenceCounter imageCache = new ReferenceCounter();
    public static final String ICONS_PATH = "icons/full/";
    private static final String PATH_ETOOL = "icons/full/etool16/";
    private static final String PATH_DTOOL = "icons/full/dtool16/";
    private static final String PATH_ELOCALTOOL = "icons/full/elcl16/";
    private static final String PATH_DLOCALTOOL = "icons/full/dlcl16/";
    private static final String PATH_EVIEW = "icons/full/eview16/";
    private static final String PATH_OBJECT = "icons/full/obj16/";
    private static final String PATH_POINTER = "icons/full/pointer/";
    private static final String PATH_WIZBAN = "icons/full/wizban/";

    static {
        WorkbenchImages.initializeImageRegistry();
    }

    public static ReferenceCounter getImageCache() {
        return imageCache;
    }

    private static final void declareImage(String key, String path, boolean shared) {
        URL url = BundleUtility.find("org.eclipse.ui", path);
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
        WorkbenchImages.declareImage(key, desc, shared);
    }

    private static final void declareImages() {
        WorkbenchImages.declareImage("IMG_ETOOL_PIN_EDITOR", "icons/full/etool16/pin_editor.gif", false);
        WorkbenchImages.declareImage("IMG_ETOOL_PIN_EDITOR_DISABLED", "icons/full/dtool16/pin_editor.gif", false);
        WorkbenchImages.declareImage("IMG_ETOOL_SAVE_EDIT", "icons/full/etool16/save_edit.gif", false);
        WorkbenchImages.declareImage("IMG_ETOOL_SAVE_EDIT_HOVER", "icons/full/etool16/save_edit.gif", false);
        WorkbenchImages.declareImage("IMG_ETOOL_SAVE_EDIT_DISABLED", "icons/full/dtool16/save_edit.gif", false);
        WorkbenchImages.declareImage("IMG_ETOOL_SAVEAS_EDIT", "icons/full/etool16/saveas_edit.gif", false);
        WorkbenchImages.declareImage("IMG_ETOOL_SAVEAS_EDIT_HOVER", "icons/full/etool16/saveas_edit.gif", false);
        WorkbenchImages.declareImage("IMG_ETOOL_SAVEAS_EDIT_DISABLED", "icons/full/dtool16/saveas_edit.gif", false);
        WorkbenchImages.declareImage("IMG_ETOOL_SAVEALL_EDIT", "icons/full/etool16/saveall_edit.gif", false);
        WorkbenchImages.declareImage("IMG_ETOOL_SAVEALL_EDIT_HOVER", "icons/full/etool16/saveall_edit.gif", false);
        WorkbenchImages.declareImage("IMG_ETOOL_SAVEALL_EDIT_DISABLED", "icons/full/dtool16/saveall_edit.gif", false);
        WorkbenchImages.declareImage("IMG_TOOL_UNDO", "icons/full/etool16/undo_edit.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_UNDO_HOVER", "icons/full/etool16/undo_edit.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_UNDO_DISABLED", "icons/full/dtool16/undo_edit.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_REDO", "icons/full/etool16/redo_edit.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_REDO_HOVER", "icons/full/etool16/redo_edit.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_REDO_DISABLED", "icons/full/dtool16/redo_edit.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_CUT", "icons/full/etool16/cut_edit.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_CUT_HOVER", "icons/full/etool16/cut_edit.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_CUT_DISABLED", "icons/full/dtool16/cut_edit.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_COPY", "icons/full/etool16/copy_edit.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_COPY_HOVER", "icons/full/etool16/copy_edit.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_COPY_DISABLED", "icons/full/dtool16/copy_edit.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_PASTE", "icons/full/etool16/paste_edit.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_PASTE_HOVER", "icons/full/etool16/paste_edit.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_PASTE_DISABLED", "icons/full/dtool16/paste_edit.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_DELETE", "icons/full/etool16/delete_edit.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_DELETE_HOVER", "icons/full/etool16/delete_edit.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_DELETE_DISABLED", "icons/full/dtool16/delete_edit.gif", true);
        WorkbenchImages.declareImage("IMG_ETOOL_PRINT_EDIT", "icons/full/etool16/print_edit.gif", false);
        WorkbenchImages.declareImage("IMG_ETOOL_PRINT_EDIT_HOVER", "icons/full/etool16/print_edit.gif", false);
        WorkbenchImages.declareImage("IMG_ETOOL_PRINT_EDIT_DISABLED", "icons/full/dtool16/print_edit.gif", false);
        WorkbenchImages.declareImage("IMG_ETOOL_HELP_CONTENTS", "icons/full/etool16/help_contents.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_FORWARD", "icons/full/elcl16/forward_nav.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_FORWARD_HOVER", "icons/full/elcl16/forward_nav.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_FORWARD_DISABLED", "icons/full/dlcl16/forward_nav.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_BACK", "icons/full/elcl16/backward_nav.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_BACK_HOVER", "icons/full/elcl16/backward_nav.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_BACK_DISABLED", "icons/full/dlcl16/backward_nav.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_UP", "icons/full/elcl16/up_nav.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_UP_HOVER", "icons/full/elcl16/up_nav.gif", true);
        WorkbenchImages.declareImage("IMG_TOOL_UP_DISABLED", "icons/full/dlcl16/up_nav.gif", true);
        WorkbenchImages.declareImage("IMG_ETOOL_NEW_PAGE", "icons/full/eview16/new_persp.gif", false);
        WorkbenchImages.declareImage("IMG_ETOOL_NEW_PAGE_HOVER", "icons/full/eview16/new_persp.gif", false);
        WorkbenchImages.declareImage("IMG_ETOOL_HOME_NAV", "icons/full/elcl16/home_nav.gif", false);
        WorkbenchImages.declareImage("IMG_ETOOL_DEF_PERSPECTIVE", "icons/full/eview16/default_persp.gif", false);
        WorkbenchImages.declareImage("IMG_ETOOL_DEF_PERSPECTIVE_HOVER", "icons/full/eview16/default_persp.gif", false);
        WorkbenchImages.declareImage("IMG_WIZBAN_WORKINGSET_WIZ", "icons/full/wizban/workset_wiz.gif", false);
        WorkbenchImages.declareImage("IMG_VIEW_DEFAULTVIEW_MISC", "icons/full/eview16/defaultview_misc.gif", false);
        WorkbenchImages.declareImage("IMG_DLGBAN_SAVEAS_DLG", "icons/full/wizban/saveas_wiz.gif", false);
        WorkbenchImages.declareImage("IMG_OBJ_FONT", "icons/full/obj16/font.gif", true);
        WorkbenchImages.declareImage("IMG_OBJ_THEME_CATEGORY", "icons/full/obj16/theme_category.gif", true);
        WorkbenchImages.declareImage("IMG_OBJ_ACTIVITY", "icons/full/obj16/activity.gif", true);
        WorkbenchImages.declareImage("IMG_OBJ_ACTIVITY_CATEGORY", "icons/full/obj16/activity_category.gif", true);
        WorkbenchImages.declareImage("IMG_OBJ_FILE", "icons/full/obj16/file_obj.gif", true);
        WorkbenchImages.declareImage("IMG_OBJ_FOLDER", "icons/full/obj16/fldr_obj.gif", true);
        WorkbenchImages.declareImage("IMG_OBJ_ELEMENTS", "icons/full/obj16/elements_obj.gif", true);
        WorkbenchImages.declareImage("IMG_DEF_VIEW", "icons/full/eview16/defaultview_misc.gif", true);
        WorkbenchImages.declareImage("IMG_LCL_CLOSE_VIEW", "icons/full/elcl16/close_view.gif", true);
        WorkbenchImages.declareImage("IMG_LCL_CLOSE_VIEW_HOVER", "icons/full/elcl16/close_view.gif", true);
        WorkbenchImages.declareImage("IMG_LCL_PIN_VIEW", "icons/full/elcl16/pin_view.gif", true);
        WorkbenchImages.declareImage("IMG_LCL_PIN_VIEW_HOVER", "icons/full/elcl16/pin_view.gif", true);
        WorkbenchImages.declareImage("IMG_LCL_MIN_VIEW", "icons/full/elcl16/min_view.gif", true);
        WorkbenchImages.declareImage("IMG_LCL_MIN_VIEW_HOVER", "icons/full/elcl16/min_view.gif", true);
        WorkbenchImages.declareImage("IMG_LCL_VIEW_MENU", "icons/full/elcl16/view_menu.gif", true);
        WorkbenchImages.declareImage("IMG_LCL_VIEW_MENU_HOVER", "icons/full/elcl16/view_menu.gif", true);
        WorkbenchImages.declareImage("IMGS_LCL_LINKTO_HELP", "icons/full/elcl16/linkto_help.gif", true);
        WorkbenchImages.declareImage("IMG_OBJS_ERROR_TSK", "icons/full/obj16/error_tsk.gif", true);
        WorkbenchImages.declareImage("IMG_OBJS_WARN_TSK", "icons/full/obj16/warn_tsk.gif", true);
        WorkbenchImages.declareImage("IMG_OBJS_INFO_TSK", "icons/full/obj16/info_tsk.gif", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_LEFT_SOURCE", "icons/full/pointer/left_source.bmp", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_LEFT_MASK", "icons/full/pointer/left_mask.bmp", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_RIGHT_SOURCE", "icons/full/pointer/right_source.bmp", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_RIGHT_MASK", "icons/full/pointer/right_mask.bmp", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_TOP_SOURCE", "icons/full/pointer/top_source.bmp", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_TOP_MASK", "icons/full/pointer/top_mask.bmp", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_BOTTOM_SOURCE", "icons/full/pointer/bottom_source.bmp", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_BOTTOM_MASK", "icons/full/pointer/bottom_mask.bmp", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_INVALID_SOURCE", "icons/full/pointer/invalid_source.bmp", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_INVALID_MASK", "icons/full/pointer/invalid_mask.bmp", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_STACK_SOURCE", "icons/full/pointer/stack_source.bmp", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_STACK_MASK", "icons/full/pointer/stack_mask.bmp", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_OFFSCREEN_SOURCE", "icons/full/pointer/offscreen_source.bmp", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_OFFSCREEN_MASK", "icons/full/pointer/offscreen_mask.bmp", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_TOFASTVIEW_SOURCE", "icons/full/pointer/tofastview_source.bmp", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_TOFASTVIEW_MASK", "icons/full/pointer/tofastview_mask.bmp", true);
    }

    public static void declareImage(String symbolicName, ImageDescriptor descriptor, boolean shared) {
        descriptors.put(symbolicName, descriptor);
        if (shared) {
            imageRegistry.put(symbolicName, descriptor);
        }
    }

    public static Image getImage(String symbolicName) {
        return WorkbenchImages.getImageRegistry().get(symbolicName);
    }

    public static ImageDescriptor getImageDescriptor(String symbolicName) {
        return (ImageDescriptor)descriptors.get(symbolicName);
    }

    public static ImageDescriptor getImageDescriptorFromProgram(String filename, int offset) {
        Assert.isNotNull(filename);
        String key = String.valueOf(filename) + "*" + offset;
        ImageDescriptor desc = WorkbenchImages.getImageDescriptor(key);
        if (desc == null) {
            desc = new ProgramImageDescriptor(filename, offset);
            descriptors.put(key, desc);
        }
        return desc;
    }

    public static ImageRegistry getImageRegistry() {
        return imageRegistry;
    }

    public static ImageRegistry initializeImageRegistry() {
        imageRegistry = new ImageRegistry();
        WorkbenchImages.declareImages();
        return imageRegistry;
    }
}

