/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Diff;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.wizards.GenerateDiffFileOperation;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.ide.misc.ContainerContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class GenerateDiffFileWizard
extends Wizard {
    private PatchFileSelectionPage mainPage;
    private PatchFileCreationOptionsPage optionsPage;
    private IStructuredSelection selection;
    private IResource resource;

    public GenerateDiffFileWizard(IStructuredSelection selection, IResource resource) {
        this.selection = selection;
        this.resource = resource;
        this.setWindowTitle(Policy.bind("GenerateCVSDiff.title"));
        this.initializeDefaultPageImageDescriptor();
    }

    public void addPages() {
        String pageTitle = Policy.bind("GenerateCVSDiff.pageTitle");
        String pageDescription = Policy.bind("GenerateCVSDiff.pageDescription");
        this.mainPage = new PatchFileSelectionPage(pageTitle, pageTitle, CVSUIPlugin.getPlugin().getImageDescriptor("wizban/createpatch_wizban.gif"), this.selection);
        this.mainPage.setDescription(pageDescription);
        this.addPage((IWizardPage)this.mainPage);
        pageTitle = Policy.bind("Advanced_options_19");
        pageDescription = Policy.bind("Configure_the_options_used_for_the_CVS_diff_command_20");
        this.optionsPage = new PatchFileCreationOptionsPage(pageTitle, pageTitle, CVSUIPlugin.getPlugin().getImageDescriptor("wizban/createpatch_wizban.gif"));
        this.optionsPage.setDescription(pageDescription);
        this.addPage((IWizardPage)this.optionsPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    protected void initializeDefaultPageImageDescriptor() {
        String iconPath = "icons/full/";
        try {
            URL installURL = CVSUIPlugin.getPlugin().getDescriptor().getInstallURL();
            URL url = new URL(installURL, String.valueOf(iconPath) + "wizards/newconnect_wiz.gif");
            ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
            this.setDefaultPageImageDescriptor(desc);
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public boolean needsProgressMonitor() {
        return true;
    }

    public boolean performFinish() {
        String fs = this.mainPage.getFilesystemFile();
        IFile ws = this.mainPage.getWorkspaceFile();
        int type = this.mainPage.getSaveType();
        try {
            if (type != this.mainPage.CLIPBOARD) {
                File file = new File(fs != null ? fs : ws.getLocation().toOSString());
                if (file.exists()) {
                    String title = Policy.bind("GenerateCVSDiff.overwriteTitle");
                    String msg = Policy.bind("GenerateCVSDiff.overwriteMsg");
                    MessageDialog dialog = new MessageDialog(this.getShell(), title, null, msg, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                    dialog.open();
                    if (dialog.getReturnCode() != 0) {
                        return false;
                    }
                }
                this.getContainer().run(true, true, (IRunnableWithProgress)new GenerateDiffFileOperation(this.resource, file, false, this.optionsPage.getOptions(), this.getShell()));
                if (type == this.mainPage.WORKSPACE) {
                    ws.getParent().refreshLocal(1, null);
                }
            } else {
                this.getContainer().run(true, true, (IRunnableWithProgress)new GenerateDiffFileOperation(this.resource, null, true, this.optionsPage.getOptions(), this.getShell()));
            }
            return true;
        }
        catch (InterruptedException interruptedException) {
            return true;
        }
        catch (CoreException e) {
            CVSUIPlugin.openError(this.getShell(), Policy.bind("GenerateCVSDiff.error"), null, e);
            return false;
        }
        catch (InvocationTargetException e2) {
            CVSUIPlugin.openError(this.getShell(), Policy.bind("GenerateCVSDiff.error"), null, e2);
            return false;
        }
    }

    private class PatchFileSelectionPage
    extends WizardPage {
        private Text filenameCombo;
        private Button browseButton;
        private TreeViewer treeViewer;
        private IContainer selectedContainer;
        private Text workspaceFilename;
        private Button saveInFilesystem;
        private Button saveInWorkspace;
        private Button saveToClipboard;
        public final int CLIPBOARD = 1;
        public final int FILESYSTEM = 2;
        public final int WORKSPACE = 3;
        private static final int SIZING_SELECTION_PANE_HEIGHT = 125;
        private static final int SIZING_SELECTION_PANE_WIDTH = 200;

        PatchFileSelectionPage(String pageName, String title, ImageDescriptor image, IStructuredSelection selection) {
            super(pageName, title, image);
            this.setPageComplete(false);
        }

        protected boolean validatePage() {
            boolean valid = false;
            switch (this.getSaveType()) {
                case 3: {
                    if (this.selectedContainer == null || this.getWorkspaceFile() == null) break;
                    valid = true;
                    break;
                }
                case 2: {
                    File file = new File(this.getFilesystemFile());
                    valid = this.isValidFile(file);
                    break;
                }
                case 1: {
                    valid = true;
                }
            }
            if (valid) {
                this.setMessage(null);
                this.setErrorMessage(null);
            } else {
                this.setErrorMessage(Policy.bind("Enter_a_valid_file_name_or_select_the_clipboard_option_1"));
            }
            this.setPageComplete(valid);
            return valid;
        }

        private boolean isValidFile(File file) {
            if (!file.isAbsolute()) {
                return false;
            }
            if (file.isDirectory()) {
                return false;
            }
            File parent = file.getParentFile();
            if (parent == null) {
                return false;
            }
            if (!parent.exists()) {
                return false;
            }
            return parent.isDirectory();
        }

        public String getFilesystemFile() {
            if (this.saveInFilesystem.getSelection()) {
                return this.filenameCombo.getText();
            }
            return null;
        }

        public IFile getWorkspaceFile() {
            if (this.saveInWorkspace.getSelection() && this.selectedContainer != null) {
                String filename = this.workspaceFilename.getText();
                if (filename == null || filename.length() == 0) {
                    return null;
                }
                return this.selectedContainer.getFile((IPath)new Path(this.workspaceFilename.getText()));
            }
            return null;
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData());
            this.setControl((Control)composite);
            this.initializeDialogUnits((Control)composite);
            WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.team.cvs.ui.patch_selection_page_context");
            this.saveToClipboard = new Button(composite, 16);
            this.saveToClipboard.setText(Policy.bind("Save_To_Clipboard_2"));
            this.saveToClipboard.addListener(13, new Listener(this){
                final /* synthetic */ PatchFileSelectionPage this$1;
                {
                    this.this$1 = patchFileSelectionPage;
                }

                public void handleEvent(Event event) {
                    this.this$1.validatePage();
                    this.this$1.updateEnablements();
                }
            });
            this.saveInFilesystem = new Button(composite, 16);
            this.saveInFilesystem.setText(Policy.bind("Save_In_File_System_3"));
            this.saveInFilesystem.addListener(13, new Listener(this){
                final /* synthetic */ PatchFileSelectionPage this$1;
                {
                    this.this$1 = patchFileSelectionPage;
                }

                public void handleEvent(Event event) {
                    this.this$1.validatePage();
                    this.this$1.updateEnablements();
                }
            });
            Composite nameGroup = new Composite(composite, 0);
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginWidth = 0;
            nameGroup.setLayout((Layout)layout);
            GridData data = new GridData(768);
            nameGroup.setLayoutData((Object)data);
            this.filenameCombo = new Text(nameGroup, 2048);
            GridData gd = new GridData(768);
            this.filenameCombo.setLayoutData((Object)gd);
            this.filenameCombo.addModifyListener(new ModifyListener(this){
                final /* synthetic */ PatchFileSelectionPage this$1;
                {
                    this.this$1 = patchFileSelectionPage;
                }

                public void modifyText(ModifyEvent e) {
                    this.this$1.validatePage();
                }
            });
            this.browseButton = new Button(nameGroup, 0);
            this.browseButton.setText(Policy.bind("Browse..._4"));
            data = new GridData(128);
            data.heightHint = this.convertVerticalDLUsToPixels(14);
            data.widthHint = this.convertHorizontalDLUsToPixels(61);
            this.browseButton.setLayoutData((Object)data);
            this.browseButton.addListener(13, new Listener(this){
                final /* synthetic */ PatchFileSelectionPage this$1;
                {
                    this.this$1 = patchFileSelectionPage;
                }

                public void handleEvent(Event event) {
                    FileDialog d = new FileDialog(this.this$1.getShell(), 40960);
                    d.setText(Policy.bind("Save_Patch_As_5"));
                    d.setFileName(Policy.bind("patch.txt_6"));
                    String file = d.open();
                    if (file != null) {
                        Path path = new Path(file);
                        this.this$1.setFilesystemFilename(path.toOSString());
                    }
                }
            });
            this.saveInWorkspace = new Button(composite, 16);
            this.saveInWorkspace.setText(Policy.bind("Save_In_Workspace_7"));
            this.saveInWorkspace.addListener(13, new Listener(this){
                final /* synthetic */ PatchFileSelectionPage this$1;
                {
                    this.this$1 = patchFileSelectionPage;
                }

                public void handleEvent(Event event) {
                    this.this$1.validatePage();
                    this.this$1.updateEnablements();
                }
            });
            this.createTreeViewer(composite);
            this.saveToClipboard.setSelection(true);
            this.validatePage();
            this.updateEnablements();
        }

        protected void setFilesystemFilename(String filename) {
            this.filenameCombo.setText(filename);
        }

        protected void createTreeViewer(Composite parent) {
            new Label(parent, 16384).setText(Policy.bind("Select_a_folder_then_type_in_the_file_name__8"));
            this.treeViewer = new TreeViewer(parent, 2048);
            ContainerContentProvider cp = new ContainerContentProvider();
            cp.showClosedProjects(false);
            GridData data = new GridData(1808);
            data.widthHint = 200;
            data.heightHint = 125;
            this.treeViewer.getTree().setLayoutData((Object)data);
            this.treeViewer.setContentProvider((IContentProvider)cp);
            this.treeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
            this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(this){
                final /* synthetic */ PatchFileSelectionPage this$1;
                {
                    this.this$1 = patchFileSelectionPage;
                }

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    this.this$1.containerSelectionChanged((IContainer)selection.getFirstElement());
                    this.this$1.validatePage();
                }
            });
            this.treeViewer.addDoubleClickListener(new IDoubleClickListener(this){
                final /* synthetic */ PatchFileSelectionPage this$1;
                {
                    this.this$1 = patchFileSelectionPage;
                }

                public void doubleClick(DoubleClickEvent event) {
                    ISelection selection = event.getSelection();
                    if (selection instanceof IStructuredSelection) {
                        Object item = ((IStructuredSelection)selection).getFirstElement();
                        if (PatchFileSelectionPage.access$0(this.this$1).getExpandedState(item)) {
                            PatchFileSelectionPage.access$0(this.this$1).collapseToLevel(item, 1);
                        } else {
                            PatchFileSelectionPage.access$0(this.this$1).expandToLevel(item, 1);
                        }
                    }
                }
            });
            this.treeViewer.setInput((Object)ResourcesPlugin.getWorkspace());
            Composite nameGroup = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginWidth = 0;
            nameGroup.setLayout((Layout)layout);
            data = new GridData(768);
            nameGroup.setLayoutData((Object)data);
            Label label = new Label(nameGroup, 0);
            label.setText(Policy.bind("Fi&le_name__9"));
            this.workspaceFilename = new Text(nameGroup, 2048);
            data = new GridData(768);
            this.workspaceFilename.setLayoutData((Object)data);
            this.workspaceFilename.addModifyListener(new ModifyListener(this){
                final /* synthetic */ PatchFileSelectionPage this$1;
                {
                    this.this$1 = patchFileSelectionPage;
                }

                public void modifyText(ModifyEvent e) {
                    this.this$1.validatePage();
                }
            });
        }

        protected void updateEnablements() {
            int type = this.getSaveType();
            this.browseButton.setEnabled(type == 2);
            this.filenameCombo.setEnabled(type == 2);
            this.treeViewer.getTree().setEnabled(type == 3);
            this.workspaceFilename.setEnabled(type == 3);
        }

        public int getSaveType() {
            if (this.saveInFilesystem.getSelection()) {
                return 2;
            }
            if (this.saveToClipboard.getSelection()) {
                return 1;
            }
            return 3;
        }

        public void containerSelectionChanged(IContainer container) {
            this.selectedContainer = container;
        }

        static /* synthetic */ TreeViewer access$0(PatchFileSelectionPage patchFileSelectionPage) {
            return patchFileSelectionPage.treeViewer;
        }
    }

    public class PatchFileCreationOptionsPage
    extends WizardPage {
        private Button recurseOption;
        private Button contextDiffOption;
        private Button unifiedDiffOption;
        private Button regularDiffOption;
        private Button includeNewFilesOptions;

        protected PatchFileCreationOptionsPage(String pageName) {
            super(pageName);
        }

        protected PatchFileCreationOptionsPage(String pageName, String title, ImageDescriptor titleImage) {
            super(pageName, title, titleImage);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData());
            this.setControl((Control)composite);
            WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.team.cvs.ui.patch_options_page_context");
            this.recurseOption = new Button(composite, 32);
            this.recurseOption.setText(Policy.bind("Do_not_recurse_into_sub-folders_10"));
            this.recurseOption.setSelection(true);
            this.includeNewFilesOptions = new Button(composite, 32);
            this.includeNewFilesOptions.setText(Policy.bind("Do_not_include_new_files_in_patch_11"));
            this.includeNewFilesOptions.setSelection(true);
            Group diffTypeGroup = new Group(composite, 0);
            layout = new GridLayout();
            layout.marginHeight = 0;
            diffTypeGroup.setLayout((Layout)layout);
            GridData data = new GridData(768);
            diffTypeGroup.setLayoutData((Object)data);
            diffTypeGroup.setText(Policy.bind("Diff_output_format_12"));
            this.unifiedDiffOption = new Button((Composite)diffTypeGroup, 16);
            this.unifiedDiffOption.setText(Policy.bind("Unified_(format_required_by_Compare_With_Patch_feature)_13"));
            this.unifiedDiffOption.setSelection(true);
            this.contextDiffOption = new Button((Composite)diffTypeGroup, 16);
            this.contextDiffOption.setText(Policy.bind("Context_14"));
            this.regularDiffOption = new Button((Composite)diffTypeGroup, 16);
            this.regularDiffOption.setText(Policy.bind("Standard_15"));
        }

        public boolean isRecursive() {
            return !this.recurseOption.getSelection();
        }

        public Command.LocalOption[] getOptions() {
            ArrayList<Command.LocalOption> options = new ArrayList<Command.LocalOption>(5);
            if (this.includeNewFilesOptions.getSelection()) {
                options.add(Diff.INCLUDE_NEWFILES);
            }
            if (!this.recurseOption.getSelection()) {
                options.add(Diff.DO_NOT_RECURSE);
            }
            if (this.unifiedDiffOption.getSelection()) {
                options.add(Diff.UNIFIED_FORMAT);
            } else if (this.contextDiffOption.getSelection()) {
                options.add(Diff.CONTEXT_FORMAT);
            }
            return options.toArray(new Command.LocalOption[options.size()]);
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible) {
                this.recurseOption.setFocus();
            }
        }
    }
}

