/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.repo;

import java.util.Properties;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.IRepositoryListener;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.WorkbenchUserAuthenticator;
import org.eclipse.team.internal.ccvs.ui.actions.CVSAction;
import org.eclipse.team.internal.ccvs.ui.model.AllRootsElement;
import org.eclipse.team.internal.ccvs.ui.repo.RemoteViewPart;
import org.eclipse.team.internal.ccvs.ui.repo.RemoveDateTagAction;
import org.eclipse.team.internal.ccvs.ui.repo.RemoveRootAction;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryRoot;
import org.eclipse.team.internal.ccvs.ui.wizards.NewLocationWizard;
import org.eclipse.team.internal.core.TeamPlugin;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.help.WorkbenchHelp;

public class RepositoriesView
extends RemoteViewPart {
    public static final String VIEW_ID = "org.eclipse.team.ccvs.ui.RepositoriesView";
    private AllRootsElement root;
    private IAction removeAction;
    private Action newAction;
    private Action newAnonAction;
    private PropertyDialogAction propertiesAction;
    private RemoveRootAction removeRootAction;
    private RemoveDateTagAction removeDateTagAction;
    IRepositoryListener listener = new IRepositoryListener(){

        public void repositoryAdded(ICVSRepositoryLocation root) {
            RepositoriesView.this.getViewer().getControl().getDisplay().asyncExec(new Runnable(this, root){
                final /* synthetic */ 1 this$1;
                private final /* synthetic */ ICVSRepositoryLocation val$root;
                {
                    this.this$1 = var1_1;
                    this.val$root = iCVSRepositoryLocation;
                }

                public void run() {
                    1.access$0(this.this$1).refreshViewer();
                    1.access$0(this.this$1).getViewer().setSelection((ISelection)new StructuredSelection((Object)this.val$root));
                }
            });
        }

        public void repositoryRemoved(ICVSRepositoryLocation root) {
            this.refresh();
        }

        public void repositoriesChanged(ICVSRepositoryLocation[] roots) {
            this.refresh();
        }

        private void refresh() {
            Display display = RepositoriesView.this.getViewer().getControl().getDisplay();
            display.asyncExec(new Runnable(this){
                final /* synthetic */ 1 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void run() {
                    1.access$0(this.this$1).refreshViewer();
                }
            });
        }

        static /* synthetic */ RepositoriesView access$0(1 var0) {
            return var0.RepositoriesView.this;
        }
    };
    static /* synthetic */ Class class$0;

    public RepositoriesView() {
        super(VIEW_ID);
    }

    protected void contributeActions() {
        final Shell shell = this.getShell();
        this.newAction = new Action(Policy.bind("RepositoriesView.new"), CVSUIPlugin.getPlugin().getImageDescriptor("etool16/newlocation_wiz.gif")){

            public void run() {
                NewLocationWizard wizard = new NewLocationWizard();
                WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                dialog.open();
            }
        };
        WorkbenchHelp.setHelp((IAction)this.newAction, (String)"org.eclipse.team.cvs.ui.new_repository_location_action_context");
        if (this.includeAnonConnection()) {
            this.newAnonAction = new Action(Policy.bind("RepositoriesView.newAnonCVS"), CVSUIPlugin.getPlugin().getImageDescriptor("etool16/newlocation_wiz.gif")){

                public void run() {
                    Properties p = new Properties();
                    p.setProperty("connection", "pserver");
                    p.setProperty("user", "anonymous");
                    p.setProperty("host", "dev.eclipse.org");
                    p.setProperty("root", "/home/eclipse");
                    NewLocationWizard wizard = new NewLocationWizard(p);
                    WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                    dialog.open();
                }
            };
            WorkbenchHelp.setHelp((IAction)this.newAnonAction, (String)"org.eclipse.team.cvs.ui.new_dev_eclipse repository_location_action_context");
        }
        this.propertiesAction = new PropertyDialogAction(shell, (ISelectionProvider)this.getViewer());
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.propertiesAction);
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        if (selection.size() == 1 && selection.getFirstElement() instanceof RepositoryRoot) {
            this.propertiesAction.setEnabled(true);
        } else {
            this.propertiesAction.setEnabled(false);
        }
        this.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                boolean enabled = ss.size() == 1 && ss.getFirstElement() instanceof RepositoryRoot;
                RepositoriesView.this.propertiesAction.setEnabled(enabled);
            }
        });
        this.removeRootAction = new RemoveRootAction(this.viewer.getControl().getShell(), this);
        this.removeRootAction.selectionChanged(null);
        this.removeDateTagAction = new RemoveDateTagAction();
        this.removeDateTagAction.selectionChanged(null);
        this.removeAction = new Action(){

            public void run() {
                if (RepositoriesView.this.removeRootAction.isEnabled()) {
                    RepositoriesView.this.removeRootAction.run();
                }
                if (RepositoriesView.this.removeDateTagAction.isEnabled()) {
                    RepositoriesView.this.removeDateTagAction.run();
                }
            }
        };
        WorkbenchHelp.setHelp((IAction)this.removeRootAction, (String)"org.eclipse.team.cvs.ui.remove_root_action_context");
        IActionBars bars = this.getViewSite().getActionBars();
        bars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.removeAction);
        super.contributeActions();
    }

    private boolean includeAnonConnection() {
        return System.getProperty("eclipse.cvs.anon") != null;
    }

    protected void addWorkbenchActions(IMenuManager manager) {
        MenuManager sub = new MenuManager(Policy.bind("RepositoriesView.newSubmenu"), "group.add");
        manager.add((IContributionItem)sub);
        super.addWorkbenchActions(manager);
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        this.removeRootAction.selectionChanged(selection);
        this.removeDateTagAction.selectionChanged(selection);
        if (this.removeRootAction.isEnabled()) {
            manager.add((IAction)this.removeRootAction);
        }
        if (this.removeDateTagAction.isEnabled()) {
            manager.add((IAction)this.removeDateTagAction);
        }
        if (selection.size() == 1 && selection.getFirstElement() instanceof RepositoryRoot) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.propertiesAction);
        }
        sub.add((IAction)this.newAction);
        if (this.newAnonAction != null) {
            sub.add((IAction)this.newAnonAction);
        }
        sub.add((IContributionItem)new Separator("group1"));
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        CVSUIPlugin.getPlugin().getRepositoryManager().addRepositoryListener(this.listener);
    }

    public void dispose() {
        CVSUIPlugin.getPlugin().getRepositoryManager().removeRepositoryListener(this.listener);
        super.dispose();
    }

    private void initialize() {
        this.root = new AllRootsElement();
    }

    protected void initializeListeners() {
        super.initializeListeners();
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.removeRootAction);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.removeDateTagAction);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                RepositoriesView.this.handleChange(selection);
            }
        });
    }

    protected Object getTreeInput() {
        this.initialize();
        return this.root;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        String msg = this.getStatusLineMessage(selection);
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(msg);
    }

    private String getStatusLineMessage(ISelection selection) {
        Object element;
        if (selection == null || selection.isEmpty()) {
            return "";
        }
        if (!(selection instanceof IStructuredSelection)) {
            return "";
        }
        IStructuredSelection s = (IStructuredSelection)selection;
        if (s.size() > 1) {
            return Policy.bind("RepositoriesView.NItemsSelected", String.valueOf(s.size()));
        }
        Object object = s.getFirstElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.team.internal.ccvs.core.ICVSResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((element = CVSAction.getAdapter((Object)object, (Class)clazz)) instanceof ICVSRemoteResource) {
            String name;
            ICVSRemoteResource res = (ICVSRemoteResource)element;
            if (res.isContainer()) {
                name = res.getRepositoryRelativePath();
            } else {
                try {
                    name = String.valueOf(res.getRepositoryRelativePath()) + " " + ((ICVSRemoteFile)res).getRevision();
                }
                catch (TeamException e) {
                    TeamPlugin.log((int)4, (String)Policy.bind("RepositoriesView.CannotGetRevision"), (Throwable)e);
                    name = res.getRepositoryRelativePath();
                }
            }
            return Policy.bind("RepositoriesView.ResourceInRepository", name, res.getRepository().getLocation());
        }
        return Policy.bind("RepositoriesView.OneItemSelected");
    }

    protected String getHelpContextId() {
        return "org.eclipse.team.cvs.ui.repositories_view_context";
    }

    protected KeyAdapter getKeyListener() {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 0x100000E) {
                    if (WorkbenchUserAuthenticator.USE_ALTERNATE_PROMPTER) {
                        ICVSRepositoryLocation[] locations = KnownRepositories.getInstance().getRepositories();
                        int i = 0;
                        while (i < locations.length) {
                            locations[i].flushUserInfo();
                            ++i;
                        }
                    } else {
                        RepositoriesView.this.refreshAll();
                    }
                } else if (event.keyCode == 0x1000012 && WorkbenchUserAuthenticator.USE_ALTERNATE_PROMPTER) {
                    RepositoriesView.this.refreshAll();
                }
            }
        };
    }

    private void handleChange(IStructuredSelection selection) {
        this.removeRootAction.updateSelection(selection);
        this.removeDateTagAction.updateSelection(selection);
        this.removeAction.setEnabled(this.removeRootAction.isEnabled() || this.removeDateTagAction.isEnabled());
    }
}

