/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.Update;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.SingleCommandOperation;
import org.eclipse.ui.IWorkbenchPart;

public class UpdateOperation
extends SingleCommandOperation {
    CVSTag tag;

    public UpdateOperation(IWorkbenchPart part, IResource[] resources, Command.LocalOption[] options, CVSTag tag) {
        super(part, resources, options);
        this.tag = tag;
    }

    protected IStatus executeCommand(Session session, CVSTeamProvider provider, ICVSResource[] resources, IProgressMonitor monitor) throws CVSException, InterruptedException {
        ArrayList<Command.LocalOption> localOptions = new ArrayList<Command.LocalOption>();
        if (this.tag != null) {
            localOptions.add(Update.makeTagOption((CVSTag)this.tag));
        }
        localOptions.addAll(Arrays.asList(this.getLocalOptions()));
        Command.LocalOption[] commandOptions = localOptions.toArray(new Command.LocalOption[localOptions.size()]);
        monitor.beginTask(null, 100);
        IStatus execute = this.getUpdateCommand().execute(session, Command.NO_GLOBAL_OPTIONS, commandOptions, resources, this.getCommandOutputListener(), Policy.subMonitorFor(monitor, 95));
        this.updateWorkspaceSubscriber(provider, resources, Policy.subMonitorFor(monitor, 5));
        monitor.done();
        return execute;
    }

    protected Update getUpdateCommand() {
        return Command.UPDATE;
    }

    protected String getTaskName() {
        return Policy.bind("UpdateOperation.taskName");
    }

    protected String getTaskName(CVSTeamProvider provider) {
        return Policy.bind("UpdateOperation.0", provider.getProject().getName());
    }

    protected ICommandOutputListener getCommandOutputListener() {
        return null;
    }

    protected void handleErrors(IStatus[] errors) throws CVSException {
        ArrayList<IStatus> serverErrors = new ArrayList<IStatus>();
        int i = 0;
        while (i < errors.length) {
            IStatus status = errors[i];
            if (status.getCode() == -10) {
                serverErrors.add(status);
            } else if (status.getCode() == -26) {
                serverErrors.add(status);
            } else if (status.isMultiStatus()) {
                IStatus[] children = status.getChildren();
                int j = 0;
                while (j < children.length) {
                    IStatus child = children[j];
                    if (child.getCode() == -26) {
                        serverErrors.add(status);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (serverErrors.isEmpty()) {
            return;
        }
        super.handleErrors(serverErrors.toArray(new IStatus[serverErrors.size()]));
    }

    protected String getErrorMessage(IStatus[] failures, int totalOperations) {
        return Policy.bind("UpdateAction.update");
    }
}

