/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.console;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.console.ConsoleDocument;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class CVSOutputConsole
extends MessageConsole
implements org.eclipse.team.internal.ccvs.core.client.listeners.IConsoleListener,
IPropertyChangeListener {
    private Color commandColor;
    private Color messageColor;
    private Color errorColor;
    private long commandStarted = 0L;
    private MessageConsoleStream commandStream;
    private MessageConsoleStream messageStream;
    private MessageConsoleStream errorStream;
    private boolean showOnError;
    private boolean showOnMessage = CVSUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_console_show_on_error");
    private ConsoleDocument document;
    private static final DateFormat TIME_FORMAT = new SimpleDateFormat(Policy.bind("Console.resultTimeFormat"));
    private boolean visible = false;
    private boolean initialized = false;

    public CVSOutputConsole() {
        super("CVS", CVSUIPlugin.getPlugin().getImageDescriptor("eview16/console_view.gif"));
        this.showOnError = CVSUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_console_show_on_message");
        this.document = new ConsoleDocument();
        CVSProviderPlugin.getPlugin().setConsoleListener((org.eclipse.team.internal.ccvs.core.client.listeners.IConsoleListener)this);
        CVSUIPlugin.getPlugin().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.showConsole(false);
    }

    protected void init() {
        super.init();
        CVSUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)CVSOutputConsole.this);
                CVSOutputConsole.this.initializeStreams();
                CVSOutputConsole.this.dump();
            }
        });
    }

    private void initializeStreams() {
        ConsoleDocument consoleDocument = this.document;
        synchronized (consoleDocument) {
            if (!this.initialized) {
                this.commandStream = this.newMessageStream();
                this.errorStream = this.newMessageStream();
                this.messageStream = this.newMessageStream();
                this.commandColor = this.createColor(CVSUIPlugin.getStandardDisplay(), "pref_console_command_color");
                this.commandStream.setColor(this.commandColor);
                this.messageColor = this.createColor(CVSUIPlugin.getStandardDisplay(), "pref_console_message_color");
                this.messageStream.setColor(this.messageColor);
                this.errorColor = this.createColor(CVSUIPlugin.getStandardDisplay(), "pref_console_error_color");
                this.errorStream.setColor(this.errorColor);
                this.setFont(JFaceResources.getFontRegistry().get("pref_console_font"));
                this.initialized = true;
            }
        }
    }

    private void dump() {
        ConsoleDocument consoleDocument = this.document;
        synchronized (consoleDocument) {
            this.visible = true;
            ConsoleDocument.ConsoleLine[] lines = this.document.getLines();
            int i = 0;
            while (i < lines.length) {
                ConsoleDocument.ConsoleLine line = lines[i];
                this.appendLine(line.type, line.line);
                ++i;
            }
            this.document.clear();
        }
    }

    private void appendLine(int type, String line) {
        ConsoleDocument consoleDocument = this.document;
        synchronized (consoleDocument) {
            if (this.visible) {
                switch (type) {
                    case 0: {
                        this.commandStream.println(line);
                        break;
                    }
                    case 1: {
                        this.messageStream.println("  " + line);
                        break;
                    }
                    case 2: {
                        this.errorStream.println("  " + line);
                    }
                }
            } else {
                this.document.appendConsoleLine(type, line);
            }
        }
    }

    private void showConsole(boolean show) {
        if (this.showOnMessage) {
            IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
            if (!this.visible) {
                manager.addConsoles(new IConsole[]{this});
            }
            if (show) {
                manager.showConsoleView((IConsole)this);
            }
        }
    }

    protected void dispose() {
        ConsoleDocument consoleDocument = this.document;
        synchronized (consoleDocument) {
            this.visible = false;
            JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        }
    }

    public void shutdown() {
        super.dispose();
        if (this.commandColor != null) {
            this.commandColor.dispose();
        }
        if (this.messageColor != null) {
            this.messageColor.dispose();
        }
        if (this.errorColor != null) {
            this.errorColor.dispose();
        }
        CVSUIPlugin.getPlugin().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void commandInvoked(String line) {
        this.commandStarted = System.currentTimeMillis();
        this.appendLine(0, Policy.bind("Console.preExecutionDelimiter"));
        this.appendLine(0, line);
    }

    public void messageLineReceived(String line) {
        this.appendLine(1, "  " + line);
    }

    public void errorLineReceived(String line) {
        this.appendLine(2, "  " + line);
    }

    public void commandCompleted(IStatus status, Exception exception) {
        String time;
        long commandRuntime = System.currentTimeMillis() - this.commandStarted;
        try {
            time = TIME_FORMAT.format(new Date(commandRuntime));
        }
        catch (RuntimeException e) {
            CVSUIPlugin.log(4, Policy.bind("Console.couldNotFormatTime"), e);
            time = "";
        }
        if (status != null) {
            String statusText = status.getCode() == -10 ? Policy.bind("Console.resultServerError", status.getMessage(), time) : Policy.bind("Console.resultOk", time);
            this.appendLine(0, statusText);
            IStatus[] children = status.getChildren();
            if (children.length == 0) {
                if (!status.isOK()) {
                    this.appendLine(0, this.messageLineForStatus(status));
                }
            } else {
                int i = 0;
                while (i < children.length) {
                    if (!children[i].isOK()) {
                        this.appendLine(0, this.messageLineForStatus(children[i]));
                    }
                    ++i;
                }
            }
        } else if (exception != null) {
            String statusText = exception instanceof OperationCanceledException ? Policy.bind("Console.resultAborted", time) : Policy.bind("Console.resultException", time);
            this.appendLine(0, statusText);
        } else {
            String statusText = Policy.bind("Console.resultOk", time);
        }
        this.appendLine(0, Policy.bind("Console.postExecutionDelimiter"));
        this.appendLine(0, "");
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (this.visible) {
            Color newColor;
            if (property.equals("pref_console_command_color")) {
                newColor = this.createColor(CVSUIPlugin.getStandardDisplay(), "pref_console_command_color");
                this.commandStream.setColor(newColor);
                this.commandColor.dispose();
                this.commandColor = newColor;
            } else if (property.equals("pref_console_message_color")) {
                newColor = this.createColor(CVSUIPlugin.getStandardDisplay(), "pref_console_message_color");
                this.messageStream.setColor(newColor);
                this.messageColor.dispose();
                this.messageColor = newColor;
            } else if (property.equals("pref_console_error_color")) {
                newColor = this.createColor(CVSUIPlugin.getStandardDisplay(), "pref_console_error_color");
                this.errorStream.setColor(newColor);
                this.errorColor.dispose();
                this.errorColor = newColor;
            } else if (property.equals("pref_console_font")) {
                this.setFont(JFaceResources.getFontRegistry().get("pref_console_font"));
            }
        }
        if (property.equals("pref_console_show_on_error")) {
            Object value = event.getNewValue();
            this.showOnMessage = value instanceof String ? Boolean.getBoolean((String)event.getNewValue()) : (Boolean)value;
            if (this.showOnMessage) {
                this.showConsole(true);
            } else {
                IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
                manager.removeConsoles(new IConsole[]{this});
                ConsolePlugin.getDefault().getConsoleManager().addConsoleListener((IConsoleListener)new MyLifecycle());
            }
        }
    }

    private String messageLineForStatus(IStatus status) {
        if (status.getSeverity() == 4) {
            return Policy.bind("Console.error", status.getMessage());
        }
        if (status.getSeverity() == 2) {
            return Policy.bind("Console.warning", status.getMessage());
        }
        if (status.getSeverity() == 1) {
            return Policy.bind("Console.info", status.getMessage());
        }
        return status.getMessage();
    }

    private Color createColor(Display display, String preference) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)CVSUIPlugin.getPlugin().getPreferenceStore(), (String)preference);
        return new Color((Device)display, rgb);
    }

    class MyLifecycle
    implements IConsoleListener {
        MyLifecycle() {
        }

        public void consolesAdded(IConsole[] consoles) {
            int i = 0;
            while (i < consoles.length) {
                IConsole console = consoles[i];
                if (console == CVSOutputConsole.this) {
                    CVSOutputConsole.this.init();
                }
                ++i;
            }
        }

        public void consolesRemoved(IConsole[] consoles) {
            int i = 0;
            while (i < consoles.length) {
                IConsole console = consoles[i];
                if (console == CVSOutputConsole.this) {
                    ConsolePlugin.getDefault().getConsoleManager().removeConsoleListener((IConsoleListener)this);
                    CVSOutputConsole.this.dispose();
                }
                ++i;
            }
        }
    }
}

