/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.ui.dialogs.PropertyPage;

public class ResourcePropertiesPage
extends PropertyPage {
    IResource resource;
    static /* synthetic */ Class class$0;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        try {
            IResource resource = this.getSelectedElement();
            if (resource != null) {
                ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
                if (!cvsResource.isManaged()) {
                    this.createPair(composite, Policy.bind("ResourcePropertiesPage.status"), Policy.bind("ResourcePropertiesPage.notManaged"));
                } else {
                    boolean hasRemote = false;
                    if (cvsResource.isFolder()) {
                        hasRemote = ((ICVSFolder)cvsResource).isCVSFolder();
                    } else {
                        ResourceSyncInfo info = cvsResource.getSyncInfo();
                        if (info != null && !info.isAdded()) {
                            hasRemote = true;
                        }
                    }
                    this.createPair(composite, Policy.bind("ResourcePropertiesPage.status"), hasRemote ? Policy.bind("ResourcePropertiesPage.versioned") : Policy.bind("ResourcePropertiesPage.notVersioned"));
                }
            }
        }
        catch (TeamException e) {
            this.createPair(composite, Policy.bind("ResourcePropertiesPage.error"), e.getMessage());
        }
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    protected void createPair(Composite parent, String left, String right) {
        Label label = new Label(parent, 0);
        label.setText(left);
        label = new Label(parent, 0);
        label.setText(right);
        label.setToolTipText(right);
        label.setLayoutData((Object)new GridData(768));
    }

    protected IResource getSelectedElement() {
        IResource resource = null;
        IAdaptable element = this.getElement();
        if (element instanceof IResource) {
            resource = (IResource)element;
        } else {
            Object adapter;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = element.getAdapter((Class)clazz)) instanceof IResource) {
                resource = (IResource)adapter;
            }
        }
        return resource;
    }
}

