/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.team.internal.ccvs.core.CVSAnnotateBlock;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.HistoryView;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.RemoteAnnotationEditorInput;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class AnnotateView
extends ViewPart
implements ISelectionChangedListener {
    ITextEditor editor;
    HistoryView historyView;
    IWorkbenchPage page;
    ListViewer viewer;
    IDocument document;
    Collection cvsAnnotateBlocks;
    ICVSResource cvsResource;
    InputStream contents;
    IStructuredSelection previousListSelection;
    ITextSelection previousTextSelection;
    boolean lastSelectionWasText = false;
    public static final String VIEW_ID = "org.eclipse.team.ccvs.ui.AnnotateView";
    private Composite top;
    private IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (AnnotateView.this.editor != null && part == AnnotateView.this.editor) {
                AnnotateView.this.disconnect();
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };

    public void createPartControl(Composite parent) {
        this.top = parent;
        Label label = new Label(this.top, 64);
        label.setText(Policy.bind("CVSAnnotateView.viewInstructions"));
        label.setLayoutData((Object)new GridData(1808));
        this.top.layout();
    }

    public void showAnnotations(ICVSResource cvsResource, Collection cvsAnnotateBlocks, InputStream contents) throws InvocationTargetException {
        this.showAnnotations(cvsResource, cvsAnnotateBlocks, contents, true);
    }

    public void showAnnotations(ICVSResource cvsResource, Collection cvsAnnotateBlocks, InputStream contents, boolean useHistoryView) throws InvocationTargetException {
        this.disconnect();
        Control[] oldChildren = this.top.getChildren();
        if (oldChildren != null) {
            int i = 0;
            while (i < oldChildren.length) {
                oldChildren[i].dispose();
                ++i;
            }
        }
        this.viewer = new ListViewer(this.top, 772);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        WorkbenchHelp.setHelp((Control)this.viewer.getControl(), (String)"org.eclipse.team.cvs.ui.annotate_view_context");
        this.top.layout();
        this.cvsResource = cvsResource;
        this.contents = contents;
        this.cvsAnnotateBlocks = cvsAnnotateBlocks;
        this.page = CVSUIPlugin.getActivePage();
        this.viewer.setInput((Object)cvsAnnotateBlocks);
        this.editor = (ITextEditor)this.openEditor();
        IDocumentProvider provider = this.editor.getDocumentProvider();
        this.document = provider.getDocument((Object)this.editor.getEditorInput());
        this.setPartName(Policy.bind("CVSAnnotateView.showFileAnnotation", new Object[]{cvsResource.getName()}));
        try {
            IResource localResource = cvsResource.getIResource();
            if (localResource != null) {
                this.setTitleToolTip(localResource.getFullPath().toString());
            } else {
                this.setTitleToolTip(cvsResource.getName());
            }
        }
        catch (CVSException cVSException) {
            this.setTitleToolTip(cvsResource.getName());
        }
        if (!useHistoryView) {
            return;
        }
        try {
            this.historyView = (HistoryView)this.page.showView("org.eclipse.team.ccvs.ui.HistoryView");
            this.historyView.showHistory((ICVSRemoteFile)CVSWorkspaceRoot.getRemoteResourceFor((ICVSResource)cvsResource), false);
        }
        catch (PartInitException e) {
            throw new InvocationTargetException(e);
        }
        catch (CVSException e) {
            throw new InvocationTargetException(e);
        }
    }

    protected void disconnect() {
        if (this.editor != null) {
            if (this.editor.getSelectionProvider() instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)this.editor.getSelectionProvider()).removePostSelectionChangedListener((ISelectionChangedListener)this);
            }
            this.editor.getSite().getPage().removePartListener(this.partListener);
            this.editor = null;
            this.document = null;
        }
    }

    public static AnnotateView openInActivePerspective() throws PartInitException {
        return (AnnotateView)CVSUIPlugin.getActivePage().showView(VIEW_ID);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelection() instanceof IStructuredSelection) {
            this.listSelectionChanged((IStructuredSelection)event.getSelection());
        } else if (event.getSelection() instanceof ITextSelection) {
            this.textSelectionChanged((ITextSelection)event.getSelection());
        }
    }

    public void dispose() {
        this.disconnect();
    }

    private void textSelectionChanged(ITextSelection selection) {
        this.lastSelectionWasText = true;
        CVSAnnotateBlock match = null;
        Iterator iterator = this.cvsAnnotateBlocks.iterator();
        while (iterator.hasNext()) {
            CVSAnnotateBlock block = (CVSAnnotateBlock)iterator.next();
            if (!block.contains(selection.getStartLine())) continue;
            match = block;
            break;
        }
        if (match == null) {
            return;
        }
        StructuredSelection listSelection = new StructuredSelection(match);
        this.viewer.setSelection((ISelection)listSelection, true);
    }

    private void listSelectionChanged(IStructuredSelection selection) {
        ISelectionProvider selectionProvider;
        if (this.editor == null || this.editor.getSelectionProvider() == null) {
            try {
                this.contents.reset();
                this.showAnnotations(this.cvsResource, this.cvsAnnotateBlocks, this.contents, false);
            }
            catch (InvocationTargetException invocationTargetException) {
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
        if ((selectionProvider = this.editor.getSelectionProvider()) == null) {
            return;
        }
        ITextSelection textSelection = (ITextSelection)selectionProvider.getSelection();
        CVSAnnotateBlock listSelection = (CVSAnnotateBlock)selection.getFirstElement();
        if (textSelection.getStartLine() == listSelection.getStartLine() && textSelection.getEndLine() == listSelection.getEndLine() && selection.equals(this.previousListSelection)) {
            return;
        }
        if (!this.lastSelectionWasText) {
            try {
                int start = this.document.getLineOffset(listSelection.getStartLine());
                int end = this.document.getLineOffset(listSelection.getEndLine() + 1);
                this.editor.selectAndReveal(start, end - start);
                if (this.editor != null && !this.page.isPartVisible((IWorkbenchPart)this.editor)) {
                    this.page.activate((IWorkbenchPart)this.editor);
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        if (this.historyView != null) {
            this.historyView.selectRevision(listSelection.getRevision());
        }
        this.lastSelectionWasText = false;
    }

    private IEditorPart openEditor() throws InvocationTargetException {
        IEditorPart part;
        String id;
        ICVSRemoteFile file;
        try {
            file = (ICVSRemoteFile)CVSWorkspaceRoot.getRemoteResourceFor((ICVSResource)this.cvsResource);
        }
        catch (CVSException e1) {
            throw new InvocationTargetException(e1);
        }
        IEditorRegistry registry = CVSUIPlugin.getPlugin().getWorkbench().getEditorRegistry();
        IEditorDescriptor descriptor = registry.getDefaultEditor(file.getName());
        if (descriptor == null || !(descriptor instanceof EditorDescriptor) || !((EditorDescriptor)descriptor).isInternal()) {
            id = "org.eclipse.ui.DefaultTextEditor";
        } else {
            try {
                Object obj = IDEWorkbenchPlugin.createExtension((IConfigurationElement)((EditorDescriptor)descriptor).getConfigurationElement(), (String)"class");
                id = obj instanceof ITextEditor ? descriptor.getId() : "org.eclipse.ui.DefaultTextEditor";
            }
            catch (CoreException coreException) {
                id = "org.eclipse.ui.DefaultTextEditor";
            }
        }
        try {
            if (this.editor != null && this.editor instanceof IReusableEditor && this.page.isPartVisible((IWorkbenchPart)this.editor) && this.editor.getSite().getId().equals(id)) {
                ((IReusableEditor)this.editor).setInput((IEditorInput)new RemoteAnnotationEditorInput(file, this.contents));
                part = this.editor;
            } else {
                if (this.editor != null) {
                    this.page.closeEditor((IEditorPart)this.editor, false);
                    this.editor = null;
                }
                part = this.page.openEditor((IEditorInput)new RemoteAnnotationEditorInput(file, this.contents), id);
            }
        }
        catch (PartInitException e) {
            throw new InvocationTargetException(e);
        }
        ITextEditor editor = (ITextEditor)part;
        if (editor.getSelectionProvider() instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)editor.getSelectionProvider()).addPostSelectionChangedListener((ISelectionChangedListener)this);
        }
        part.getSite().getPage().addPartListener(this.partListener);
        return part;
    }

    public void setFocus() {
    }
}

