/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.launchConfigurations;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ant.core.Property;
import org.eclipse.ant.internal.ui.launchConfigurations.AntLaunchConfigurationMessages;
import org.eclipse.ant.internal.ui.launchConfigurations.AntTargetsTab;
import org.eclipse.ant.internal.ui.model.AntUIImages;
import org.eclipse.ant.internal.ui.model.AntUIPlugin;
import org.eclipse.ant.internal.ui.model.AntUtil;
import org.eclipse.ant.internal.ui.preferences.AntPropertiesBlock;
import org.eclipse.ant.internal.ui.preferences.IAntBlockContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class AntPropertiesTab
extends AbstractLaunchConfigurationTab
implements IAntBlockContainer {
    private Button useDefaultButton;
    private AntPropertiesBlock antPropertiesBlock = new AntPropertiesBlock(this);

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setFont(parent.getFont());
        this.setControl((Control)top);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.ant.ui.ant_properties_tab_context");
        top.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(768);
        top.setLayoutData((Object)gridData);
        this.createChangeProperties(top);
        Composite propertiesBlockComposite = new Composite(top, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        propertiesBlockComposite.setLayout((Layout)layout);
        propertiesBlockComposite.setLayoutData((Object)new GridData(1808));
        this.antPropertiesBlock.createControl(propertiesBlockComposite, AntLaunchConfigurationMessages.getString("AntPropertiesTab.&Properties__6"), AntLaunchConfigurationMessages.getString("AntPropertiesTab.Property_f&iles__7"));
        Dialog.applyDialogFont((Control)top);
    }

    private void createChangeProperties(Composite top) {
        this.useDefaultButton = this.createCheckButton(top, AntLaunchConfigurationMessages.getString("AntPropertiesTab.6"));
        this.useDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AntPropertiesTab.this.toggleUseDefaultProperties();
                AntPropertiesTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void toggleUseDefaultProperties() {
        boolean enable = !this.useDefaultButton.getSelection();
        this.antPropertiesBlock.setEnabled(enable);
    }

    public Image getImage() {
        return AntUIImages.getImage("org.eclipse.ant.ui.IMG_PROPERTY");
    }

    public String getName() {
        return AntLaunchConfigurationMessages.getString("AntPropertiesTab.P&roperties_8");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.setErrorMessage(null);
        this.setMessage(null);
        Map properties = null;
        try {
            properties = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_PROPERTIES", null);
        }
        catch (CoreException ce) {
            AntUIPlugin.log(AntLaunchConfigurationMessages.getString("AntPropertiesTab.Error_reading_configuration_9"), ce);
        }
        String propertyFiles = null;
        try {
            propertyFiles = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_PROPERTY_FILES", null);
        }
        catch (CoreException ce) {
            AntUIPlugin.log(AntLaunchConfigurationMessages.getString("AntPropertiesTab.Error_reading_configuration_9"), ce);
        }
        if (properties == null && propertyFiles == null) {
            this.antPropertiesBlock.setTablesEnabled(false);
            this.useDefaultButton.setSelection(true);
        } else {
            this.useDefaultButton.setSelection(false);
            this.antPropertiesBlock.populatePropertyViewer(properties);
            String[] files = AntUtil.parseString(propertyFiles, ",");
            this.antPropertiesBlock.setPropertyFilesInput(files);
        }
        this.toggleUseDefaultProperties();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.useDefaultButton.getSelection()) {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_PROPERTIES", null);
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_PROPERTY_FILES", null);
            return;
        }
        Object[] items = this.antPropertiesBlock.getProperties();
        HashMap<String, String> properties = null;
        if (items.length > 0) {
            properties = new HashMap<String, String>(items.length);
            int i = 0;
            while (i < items.length) {
                Property property = (Property)items[i];
                properties.put(property.getName(), property.getValue(false));
                ++i;
            }
        }
        configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_PROPERTIES", properties);
        items = this.antPropertiesBlock.getPropertyFiles();
        String files = null;
        if (items.length > 0) {
            StringBuffer buff = new StringBuffer();
            int i = 0;
            while (i < items.length) {
                String path = (String)items[i];
                buff.append(path);
                buff.append(',');
                ++i;
            }
            files = buff.toString();
        }
        configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_PROPERTY_FILES", files);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void setMessage(String message) {
        super.setMessage(message);
    }

    public void setErrorMessage(String message) {
        super.setErrorMessage(message);
    }

    public Button createPushButton(Composite parent, String buttonText) {
        return super.createPushButton(parent, buttonText, null);
    }

    public void update() {
        this.updateTargetsTab();
        this.updateLaunchConfigurationDialog();
    }

    private void updateTargetsTab() {
        ILaunchConfigurationTab[] tabs = this.getLaunchConfigurationDialog().getTabs();
        int i = 0;
        while (i < tabs.length) {
            ILaunchConfigurationTab tab = tabs[i];
            if (tab instanceof AntTargetsTab) {
                ((AntTargetsTab)tab).setDirty(true);
                break;
            }
            ++i;
        }
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }
}

