/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.Iterator;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.RuntimeClasspathAction;
import org.eclipse.jdt.internal.debug.ui.launcher.RuntimeClasspathViewer;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;

public class AttachSourceAction
extends RuntimeClasspathAction {
    private IRuntimeClasspathEntry[] fEntries;

    public AttachSourceAction(RuntimeClasspathViewer viewer, int style) {
        super(style == 16 ? ActionMessages.getString("AttachSourceAction.2") : ActionMessages.getString("AttachSourceAction.3"), viewer);
    }

    public void run() {
        IClasspathEntry classpathEntry = BuildPathDialogAccess.configureSourceAttachment((Shell)this.getShell(), (IClasspathEntry)this.fEntries[0].getClasspathEntry());
        if (classpathEntry != null) {
            int i = 0;
            while (i < this.fEntries.length) {
                IRuntimeClasspathEntry entry = this.fEntries[i];
                entry.setSourceAttachmentPath(classpathEntry.getSourceAttachmentPath());
                entry.setSourceAttachmentRootPath(classpathEntry.getSourceAttachmentRootPath());
                this.getViewer().refresh(entry);
                ++i;
            }
            this.getViewer().notifyChanged();
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        this.fEntries = new IRuntimeClasspathEntry[selection.size()];
        Iterator iterator = selection.iterator();
        int i = 0;
        block3: while (iterator.hasNext()) {
            Object selected = iterator.next();
            if (selected instanceof IRuntimeClasspathEntry) {
                IRuntimeClasspathEntry entry = (IRuntimeClasspathEntry)selected;
                int type = entry.getType();
                switch (type) {
                    case 2: 
                    case 3: {
                        this.fEntries[i] = entry;
                        ++i;
                        continue block3;
                    }
                    default: {
                        return false;
                    }
                }
            }
            return false;
        }
        return selection.size() > 0;
    }
}

