/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.model;

import java.net.URL;
import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroContainer;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroElement;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroPage;
import org.eclipse.ui.internal.intro.impl.model.IntroAnchor;
import org.eclipse.ui.internal.intro.impl.model.IntroExtensionContent;
import org.eclipse.ui.internal.intro.impl.model.IntroGroup;
import org.eclipse.ui.internal.intro.impl.model.IntroHomePage;
import org.eclipse.ui.internal.intro.impl.model.IntroPage;
import org.eclipse.ui.internal.intro.impl.model.IntroPartPresentation;
import org.eclipse.ui.internal.intro.impl.model.IntroURLParser;
import org.eclipse.ui.internal.intro.impl.model.loader.IntroContentParser;
import org.eclipse.ui.internal.intro.impl.model.loader.ModelLoaderUtil;
import org.eclipse.ui.internal.intro.impl.util.Log;
import org.eclipse.ui.internal.intro.impl.util.StringUtil;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IntroModelRoot
extends AbstractIntroContainer {
    public static final int CURRENT_PAGE_PROPERTY_ID = 1;
    private static final String ATT_CONTENT = "content";
    private boolean hasValidConfig = true;
    private boolean isdynamicIntro;
    private IntroPartPresentation introPartPresentation;
    private IntroHomePage homePage;
    private String currentPageId;
    private IntroHomePage standbyPage;
    private IConfigurationElement[] configExtensionElements;
    private ListenerList propChangeListeners = new ListenerList(2);

    public IntroModelRoot(IConfigurationElement configElement, IConfigurationElement[] configExtensionElements) {
        super(configElement);
        this.configExtensionElements = configExtensionElements;
    }

    public void loadModel() {
        this.getChildren();
    }

    protected void loadChildren() {
        this.children = new Vector();
        Log.info("Loading Intro plugin model....");
        IConfigurationElement presentationElement = this.loadPresentation();
        if (presentationElement == null) {
            this.setModelState(true, false, false);
            Log.warning("Could not find presentation element in intro config.");
            return;
        }
        this.introPartPresentation = new IntroPartPresentation(presentationElement);
        this.children.add(this.introPartPresentation);
        this.introPartPresentation.setParent(this);
        Document document = this.loadDOM(this.getCfgElement());
        if (document == null) {
            this.setModelState(true, false, false);
            return;
        }
        this.loadPages(document, this.getBundle());
        this.loadSharedGroups(document, this.getBundle());
        this.setModelState(true, true, this.getHomePage().isDynamic());
    }

    public void setPresentation(IntroPartPresentation presentation) {
        this.introPartPresentation = presentation;
        presentation.setParent(this);
        this.children.set(0, presentation);
    }

    protected void resolveChildren() {
        this.resolveConfigExtensions();
        this.resolved = true;
    }

    private IConfigurationElement loadPresentation() {
        IConfigurationElement[] presentationElements = this.getCfgElement().getChildren("presentation");
        IConfigurationElement presentationElement = ModelLoaderUtil.validateSingleContribution(presentationElements, "home-page-id");
        return presentationElement;
    }

    private void loadPages(Document dom, Bundle bundle) {
        String homePageId = this.getPresentation().getHomePageId();
        String standbyPageId = this.getPresentation().getStandbyPageId();
        Element[] pages = ModelLoaderUtil.getElementsByTagName(dom, "page");
        int i = 0;
        while (i < pages.length) {
            Element pageElement = pages[i];
            if (pageElement.getAttribute("id").equals(homePageId)) {
                this.homePage = new IntroHomePage(pageElement, bundle);
                this.homePage.setParent(this);
                this.currentPageId = this.homePage.getId();
                this.children.add(this.homePage);
            } else if (pageElement.getAttribute("id").equals(standbyPageId)) {
                this.standbyPage = new IntroHomePage(pageElement, bundle);
                this.standbyPage.setParent(this);
                this.standbyPage.setStandbyPage(true);
                this.children.add(this.standbyPage);
            } else {
                IntroPage page = new IntroPage(pageElement, bundle);
                page.setParent(this);
                this.children.add(page);
            }
            ++i;
        }
    }

    private void loadSharedGroups(Document dom, Bundle bundle) {
        Element[] groups = ModelLoaderUtil.getElementsByTagName(dom, "group");
        int i = 0;
        while (i < groups.length) {
            IntroGroup group = new IntroGroup(groups[i], bundle);
            group.setParent(this);
            this.children.add(group);
            ++i;
        }
    }

    private void resolveConfigExtensions() {
        int i = 0;
        while (i < this.configExtensionElements.length) {
            Element extensionContentElement;
            Bundle bundle = ModelLoaderUtil.getBundleFromConfigurationElement(this.configExtensionElements[i]);
            Document dom = this.loadDOM(this.configExtensionElements[i]);
            if (dom != null && (extensionContentElement = this.loadExtensionContent(dom, bundle)) != null) {
                if (extensionContentElement.hasAttribute("failed")) {
                    this.children.add(new IntroExtensionContent(extensionContentElement, bundle));
                } else {
                    Element[] pages = ModelLoaderUtil.getElementsByTagName(dom, "page");
                    int j = 0;
                    while (j < pages.length) {
                        IntroPage page = new IntroPage(pages[j], bundle);
                        page.setParent(this);
                        this.children.add(page);
                        ++j;
                    }
                    this.loadSharedGroups(dom, bundle);
                }
            }
            ++i;
        }
    }

    private Element loadExtensionContent(Document dom, Bundle bundle) {
        Element[] extensionContents = ModelLoaderUtil.getElementsByTagName(dom, "extensionContent");
        Element extensionContentElement = ModelLoaderUtil.validateSingleContribution(extensionContents, "path");
        if (extensionContentElement == null) {
            return null;
        }
        IntroExtensionContent extensionContent = new IntroExtensionContent(extensionContentElement, bundle);
        String path = extensionContent.getPath();
        AbstractIntroElement target = this.findTarget(this, path);
        if (target == null || !target.isOfType(8192)) {
            extensionContentElement.setAttribute("failed", "true");
        } else {
            IntroAnchor targetAnchor = (IntroAnchor)target;
            this.insertAnchorChildren(targetAnchor, extensionContent, bundle);
            this.handleExtensionStyleInheritence(targetAnchor, extensionContent);
        }
        return extensionContentElement;
    }

    private void insertAnchorChildren(IntroAnchor anchor, IntroExtensionContent extensionContent, Bundle bundle) {
        AbstractIntroContainer anchorParent = (AbstractIntroContainer)anchor.getParent();
        anchorParent.insertElementsBefore(extensionContent.getChildren(), bundle, anchor);
    }

    private void handleExtensionStyleInheritence(IntroAnchor anchor, IntroExtensionContent extension) {
        AbstractIntroContainer targetContainer = (AbstractIntroContainer)anchor.getParent();
        if (targetContainer.getType() == 16 && targetContainer.getParent().getType() == 1) {
            return;
        }
        String style = extension.getStyle();
        if (style != null) {
            targetContainer.getParentPage().addStyle(style);
        }
        if ((style = extension.getAltStyle()) != null) {
            Bundle bundle = extension.getBundle();
            targetContainer.getParentPage().addAltStyle(style, bundle);
        }
    }

    private void setModelState(boolean loaded, boolean hasValidConfig, boolean isdynamicIntro) {
        this.loaded = loaded;
        this.hasValidConfig = hasValidConfig;
        this.isdynamicIntro = isdynamicIntro;
    }

    public boolean hasValidConfig() {
        return this.hasValidConfig;
    }

    public IntroPartPresentation getPresentation() {
        return this.introPartPresentation;
    }

    public IntroHomePage getHomePage() {
        return this.homePage;
    }

    public IntroHomePage getStandbyPage() {
        return this.standbyPage;
    }

    public IntroPage[] getPages() {
        return (IntroPage[])this.getChildrenOfType(8);
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isDynamic() {
        return this.isdynamicIntro;
    }

    public String getCurrentPageId() {
        return this.currentPageId;
    }

    public boolean setCurrentPageId(String pageId, boolean fireEvent) {
        if (pageId == this.currentPageId) {
            return true;
        }
        AbstractIntroPage page = (AbstractIntroPage)this.findChild(pageId, 12);
        if (page == null && !pageId.equals(this.homePage.getId())) {
            Log.warning("Could not find Intro page with id: " + pageId);
            return false;
        }
        this.currentPageId = pageId;
        if (fireEvent) {
            this.firePropertyChange(1);
        }
        return true;
    }

    public boolean setCurrentPageId(String pageId) {
        return this.setCurrentPageId(pageId, true);
    }

    public void addPropertyListener(IPropertyListener l) {
        this.propChangeListeners.add((Object)l);
    }

    public void firePropertyChange(final int propertyId) {
        Object[] array = this.propChangeListeners.getListeners();
        int i = 0;
        while (i < array.length) {
            final IPropertyListener l = (IPropertyListener)array[i];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.propertyChanged((Object)this, propertyId);
                }

                public void handleException(Throwable e) {
                    super.handleException(e);
                    IntroModelRoot.this.propChangeListeners.remove((Object)l);
                }
            });
            ++i;
        }
    }

    public void removePropertyListener(IPropertyListener l) {
        this.propChangeListeners.remove((Object)l);
    }

    public AbstractIntroPage getCurrentPage() {
        if (!this.isdynamicIntro) {
            return null;
        }
        AbstractIntroPage page = (AbstractIntroPage)this.findChild(this.currentPageId, 12);
        if (page != null) {
            return page;
        }
        if (this.currentPageId.equals(this.homePage.getId())) {
            return this.homePage;
        }
        return null;
    }

    public int getType() {
        return 1;
    }

    protected Document loadDOM(IConfigurationElement cfgElement) {
        String content = cfgElement.getAttribute(ATT_CONTENT);
        content = IntroModelRoot.getPluginLocation(content, cfgElement);
        Document document = new IntroContentParser(content).getDocument();
        return document;
    }

    protected static String resolveURL(String url, String pluginId) {
        Bundle bundle = null;
        if (pluginId != null) {
            bundle = Platform.getBundle((String)pluginId);
        }
        return IntroModelRoot.resolveURL(url, bundle);
    }

    protected static String resolveURL(String url, IConfigurationElement element) {
        Bundle bundle = ModelLoaderUtil.getBundleFromConfigurationElement(element);
        return IntroModelRoot.resolveURL(url, bundle);
    }

    protected static String resolveURL(String url, Bundle bundle) {
        if (url == null) {
            return null;
        }
        IntroURLParser parser = new IntroURLParser(url);
        if (parser.hasProtocol()) {
            return url;
        }
        return IntroModelRoot.getPluginLocation(url, bundle);
    }

    public static String getPluginLocation(String resource, IConfigurationElement element) {
        Bundle bundle = ModelLoaderUtil.getBundleFromConfigurationElement(element);
        return IntroModelRoot.getPluginLocation(resource, bundle);
    }

    public static String getPluginLocation(String resource, Bundle bundle) {
        if (resource == null || !ModelLoaderUtil.bundleHasValidState(bundle)) {
            return null;
        }
        URL localLocation = null;
        try {
            localLocation = Platform.find((Bundle)bundle, (IPath)new Path(resource));
            if (localLocation == null) {
                String msg = StringUtil.concat("Could not find resource: ", resource, " in ", ModelLoaderUtil.getBundleHeader(bundle, "Bundle-Name")).toString();
                Log.warning(msg);
                return resource;
            }
            localLocation = Platform.asLocalURL((URL)localLocation);
            return localLocation.toExternalForm();
        }
        catch (Exception e) {
            String msg = StringUtil.concat("Failed to load resource: ", resource, " from ", ModelLoaderUtil.getBundleHeader(bundle, "Bundle-Name")).toString();
            Log.error(msg, e);
            return resource;
        }
    }

    public static String getPluginLocation(String resource, String pluginId) {
        Bundle bundle = Platform.getBundle((String)pluginId);
        return IntroModelRoot.getPluginLocation(resource, bundle);
    }
}

