; testing and examples for mephisto.constraint module.
; $Id: constraint-test.scm,v 1.1 2006/06/01 06:46:08 torus Exp $

(add-load-path "../lib")

(use mephisto.constraint)

(use gauche.test)

;;;;;;;;;;;;;;;;;

(define (unique-constraint)
  (make-constraint
   (a b)
   ((a => b) a)
;;    ((b => a) b)
;;    ((b => a) b)
;;    ((b => a) b)
   ))

(define (make-multiplier)
  (make-constraint
   (m1 m2 product)
   ((m1 m2 => product) (* m1 m2))
   ((m1 product => m2) (/ product m1))
   ((m2 product => m1) (/ product m2))
   ))

(define (make-adder)
  (make-constraint
   (a1 a2 sum)
   ((a1 a2 => sum) (+ a1 a2))
   ((a1 sum => a2) (- sum a1))
   ((a2 sum => a1) (- sum a2))
   ))

(define mul1 (make-multiplier))
(define mul2 (make-multiplier))
(define adder (make-adder))

(define u (make-wire))
(define v (make-wire))
(define w (make-constant-wire 9))
(define x (make-constant-wire 5))
(define y (make-constant-wire 32))

(define c (make-wire))
(define f (make-wire))

((mul1 'connect) c w u)
((mul2 'connect) v x u)
((adder 'connect) v y f)

(test-start "mephisto.constraint")
(test-module 'mephisto.constraint)

((c 'set) 25)
(test* "c->f" 77 (f 'get))

(wires-set-value! (f 212))

(test* "f->c" 100 (c 'get))

;;;;

(define-wires a b c)

(((make-constraint (a b c)
		   ((a b => c)
		    (* a (+ b 1))))
  'connect) a b c)

(wires-set-value! (a 2) (b 3))
(test* "(* a (+ b 1))" 8 (c 'get))

(test-end)
