package jp.co.kpscorp.meema.test;

import java.util.LinkedHashSet;
import java.util.Set;

import jp.co.kpscorp.meema.service.TestService;
import jp.co.kpscorp.meema.service.TestServiceCode;
import jp.co.kpscorp.meema.service.TestServiceExcel;
import jp.co.kpscorp.meema.service.TestServiceTest;
import junit.framework.TestCase;

/**
 *<strong> TestService実行サンプル。</strong>
 *<p>
 * 詳細は　http://meema.sourceforge.jp を参照してください。
 * @author katsusuke
 *
 */
public class ShohinTest extends TestCase {

	public void testShohin() throws Exception {

		// TestService コード生成
		TestService ts = new TestServiceCode("src",
				"jp.co.kpscorp.meema.test.asserts");
		// コード生成 ここまで

		// TestService コード実行
//		TestService ts = new TestServiceTest("jp.co.kpscorp.meema.test.asserts");
		// コード実行 ここまで
		
		// TestService Excelに出力
//		TestService ts = new TestServiceExcel("excel");
		// Excelに出力 ここまで

		// 商品メーカーCD:01の商品メーカー作成
		ShohinMaker maker = new ShohinMaker("01", null);
		// 商品メーカーの商品作成（1個目）
		Shohin shohin = new Shohin("001", "abcd", new Double(1000), "b",
				new Integer(0), maker);
		// 商品メーカーの商品作成（2個目）
		Shohin shohin2 = new Shohin("002", "xyz1", new Double(999.9), "x",
				new Integer(0), maker);
		// 商品メーカーの商品作成（3個目）
		Shohin shohin3 = new Shohin("003", "opqr", new Double(777), "o",
				new Integer(0), maker);
		// LinkedHashSetを作成
		Set set = new LinkedHashSet();
		// Setに商品を3個add
		set.add(shohin);
		set.add(shohin2);
		set.add(shohin3);
		// 商品メーカーへ商品のSetを関連づける
		maker.setShohins(set);
		// 1個目の商品を引数にTestServiceの実行（二つ目の引数は識別子）
		ts.exec(shohin, "case01");
	}
}
